/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.logic.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.po.hbm.TbRole;
import com.netsteadfast.greenstep.po.hbm.TbRolePermission;
import com.netsteadfast.greenstep.po.hbm.TbSysCode;
import com.netsteadfast.greenstep.po.hbm.TbSysMenuRole;
import com.netsteadfast.greenstep.po.hbm.TbSysProg;
import com.netsteadfast.greenstep.po.hbm.TbUserRole;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.service.IRolePermissionService;
import com.netsteadfast.greenstep.service.IRoleService;
import com.netsteadfast.greenstep.service.ISysCodeService;
import com.netsteadfast.greenstep.service.ISysMenuRoleService;
import com.netsteadfast.greenstep.service.ISysProgService;
import com.netsteadfast.greenstep.service.IUserRoleService;
import com.netsteadfast.greenstep.service.logic.IRoleLogicService;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.RolePermissionVO;
import com.netsteadfast.greenstep.vo.RoleVO;
import com.netsteadfast.greenstep.vo.SysCodeVO;
import com.netsteadfast.greenstep.vo.SysMenuRoleVO;
import com.netsteadfast.greenstep.vo.SysProgVO;
import com.netsteadfast.greenstep.vo.UserRoleVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ServiceAuthority(check=true)
@Service(value="core.service.logic.RoleLogicService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class RoleLogicServiceImpl
extends BaseLogicService
implements IRoleLogicService {
    protected Logger logger = Logger.getLogger(RoleLogicServiceImpl.class);
    private static final String DEFAULT_ROLE_CODE = "BSC_CONF001";
    private static final String DEFAULT_ROLE_CODE_TYPE = "BSC";
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService;
    private IRoleService<RoleVO, TbRole, String> roleService;
    private IRolePermissionService<RolePermissionVO, TbRolePermission, String> rolePermissionService;
    private IUserRoleService<UserRoleVO, TbUserRole, String> userRoleService;
    private IAccountService<AccountVO, TbAccount, String> accountService;
    private ISysProgService<SysProgVO, TbSysProg, String> sysProgService;
    private ISysMenuRoleService<SysMenuRoleVO, TbSysMenuRole, String> sysMenuRoleService;

    public ISysCodeService<SysCodeVO, TbSysCode, String> getSysCodeService() {
        return this.sysCodeService;
    }

    @Autowired
    @Resource(name="core.service.SysCodeService")
    @Required
    public void setSysCodeService(ISysCodeService<SysCodeVO, TbSysCode, String> sysCodeService) {
        this.sysCodeService = sysCodeService;
    }

    public IRoleService<RoleVO, TbRole, String> getRoleService() {
        return this.roleService;
    }

    @Autowired
    @Resource(name="core.service.RoleService")
    @Required
    public void setRoleService(IRoleService<RoleVO, TbRole, String> roleService) {
        this.roleService = roleService;
    }

    public IRolePermissionService<RolePermissionVO, TbRolePermission, String> getRolePermissionService() {
        return this.rolePermissionService;
    }

    @Autowired
    @Resource(name="core.service.RolePermissionService")
    @Required
    public void setRolePermissionService(IRolePermissionService<RolePermissionVO, TbRolePermission, String> rolePermissionService) {
        this.rolePermissionService = rolePermissionService;
    }

    public IUserRoleService<UserRoleVO, TbUserRole, String> getUserRoleService() {
        return this.userRoleService;
    }

    @Autowired
    @Resource(name="core.service.UserRoleService")
    @Required
    public void setUserRoleService(IUserRoleService<UserRoleVO, TbUserRole, String> userRoleService) {
        this.userRoleService = userRoleService;
    }

    public IAccountService<AccountVO, TbAccount, String> getAccountService() {
        return this.accountService;
    }

    @Autowired
    @Resource(name="core.service.AccountService")
    @Required
    public void setAccountService(IAccountService<AccountVO, TbAccount, String> accountService) {
        this.accountService = accountService;
    }

    public ISysProgService<SysProgVO, TbSysProg, String> getSysProgService() {
        return this.sysProgService;
    }

    @Autowired
    @Resource(name="core.service.SysProgService")
    @Required
    public void setSysProgService(ISysProgService<SysProgVO, TbSysProg, String> sysProgService) {
        this.sysProgService = sysProgService;
    }

    public ISysMenuRoleService<SysMenuRoleVO, TbSysMenuRole, String> getSysMenuRoleService() {
        return this.sysMenuRoleService;
    }

    @Autowired
    @Resource(name="core.service.SysMenuRoleService")
    @Required
    public void setSysMenuRoleService(ISysMenuRoleService<SysMenuRoleVO, TbSysMenuRole, String> sysMenuRoleService) {
        this.sysMenuRoleService = sysMenuRoleService;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<RoleVO> create(RoleVO role) throws ServiceException, Exception {
        if (role == null || super.isBlank(role.getRole())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        role.setDescription(super.defaultString(role.getDescription()));
        if (role.getDescription().length() > 500) {
            role.setDescription(role.getDescription().substring(0, 500));
        }
        return this.roleService.saveObject(role);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<RoleVO> update(RoleVO role) throws ServiceException, Exception {
        if (role == null || super.isBlank(role.getRole())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        role.setDescription(super.defaultString(role.getDescription()));
        if (role.getDescription().length() > 500) {
            role.setDescription(role.getDescription().substring(0, 500));
        }
        return this.roleService.updateObject(role);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> delete(RoleVO role) throws ServiceException, Exception {
        if (role == null || super.isBlank(role.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<RoleVO> rResult = this.roleService.findObjectByOid(role);
        if (rResult.getValue() == null) {
            throw new ServiceException(rResult.getSystemMessage().getValue());
        }
        role = rResult.getValue();
        if ("admin".equals(role.getRole()) || "*".equals(role.getRole())) {
            throw new ServiceException("Administrator or super role cannot delete!");
        }
        String defaultUserRole = this.getDefaultUserRole();
        if (role.getRole().equals(defaultUserRole)) {
            throw new ServiceException("Default user role: " + defaultUserRole + " cannot delete!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("role", role.getRole());
        this.deleteRolePermission(params);
        this.deleteUserRole(params);
        this.deleteSysMenuRole(params);
        return this.roleService.deleteObject(role);
    }

    private void deleteRolePermission(Map<String, Object> params) throws ServiceException, Exception {
        List permList = this.rolePermissionService.findListByParams(params);
        if (permList == null || permList.size() < 1) {
            return;
        }
        for (TbRolePermission rolePerm : permList) {
            this.rolePermissionService.delete(rolePerm);
        }
    }

    private void deleteUserRole(Map<String, Object> params) throws ServiceException, Exception {
        List userRoleList = this.userRoleService.findListByParams(params);
        if (userRoleList == null || userRoleList.size() < 1) {
            return;
        }
        for (TbUserRole userRole : userRoleList) {
            this.userRoleService.delete(userRole);
        }
    }

    private void deleteSysMenuRole(Map<String, Object> params) throws ServiceException, Exception {
        List menuRoleList = this.sysMenuRoleService.findListByParams(params);
        if (menuRoleList == null || menuRoleList.size() < 1) {
            return;
        }
        for (TbSysMenuRole sysMenuRole : menuRoleList) {
            this.sysMenuRoleService.delete(sysMenuRole);
        }
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<RolePermissionVO> createPermission(RolePermissionVO permission, String roleOid) throws ServiceException, Exception {
        if (super.isBlank(roleOid) || permission == null || super.isBlank(permission.getPermission())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        RoleVO role = new RoleVO();
        role.setOid(roleOid);
        DefaultResult<RoleVO> rResult = this.roleService.findObjectByOid(role);
        if (rResult.getValue() == null) {
            throw new ServiceException(rResult.getSystemMessage().getValue());
        }
        role = rResult.getValue();
        if ("admin".equals(role.getRole()) || "*".equals(role.getRole())) {
            throw new ServiceException("Administrator or super role no need to set permission!");
        }
        permission.setRole(role.getRole());
        if (super.defaultString(permission.getDescription()).length() > 500) {
            permission.setDescription(permission.getDescription().substring(0, 500));
        }
        return this.rolePermissionService.saveObject(permission);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deletePermission(RolePermissionVO permission) throws ServiceException, Exception {
        if (permission == null || super.isBlank(permission.getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.rolePermissionService.deleteObject(permission);
    }

    @Override
    public Map<String, List<RoleVO>> findForAccountRoleEnableAndAll(String accountOid) throws ServiceException, Exception {
        if (super.isBlank(accountOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AccountVO account = new AccountVO();
        account.setOid(accountOid);
        DefaultResult<AccountVO> aResult = this.accountService.findObjectByOid(account);
        if (aResult.getValue() == null) {
            throw new ServiceException(aResult.getSystemMessage().getValue());
        }
        account = aResult.getValue();
        HashMap<String, List<RoleVO>> roleMap = new HashMap<String, List<RoleVO>>();
        List<RoleVO> enableRole = this.roleService.findForAccount(account.getAccount());
        List<RoleVO> allRole = this.roleService.findForAll();
        roleMap.put("enable", enableRole);
        roleMap.put("all", allRole);
        return roleMap;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> updateUserRole(String accountOid, List<String> roles) throws ServiceException, Exception {
        if (super.isBlank(accountOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AccountVO account = new AccountVO();
        account.setOid(accountOid);
        DefaultResult<AccountVO> aResult = this.accountService.findObjectByOid(account);
        if (aResult.getValue() == null) {
            throw new ServiceException(aResult.getSystemMessage().getValue());
        }
        account = aResult.getValue();
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(false);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        this.deleteUserRoleByAccount(account);
        int i = 0;
        while (roles != null && i < roles.size()) {
            String roleOid = roles.get(i).trim();
            if (!super.isBlank(roleOid)) {
                RoleVO role = new RoleVO();
                role.setOid(roleOid);
                DefaultResult<RoleVO> rResult = this.roleService.findObjectByOid(role);
                if (rResult.getValue() == null) {
                    throw new ServiceException(rResult.getSystemMessage().getValue());
                }
                role = rResult.getValue();
                UserRoleVO userRole = new UserRoleVO();
                userRole.setAccount(account.getAccount());
                userRole.setRole(role.getRole());
                userRole.setDescription("");
                DefaultResult<UserRoleVO> urResult = this.userRoleService.saveObject(userRole);
                if (urResult.getValue() == null) {
                    throw new ServiceException(urResult.getSystemMessage().getValue());
                }
            }
            ++i;
        }
        result.setValue(true);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    private void deleteUserRoleByAccount(AccountVO account) throws ServiceException, Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account.getAccount());
        List userRoleList = this.userRoleService.findListByParams(params);
        if (userRoleList == null || userRoleList.size() < 1) {
            return;
        }
        for (TbUserRole userRole : userRoleList) {
            this.userRoleService.delete(userRole);
        }
    }

    @Override
    public Map<String, List<RoleVO>> findForProgramRoleEnableAndAll(String programOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(programOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysProgVO sysProg = new SysProgVO();
        sysProg.setOid(programOid);
        DefaultResult<SysProgVO> spResult = this.sysProgService.findObjectByOid(sysProg);
        if (spResult.getValue() == null) {
            throw new ServiceException(spResult.getSystemMessage().getValue());
        }
        sysProg = spResult.getValue();
        HashMap<String, List<RoleVO>> roleMap = new HashMap<String, List<RoleVO>>();
        List<RoleVO> enableRole = this.roleService.findForProgram(sysProg.getProgId());
        List<RoleVO> allRole = this.roleService.findForAll();
        roleMap.put("enable", enableRole);
        roleMap.put("all", allRole);
        return roleMap;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> updateMenuRole(String progOid, List<String> roles) throws ServiceException, Exception {
        if (super.isBlank(progOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysProgVO sysProg = new SysProgVO();
        sysProg.setOid(progOid);
        DefaultResult<SysProgVO> spResult = this.sysProgService.findObjectByOid(sysProg);
        if (spResult.getValue() == null) {
            throw new ServiceException(spResult.getSystemMessage().getValue());
        }
        sysProg = spResult.getValue();
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(false);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("progId", sysProg.getProgId());
        List sysMenuRoleList = this.sysMenuRoleService.findListByParams(params);
        int i = 0;
        while (sysMenuRoleList != null && i < sysMenuRoleList.size()) {
            TbSysMenuRole sysMenuRole = (TbSysMenuRole)sysMenuRoleList.get(i);
            this.sysMenuRoleService.delete(sysMenuRole);
            ++i;
        }
        i = 0;
        while (roles != null && i < roles.size()) {
            String roleOid = roles.get(i).trim();
            if (!super.isBlank(roleOid)) {
                RoleVO role = new RoleVO();
                role.setOid(roleOid);
                DefaultResult<RoleVO> rResult = this.roleService.findObjectByOid(role);
                if (rResult.getValue() == null) {
                    throw new ServiceException(rResult.getSystemMessage().getValue());
                }
                role = rResult.getValue();
                SysMenuRoleVO sysMenuRole = new SysMenuRoleVO();
                sysMenuRole.setProgId(sysProg.getProgId());
                sysMenuRole.setRole(role.getRole());
                DefaultResult<SysMenuRoleVO> smrResult = this.sysMenuRoleService.saveObject(sysMenuRole);
                if (smrResult.getValue() == null) {
                    throw new ServiceException(smrResult.getSystemMessage().getValue());
                }
            }
            ++i;
        }
        result.setValue(true);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<RoleVO> copyAsNew(String fromRoleOid, RoleVO role) throws ServiceException, Exception {
        if (role == null || super.isBlank(role.getRole()) || super.isBlank(fromRoleOid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        super.setStringValueMaxLength(role, "description", 500);
        DefaultResult<RoleVO> result = this.roleService.saveObject(role);
        RoleVO oldRole = new RoleVO();
        oldRole.setOid(fromRoleOid);
        DefaultResult<RoleVO> fromResult = this.roleService.findObjectByOid(oldRole);
        if (fromResult.getValue() == null) {
            throw new ServiceException(fromResult.getSystemMessage().getValue());
        }
        oldRole = fromResult.getValue();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("role", oldRole.getRole());
        List permissions = this.rolePermissionService.findListByParams(paramMap);
        int i = 0;
        while (permissions != null && i < permissions.size()) {
            RolePermissionVO permission = new RolePermissionVO();
            this.rolePermissionService.fillToValueObject(permission, permissions.get(i));
            permission.setOid(null);
            permission.setRole(result.getValue().getRole());
            this.rolePermissionService.saveObject(permission);
            ++i;
        }
        List menuRoles = this.sysMenuRoleService.findListByParams(paramMap);
        int i2 = 0;
        while (menuRoles != null && i2 < menuRoles.size()) {
            SysMenuRoleVO menuRole = new SysMenuRoleVO();
            this.sysMenuRoleService.fillToValueObject(menuRole, menuRoles.get(i2));
            menuRole.setOid(null);
            menuRole.setRole(result.getValue().getRole());
            this.sysMenuRoleService.saveObject(menuRole);
            ++i2;
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    public String getDefaultUserRole() throws ServiceException, Exception {
        String role = "";
        SysCodeVO sysCode = new SysCodeVO();
        sysCode.setType(DEFAULT_ROLE_CODE_TYPE);
        sysCode.setCode(DEFAULT_ROLE_CODE);
        DefaultResult<SysCodeVO> result = this.sysCodeService.findByUK(sysCode);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        sysCode = result.getValue();
        role = sysCode.getParam1();
        if (super.isBlank(role)) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("role", role);
        if (this.roleService.countByParams(params) != 1L) {
            throw new ServiceException(SysMessageUtil.get("MSG_STD0005"));
        }
        return role;
    }
}

