/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.ISysUploadDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysUpload;
import com.netsteadfast.greenstep.service.ISysUploadService;
import com.netsteadfast.greenstep.vo.SysUploadVO;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.SysUploadService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SysUploadServiceImpl
extends BaseService<SysUploadVO, TbSysUpload, String>
implements ISysUploadService<SysUploadVO, TbSysUpload, String> {
    protected Logger logger = Logger.getLogger(SysUploadServiceImpl.class);
    private ISysUploadDAO<TbSysUpload, String> sysUploadDAO;

    public ISysUploadDAO<TbSysUpload, String> getSysUploadDAO() {
        return this.sysUploadDAO;
    }

    @Autowired
    @Resource(name="core.dao.SysUploadDAO")
    @Required
    public void setSysUploadDAO(ISysUploadDAO<TbSysUpload, String> sysUploadDAO) {
        this.sysUploadDAO = sysUploadDAO;
    }

    @Override
    protected IBaseDAO<TbSysUpload, String> getBaseDataAccessObject() {
        return this.sysUploadDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "sysUpload.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "sysUpload.vo2po";
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public int deleteTmpContent(String system) throws ServiceException, Exception {
        if (StringUtils.isBlank(system)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.sysUploadDAO.deleteTmpContent(system);
    }

    @Override
    public DefaultResult<SysUploadVO> findForNoByteContent(String oid) throws ServiceException, Exception {
        if (StringUtils.isBlank(oid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        SysUploadVO upload = this.sysUploadDAO.findForNoByteContent(oid);
        DefaultResult<SysUploadVO> result = new DefaultResult<SysUploadVO>();
        if (upload != null && !StringUtils.isBlank(upload.getOid())) {
            result.setValue(upload);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0001")));
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> updateTypeOnly(String oid, String type) throws ServiceException, Exception {
        if (StringUtils.isBlank(oid) || StringUtils.isBlank(type)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        result.setValue(Boolean.FALSE);
        if (this.sysUploadDAO.updateTypeOnly(oid, type, this.getAccountId()) != 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0008"));
        }
        result.setValue(Boolean.TRUE);
        result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        return result;
    }
}

