/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.ISysMenuDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysMenu;
import com.netsteadfast.greenstep.service.ISysMenuService;
import com.netsteadfast.greenstep.vo.SysMenuVO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.SysMenuService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class SysMenuServiceImpl
extends BaseService<SysMenuVO, TbSysMenu, String>
implements ISysMenuService<SysMenuVO, TbSysMenu, String> {
    protected Logger logger = Logger.getLogger(SysMenuServiceImpl.class);
    private ISysMenuDAO<TbSysMenu, String> sysMenuDAO;

    public ISysMenuDAO<TbSysMenu, String> getSysMenuDAO() {
        return this.sysMenuDAO;
    }

    @Autowired
    @Resource(name="core.dao.SysMenuDAO")
    @Required
    public void setSysMenuDAO(ISysMenuDAO<TbSysMenu, String> sysMenuDAO) {
        this.sysMenuDAO = sysMenuDAO;
    }

    @Override
    protected IBaseDAO<TbSysMenu, String> getBaseDataAccessObject() {
        return this.sysMenuDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "sysMenu.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "sysMenu.vo2po";
    }

    @Override
    public DefaultResult<List<SysMenuVO>> findForMenuGenerator(String progSystem, String account) throws ServiceException, Exception {
        if (StringUtils.isBlank(progSystem)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        DefaultResult<List<SysMenuVO>> result = new DefaultResult<List<SysMenuVO>>();
        List<SysMenuVO> searchList = this.sysMenuDAO.findForMenuGenerator(progSystem, account);
        if (searchList != null && searchList.size() > 0) {
            result.setValue(searchList);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }
}

