/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.service.impl;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.PageOf;
import com.netsteadfast.greenstep.base.model.QueryResult;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.service.BaseService;
import com.netsteadfast.greenstep.dao.IRoleDAO;
import com.netsteadfast.greenstep.po.hbm.TbRole;
import com.netsteadfast.greenstep.service.IRoleService;
import com.netsteadfast.greenstep.vo.RoleVO;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="core.service.RoleService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true)
public class RoleServiceImpl
extends BaseService<RoleVO, TbRole, String>
implements IRoleService<RoleVO, TbRole, String> {
    protected Logger logger = Logger.getLogger(RoleServiceImpl.class);
    private IRoleDAO<TbRole, String> roleDAO;

    public IRoleDAO<TbRole, String> getRoleDAO() {
        return this.roleDAO;
    }

    @Autowired
    @Resource(name="core.dao.RoleDAO")
    @Required
    public void setRoleDAO(IRoleDAO<TbRole, String> roleDAO) {
        this.roleDAO = roleDAO;
    }

    @Override
    protected IBaseDAO<TbRole, String> getBaseDataAccessObject() {
        return this.roleDAO;
    }

    @Override
    public String getMapperIdPo2Vo() {
        return "role.po2vo";
    }

    @Override
    public String getMapperIdVo2Po() {
        return "role.vo2po";
    }

    private Map<String, Object> getQueryGridParameter(SearchValue searchValue) throws Exception {
        return super.getQueryParamHandler(searchValue).fullEquals4TextField("role").getValue();
    }

    @Override
    public QueryResult<List<RoleVO>> findGridResult(SearchValue searchValue, PageOf pageOf) throws ServiceException, Exception {
        if (searchValue == null || pageOf == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        Map<String, Object> params = this.getQueryGridParameter(searchValue);
        int limit = Integer.parseInt(pageOf.getShowRow());
        int offset = (Integer.parseInt(pageOf.getSelect()) - 1) * limit;
        QueryResult<List<RoleVO>> result = this.roleDAO.findPageQueryResultByQueryName("findRolePageGrid", params, offset, limit);
        pageOf.setCountSize(String.valueOf(result.getRowCount()));
        pageOf.toCalculateSize();
        return result;
    }

    @Override
    public List<RoleVO> findForAccount(String account) throws ServiceException, Exception {
        if (StringUtils.isBlank(account)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.roleDAO.findForAccount(account);
    }

    @Override
    public List<RoleVO> findForAll() throws ServiceException, Exception {
        return this.roleDAO.findForAll();
    }

    @Override
    public List<RoleVO> findForProgram(String progId) throws ServiceException, Exception {
        if (StringUtils.isBlank(progId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return this.roleDAO.findForProgram(progId);
    }

    @Override
    public Map<String, String> findForMap(boolean pleaseSelect, boolean normal) throws ServiceException, Exception {
        Map<String, String> dataMap = this.providedSelectZeroDataMap(pleaseSelect);
        List roles = this.findListByParams(null);
        int i = 0;
        while (roles != null && i < roles.size()) {
            TbRole role = (TbRole)roles.get(i);
            if (!normal || !"admin".equals(role.getRole()) && !"*".equals(role.getRole())) {
                dataMap.put(role.getOid(), role.getRole());
            }
            ++i;
        }
        return dataMap;
    }
}

