/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.publish.impl;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.sys.UserAccountHttpSessionSupport;
import com.netsteadfast.greenstep.model.TemplateResultObj;
import com.netsteadfast.greenstep.model.WebMessagePublishBaseObj;
import com.netsteadfast.greenstep.po.hbm.TbSysMsgNotice;
import com.netsteadfast.greenstep.publish.BaseMessagePublishService;
import com.netsteadfast.greenstep.service.ISysMsgNoticeService;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.util.TemplateUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.SysMsgNoticeConfigVO;
import com.netsteadfast.greenstep.vo.SysMsgNoticeVO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SystemMessagePublishServiceImpl
implements BaseMessagePublishService {
    private ServletRequest request;
    private static ISysMsgNoticeService<SysMsgNoticeVO, TbSysMsgNotice, String> sysMsgNoticeService;
    private static Map<String, String> messagePublishMap;
    private static Map<String, List<TbSysMsgNotice>> accountSysMsgNoticeListMap;
    private static Map<String, List<TbSysMsgNotice>> globalSysMsgNoticeListMap;
    private static final int SLEEP = 600000;
    private static final int CLEAR_TIME = 14400000;
    private static int c;

    static {
        messagePublishMap = new HashMap<String, String>();
        accountSysMsgNoticeListMap = new HashMap<String, List<TbSysMsgNotice>>();
        globalSysMsgNoticeListMap = new HashMap<String, List<TbSysMsgNotice>>();
        c = 0;
        sysMsgNoticeService = (ISysMsgNoticeService)AppContext.getBean("core.service.SysMsgNoticeService");
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    accountSysMsgNoticeListMap.clear();
                    globalSysMsgNoticeListMap.clear();
                    if (c * 600000 >= 14400000) {
                        c = 0;
                        messagePublishMap.clear();
                    }
                    c = c + 1;
                    try {
                        Thread.sleep(600000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private List<TbSysMsgNotice> loadGlobalSysMsgNoticeData(String msgId, String account) throws ServiceException, Exception {
        if (globalSysMsgNoticeListMap.get(account) != null) {
            return globalSysMsgNoticeListMap.get(account);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        params.put("isGlobal", "Y");
        params.put("toAccount", account);
        params.put("msgId", msgId);
        orderParams.put("date", "ASC");
        orderParams.put("time", "ASC");
        List<TbSysMsgNotice> searchList = sysMsgNoticeService.findListByParams2(params, null, null, orderParams);
        if (searchList == null) {
            searchList = new ArrayList();
        }
        globalSysMsgNoticeListMap.put(account, searchList);
        return searchList;
    }

    private List<TbSysMsgNotice> loadAccountSysMsgNoticeData(String msgId, String account) throws ServiceException, Exception {
        if (accountSysMsgNoticeListMap.get(account) != null) {
            return accountSysMsgNoticeListMap.get(account);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        params.put("isGlobal", "N");
        params.put("toAccount", account);
        params.put("msgId", msgId);
        orderParams.put("date", "ASC");
        orderParams.put("time", "ASC");
        List<TbSysMsgNotice> searchList = sysMsgNoticeService.findListByParams2(params, null, null, orderParams);
        if (searchList == null) {
            searchList = new ArrayList();
        }
        accountSysMsgNoticeListMap.put(account, searchList);
        return searchList;
    }

    @Override
    public WebMessagePublishBaseObj execute(SysMsgNoticeConfigVO config, ServletRequest request) throws ServiceException, Exception {
        this.request = request;
        WebMessagePublishBaseObj publishObj = new WebMessagePublishBaseObj();
        String account = request.getParameter("account");
        String refreshUUID = StringUtils.defaultString(request.getParameter("refreshUUID")).trim();
        String sessionId = ((HttpServletRequest)request).getSession().getId();
        AccountVO accountObj = (AccountVO)UserAccountHttpSessionSupport.get((HttpServletRequest)request);
        if (StringUtils.isBlank(this.getId()) || StringUtils.isBlank(account) || accountObj == null) {
            return publishObj;
        }
        if (!account.equals(accountObj.getAccount())) {
            return publishObj;
        }
        List<TbSysMsgNotice> globalSysMsgNoticeList = this.loadGlobalSysMsgNoticeData(config.getMsgId(), "*");
        List<TbSysMsgNotice> accountSysMsgNoticeList = this.loadAccountSysMsgNoticeData(config.getMsgId(), account);
        String globalMsg = this.process(sessionId, refreshUUID, globalSysMsgNoticeList);
        String personalMsg = this.process(sessionId, refreshUUID, accountSysMsgNoticeList);
        publishObj.setIsAuthorize("Y");
        publishObj.setLogin("Y");
        publishObj.setSuccess("Y");
        publishObj.setMessage(String.valueOf(globalMsg) + personalMsg);
        return publishObj;
    }

    private String process(String sessionId, String refreshUUID, List<TbSysMsgNotice> sysMsgNotices) throws ServiceException, Exception {
        if (sysMsgNotices == null || sysMsgNotices.size() < 1) {
            return "";
        }
        Date sysDate = new Date();
        StringBuilder sb = new StringBuilder();
        for (TbSysMsgNotice msgNotice : sysMsgNotices) {
            String key = String.valueOf(sessionId) + ":uuid_" + refreshUUID + ":" + msgNotice.getNoticeId();
            if (messagePublishMap.get(key) != null || !this.isPublishDateTimeRange(msgNotice, sysDate)) continue;
            TbSysMsgNotice dataObj = new TbSysMsgNotice();
            dataObj.setTitle(TemplateUtils.escapeHtml4TemplateHtmlContent(msgNotice.getTitle()));
            dataObj.setMessage(TemplateUtils.escapeHtml4TemplateHtmlContent(msgNotice.getMessage()));
            TemplateResultObj result = TemplateUtils.getResult("TPLMSG0002", dataObj);
            dataObj = null;
            sb.append(result.getContent());
            messagePublishMap.put(key, "Y");
        }
        return sb.toString();
    }

    private boolean isPublishDateTimeRange(TbSysMsgNotice sysMsgNotice, Date sysDate) throws Exception {
        String timeStr = sysMsgNotice.getTime();
        String dateStr = sysMsgNotice.getDate();
        String systemDateStr = SimpleUtils.getStrYMD(sysDate, "");
        boolean f = false;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sysDate);
        int nowTimeNum = Integer.parseInt(String.valueOf(StringUtils.leftPad(String.valueOf(calendar.get(11)), 2, "0")) + StringUtils.leftPad(String.valueOf(calendar.get(12)), 2, "0"));
        int nowDateNum = Integer.parseInt(systemDateStr);
        String[] dateTmp = dateStr.split("-");
        String[] timeTmp = timeStr.split("-");
        int begDateNum = Integer.parseInt(dateTmp[0]);
        int endDateNum = Integer.parseInt(dateTmp[1]);
        int begTimeNum = Integer.parseInt(timeTmp[0]);
        int endTimeNum = Integer.parseInt(timeTmp[1]);
        if (nowDateNum >= begDateNum && nowDateNum <= endDateNum || dateStr.equals("00000000-00000000")) {
            if ("0000-0000".equals(timeStr)) {
                f = true;
            }
            if (nowTimeNum >= begTimeNum && nowTimeNum <= endTimeNum) {
                f = true;
            }
        }
        return f;
    }

    @Override
    public String getId() throws Exception {
        return StringUtils.defaultString(this.request.getParameter("id")).trim();
    }
}

