/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.job.impl;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.job.BaseJob;
import com.netsteadfast.greenstep.util.ApplicationSiteUtils;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.SysVO;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.web.context.ContextLoader;

@DisallowConcurrentExecution
public class ClearTempDataJobImpl
extends BaseJob
implements Job {
    protected static Logger log = Logger.getLogger(ClearTempDataJobImpl.class);

    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        block22: {
            List<SysVO> systems;
            block21: {
                if (ContextLoader.getCurrentWebApplicationContext() == null) {
                    log.warn("ApplicationContext no completed, AppContext.getApplicationContext() == null");
                    return;
                }
                log.info("begin....");
                if (this.checkCurrentlyExecutingJobs(context, this)) {
                    log.warn("Same schedule job, current working...");
                    return;
                }
                this.loginForBackgroundProgram();
                systems = ApplicationSiteUtils.getSystems();
                if (systems != null && systems.size() >= 1) break block21;
                try {
                    this.logoutForBackgroundProgram();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            try {
                for (SysVO sys : systems) {
                    UploadSupportUtils.cleanTempUpload(sys.getSysId());
                }
                NamedParameterJdbcTemplate namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)AppContext.getBean("namedParameterJdbcTemplate");
                HashMap paramMap = new HashMap();
                namedParameterJdbcTemplate.update("delete from bb_swot_report_mst", paramMap);
                namedParameterJdbcTemplate.update("delete from bb_swot_report_dtl", paramMap);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                try {
                    this.logoutForBackgroundProgram();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                break block22;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.logoutForBackgroundProgram();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                this.logoutForBackgroundProgram();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.info("end....");
    }
}

