/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.dao.impl;

import com.netsteadfast.greenstep.base.dao.BaseDAO;
import com.netsteadfast.greenstep.dao.ISysProgDAO;
import com.netsteadfast.greenstep.po.hbm.TbSysProg;
import com.netsteadfast.greenstep.vo.SysProgVO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository(value="core.dao.SysProgDAO")
public class SysProgDAOImpl
extends BaseDAO<TbSysProg, String>
implements ISysProgDAO<TbSysProg, String> {
    @Override
    public SysProgVO findNameForProgId(String progId) throws Exception {
        return (SysProgVO)this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.SysProgVO(tsp.name) FROM TbSysProg tsp WHERE tsp.progId = :progId ").setString("progId", progId).uniqueResult();
    }

    @Override
    public List<SysProgVO> findForInTheFolderMenuItems(String progSystem, String menuParentOid, String itemType) throws Exception {
        String hqlStr = "SELECT new com.netsteadfast.greenstep.vo.SysProgVO(tsp.oid, tsp.progId, tsp.name, tsp.progSystem, tsp.icon) ";
        hqlStr = String.valueOf(hqlStr) + "FROM TbSysProg tsp WHERE tsp.progId IN ( ";
        hqlStr = !StringUtils.isBlank(menuParentOid) ? String.valueOf(hqlStr) + "\tSELECT tsm.progId from TbSysMenu tsm WHERE tsm.parentOid = :parentOid " : String.valueOf(hqlStr) + "\tSELECT tsm.progId from TbSysMenu tsm ";
        hqlStr = String.valueOf(hqlStr) + ") ";
        hqlStr = String.valueOf(hqlStr) + "AND tsp.progSystem = :progSystem AND tsp.editMode='N' ";
        if (!StringUtils.isBlank(itemType)) {
            hqlStr = String.valueOf(hqlStr) + "AND tsp.itemType = :itemType ";
        }
        hqlStr = String.valueOf(hqlStr) + "ORDER BY tsp.progId ASC ";
        Query query = this.getCurrentSession().createQuery(hqlStr);
        if (!StringUtils.isBlank(menuParentOid)) {
            query.setString("parentOid", menuParentOid);
        }
        if (!StringUtils.isBlank(itemType)) {
            query.setString("itemType", itemType);
        }
        query.setString("progSystem", progSystem);
        return query.list();
    }

    @Override
    public List<SysProgVO> findForSystemItems(String progSystem) throws Exception {
        return this.getCurrentSession().createQuery("SELECT new com.netsteadfast.greenstep.vo.SysProgVO(tsp.oid, tsp.progId, tsp.name, tsp.progSystem, tsp.icon) FROM TbSysProg tsp WHERE tsp.progSystem = :progSystem AND tsp.editMode='N' AND tsp.itemType='ITEM' ORDER BY tsp.progId ASC ").setString("progSystem", progSystem).list();
    }
}

