/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service.logic;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.service.logic.BaseLogicService;
import com.netsteadfast.greenstep.po.hbm.TbAccount;
import com.netsteadfast.greenstep.po.hbm.TbRole;
import com.netsteadfast.greenstep.po.hbm.TbSysUpload;
import com.netsteadfast.greenstep.po.hbm.TbUserRole;
import com.netsteadfast.greenstep.service.IAccountService;
import com.netsteadfast.greenstep.service.IRoleService;
import com.netsteadfast.greenstep.service.ISysUploadService;
import com.netsteadfast.greenstep.service.IUserRoleService;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import com.netsteadfast.greenstep.vo.AccountVO;
import com.netsteadfast.greenstep.vo.RoleVO;
import com.netsteadfast.greenstep.vo.SysUploadVO;
import com.netsteadfast.greenstep.vo.UserRoleVO;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public abstract class CoreBaseLogicService
extends BaseLogicService {
    private IAccountService<AccountVO, TbAccount, String> accountService;
    private IRoleService<RoleVO, TbRole, String> roleService;
    private IUserRoleService<UserRoleVO, TbUserRole, String> userRoleService;
    private ISysUploadService<SysUploadVO, TbSysUpload, String> sysUploadService;

    public IAccountService<AccountVO, TbAccount, String> getAccountService() {
        return this.accountService;
    }

    @Autowired
    @Resource(name="core.service.AccountService")
    @Required
    public void setAccountService(IAccountService<AccountVO, TbAccount, String> accountService) {
        this.accountService = accountService;
    }

    public IRoleService<RoleVO, TbRole, String> getRoleService() {
        return this.roleService;
    }

    @Autowired
    @Resource(name="core.service.RoleService")
    @Required
    public void setRoleService(IRoleService<RoleVO, TbRole, String> roleService) {
        this.roleService = roleService;
    }

    public IUserRoleService<UserRoleVO, TbUserRole, String> getUserRoleService() {
        return this.userRoleService;
    }

    @Autowired
    @Resource(name="core.service.UserRoleService")
    @Required
    public void setUserRoleService(IUserRoleService<UserRoleVO, TbUserRole, String> userRoleService) {
        this.userRoleService = userRoleService;
    }

    public ISysUploadService<SysUploadVO, TbSysUpload, String> getSysUploadService() {
        return this.sysUploadService;
    }

    @Autowired
    @Resource(name="core.service.SysUploadService")
    @Required
    public void setSysUploadService(ISysUploadService<SysUploadVO, TbSysUpload, String> sysUploadService) {
        this.sysUploadService = sysUploadService;
    }

    public AccountVO findAccountData() throws ServiceException, Exception {
        return this.findAccountData(super.getAccountId());
    }

    public AccountVO findAccountData(String accountId) throws ServiceException, Exception {
        if (super.isBlank(accountId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        AccountVO accountObj = new AccountVO();
        accountObj.setAccount(accountId);
        DefaultResult<AccountVO> result = this.accountService.findByUK(accountObj);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().toString());
        }
        accountObj = result.getValue();
        return accountObj;
    }

    public List<TbUserRole> findUserRoles() throws ServiceException, Exception {
        return this.findUserRoles(super.getAccountId());
    }

    public List<TbUserRole> findUserRoles(String accountId) throws ServiceException, Exception {
        if (super.isBlank(accountId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("account", super.getAccountId());
        return this.userRoleService.findListByParams(paramMap);
    }

    public SysUploadVO findUploadData(String oid) throws ServiceException, Exception {
        if (super.isBlank(oid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return UploadSupportUtils.findUpload(oid);
    }

    public SysUploadVO findUploadDataForNoByteContent(String oid) throws ServiceException, Exception {
        if (super.isBlank(oid)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0001"));
        }
        return UploadSupportUtils.findUploadNoByteContent(oid);
    }
}

