/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.interceptor;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.model.AccountObj;
import com.netsteadfast.greenstep.base.model.ControllerMethodAuthority;
import com.netsteadfast.greenstep.base.sys.IUSessLogHelper;
import com.netsteadfast.greenstep.base.sys.USessLogHelperImpl;
import com.netsteadfast.greenstep.base.sys.UserAccountHttpSessionSupport;
import com.netsteadfast.greenstep.base.sys.UserCurrentCookie;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="greenstep.web.interceptor.UserLoginInterceptor")
@Scope(value="prototype")
public class UserLoginInterceptor
extends AbstractInterceptor {
    protected static Logger logger = Logger.getLogger(UserLoginInterceptor.class);
    private static final long serialVersionUID = -115850491560281565L;
    private IUSessLogHelper uSessLogHelper = new USessLogHelperImpl();
    private AccountObj accountObj = null;

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        ActionContext actionContext = actionInvocation.getInvocationContext();
        Map<String, Object> session = actionContext.getSession();
        this.accountObj = (AccountObj)session.get("SESSION_GSCORE_ACCOUNT");
        Map<String, String> dataMap = UserCurrentCookie.getCurrentData((HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest"));
        String currentId = StringUtils.defaultString(dataMap.get("currentId"));
        String accountId = StringUtils.defaultString(dataMap.get("account"));
        if (this.accountObj != null && !StringUtils.isBlank(this.accountObj.getAccount())) {
            String sessSysCurrentId;
            if (StringUtils.isBlank(currentId)) {
                currentId = "NULL";
            }
            if (!currentId.equals(sessSysCurrentId = (String)session.get("SESSION_GSCORE_SYSCURRENT_ID"))) {
                logger.warn("currentId: " + currentId + " not equals session variable currentId: " + sessSysCurrentId);
                return this.redirectLogin(actionInvocation, session, currentId, accountId);
            }
            if (this.uSessLogHelper.countByCurrent(this.accountObj.getAccount(), currentId) < 1L) {
                return this.redirectLogin(actionInvocation, session, currentId, accountId);
            }
            return actionInvocation.invoke();
        }
        return this.redirectLogin(actionInvocation, session, currentId, accountId);
    }

    private String redirectLogin(ActionInvocation actionInvocation, Map<String, Object> session, String currentId, String accountId) throws Exception {
        if (session != null) {
            UserAccountHttpSessionSupport.remove(session);
            if (!Constants.getSystem().equals(Constants.getMainSystem()) && SecurityUtils.getSubject().isAuthenticated()) {
                SecurityUtils.getSubject().logout();
            }
        }
        String header = ServletActionContext.getRequest().getHeader("X-Requested-With");
        String isDojoContentPaneXhrLoad = ServletActionContext.getRequest().getParameter("isDojoxContentPane");
        String isIframeMode = ServletActionContext.getRequest().getParameter("isIframeMode");
        if ("XMLHttpRequest".equalsIgnoreCase(header) && !"Y".equals(isDojoContentPaneXhrLoad)) {
            PrintWriter printWriter = ServletActionContext.getResponse().getWriter();
            printWriter.print("{ \"success\":\"N\",\"message\":\"Please login!\",\"login\":\"N\",\"isAuthorize\":\"N\" }");
            printWriter.flush();
            printWriter.close();
            return null;
        }
        if (!(Constants.getSystem().equals(Constants.getMainSystem()) || StringUtils.isBlank(accountId) || StringUtils.isBlank(currentId) || this.uSessLogHelper.countByCurrent(accountId, currentId) <= 0L)) {
            Method[] methods;
            Annotation[] actionMethodAnnotations = null;
            Method[] methodArray = methods = actionInvocation.getAction().getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (actionInvocation.getProxy().getMethod().equals(method.getName())) {
                    actionMethodAnnotations = method.getAnnotations();
                }
                ++n2;
            }
            String progId = this.getProgramId(actionMethodAnnotations);
            if (!StringUtils.isBlank(progId)) {
                HashMap<String, String> valueStackMap = new HashMap<String, String>();
                valueStackMap.put("progId", progId);
                ActionContext.getContext().getValueStack().push(valueStackMap);
                logger.warn("do page call refreshDojoContentPane event = " + progId);
                return "refreshDojoContentPane";
            }
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = SimpleUtils.getHttpRequestUrl(request);
            logger.warn("redirect URL = " + url);
            ServletActionContext.getResponse().sendRedirect(url);
            return null;
        }
        if ("Y".equals(isIframeMode)) {
            ActionContext.getContext().getValueStack().setValue("errorMessage", "Login session expired, please login again!");
            return "error";
        }
        if ("Y".equals(isDojoContentPaneXhrLoad)) {
            return "loginAgain";
        }
        return "logout";
    }

    private String getProgramId(Annotation[] annotations) {
        String progId = "";
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ControllerMethodAuthority) {
                progId = StringUtils.defaultString(((ControllerMethodAuthority)annotation).programId());
            }
            ++n2;
        }
        if (StringUtils.isBlank(progId)) {
            progId = StringUtils.defaultString(ActionContext.getContext().getValueStack().findString("prog_id"));
        }
        return progId;
    }
}

