/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.interceptor;

import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ControllerMethodAuthority;
import com.netsteadfast.greenstep.sys.SysQueryParamInspectUtils;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="greenstep.web.interceptor.QueryParamInspectInterceptor")
@Scope(value="prototype")
public class QueryParamInspectInterceptor
extends AbstractInterceptor {
    protected static Logger logger = Logger.getLogger(QueryParamInspectInterceptor.class);
    private static final long serialVersionUID = -9147160140755133572L;

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Method[] methods;
        Annotation[] actionMethodAnnotations = null;
        Method[] methodArray = methods = actionInvocation.getAction().getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (actionInvocation.getProxy().getMethod().equals(method.getName())) {
                actionMethodAnnotations = method.getAnnotations();
            }
            ++n2;
        }
        if (actionMethodAnnotations != null && actionMethodAnnotations.length > 0) {
            try {
                this.log(actionInvocation, actionMethodAnnotations);
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return actionInvocation.invoke();
    }

    private void log(ActionInvocation actionInvocation, Annotation[] annotations) throws ServiceException, Exception {
        String progId = "";
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno instanceof ControllerMethodAuthority) {
                progId = ((ControllerMethodAuthority)anno).programId();
            }
            ++n2;
        }
        if (StringUtils.isBlank(progId)) {
            return;
        }
        SysQueryParamInspectUtils.log(Constants.getSystem(), progId, actionInvocation.getProxy().getMethod(), ServletActionContext.getRequest());
    }
}

