/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.action;

import com.netsteadfast.greenstep.base.action.BaseSupportAction;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ControllerException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.ControllerAuthority;
import com.netsteadfast.greenstep.util.UploadSupportUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@ControllerAuthority(check=true)
@Controller(value="core.web.controller.CommonPrintContentAction")
@Scope
public class CommonPrintContentAction
extends BaseSupportAction {
    private static final long serialVersionUID = -5861669971660024741L;
    private String oid = "";
    private String value = "";

    private void loadData() throws ServiceException, Exception {
        byte[] data = UploadSupportUtils.getDataBytes(this.oid);
        this.value = new String(data, "utf-8");
    }

    @Override
    public String execute() throws Exception {
        String forward = "blank";
        try {
            if (StringUtils.isBlank(this.oid)) {
                return forward;
            }
            this.loadData();
            forward = "blankValue";
        }
        catch (AuthorityException | ControllerException | ServiceException e) {
            this.setPageMessage(e.getMessage().toString());
        }
        catch (Exception e) {
            this.exceptionPage(e);
        }
        return forward;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

