/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.action;

import com.netsteadfast.greenstep.base.action.BaseQueryGridJsonAction;
import com.netsteadfast.greenstep.base.action.IBaseAdditionalSupportAction;
import com.netsteadfast.greenstep.base.exception.AuthorityException;
import com.netsteadfast.greenstep.base.exception.ControllerException;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.SystemForm;
import com.netsteadfast.greenstep.util.MenuSupportUtils;
import com.netsteadfast.greenstep.util.SystemFormUtils;
import com.netsteadfast.greenstep.vo.SysFormMethodVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.json.annotations.JSON;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

@SystemForm
@Controller(value="core.web.controller.CommonLoadFormAction")
@Scope
public class CommonLoadFormAction
extends BaseQueryGridJsonAction
implements IBaseAdditionalSupportAction {
    private static final long serialVersionUID = 1616413828281190977L;
    protected Logger logger = Logger.getLogger(CommonLoadFormAction.class);
    private String message = "";
    private String success = "N";
    private Map<String, Object> datas = new HashMap<String, Object>();
    private List<Map<String, String>> items = new ArrayList<Map<String, String>>();
    private String prog_id = "";
    private String form_id = "";
    private String form_method = "";
    private String viewPage = "";
    private String redirectUrl = "";

    public void processExpression(SysFormMethodVO formMethod) throws ControllerException, ServiceException, Exception {
        Map<String, String> resultMap = SystemFormUtils.processExpression(formMethod, this, this.datas, this.getPageOf(), this.getSearchValue(), this.items, this.getFields(), this.getFieldsId(), this.getFieldsMessage(), super.getHttpServletRequest());
        if ("default".equals(formMethod.getResultType())) {
            this.viewPage = SystemFormUtils.getViewPage(resultMap);
        }
        if ("json".equals(formMethod.getResultType())) {
            this.message = SystemFormUtils.getJsonMessage(resultMap);
            this.success = SystemFormUtils.getJsonSuccess(resultMap);
        }
        if ("redirect".equals(formMethod.getResultType())) {
            this.redirectUrl = SystemFormUtils.getRedirectUrl(resultMap);
        }
    }

    @Override
    @JSON(serialize=false)
    @SystemForm
    public String execute() throws Exception {
        String resultName;
        block9: {
            resultName = "searchNoData";
            if (StringUtils.isBlank(this.form_id) || StringUtils.isBlank(this.form_method)) {
                this.message = "no settings data to init form!";
                this.setErrorMessage(this.message);
                return resultName;
            }
            try {
                SysFormMethodVO formMethod = SystemFormUtils.findFormMethod(this.form_id, this.form_method);
                resultName = formMethod.getResultType();
                this.processExpression(formMethod);
            }
            catch (ControllerException ce) {
                this.message = ce.getMessage().toString();
                this.setErrorMessage(this.message);
            }
            catch (AuthorityException ae) {
                this.message = ae.getMessage().toString();
                this.setErrorMessage(this.message);
                if ("default".equals(resultName)) {
                    resultName = "noAuthorith";
                }
            }
            catch (ServiceException se) {
                this.message = se.getMessage().toString();
                this.setErrorMessage(this.message);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getMessage() == null) {
                    this.message = e.toString();
                    this.logger.error(e.toString());
                } else {
                    this.message = e.getMessage().toString();
                    this.logger.error(e.getMessage());
                }
                this.setErrorMessage(this.message);
                this.success = "E";
                if (!"default".equals(resultName)) break block9;
                resultName = "error";
            }
        }
        return resultName;
    }

    @Override
    @JSON
    public String getProgramName() {
        return MenuSupportUtils.getProgramName(this.getProgramId(), this.getLocaleLang());
    }

    @Override
    @JSON
    public String getProgramId() {
        return super.getActionMethodProgramId();
    }

    @Override
    @JSON
    public String getLogin() {
        return super.isAccountLogin();
    }

    @Override
    @JSON
    public String getIsAuthorize() {
        return super.isActionAuthorize();
    }

    @Override
    @JSON
    public String getMessage() {
        return this.message;
    }

    @Override
    @JSON
    public String getSuccess() {
        return this.success;
    }

    @Override
    @JSON
    public List<String> getFieldsId() {
        return this.fieldsId;
    }

    @JSON
    public Map<String, Object> getDatas() {
        return this.datas;
    }

    @Override
    @JSON
    public String getPageOfShowRow() {
        return super.getPageOf().getShowRow();
    }

    @Override
    @JSON
    public String getPageOfSelect() {
        return super.getPageOf().getSelect();
    }

    @Override
    @JSON
    public String getPageOfCountSize() {
        return super.getPageOf().getCountSize();
    }

    @Override
    @JSON
    public String getPageOfSize() {
        return super.getPageOf().getSize();
    }

    @Override
    @JSON
    public List<Map<String, String>> getItems() {
        return this.items;
    }

    @JSON
    public String getProg_id() {
        return this.prog_id;
    }

    public void setProg_id(String prog_id) {
        this.prog_id = prog_id;
    }

    @JSON
    public String getForm_id() {
        return this.form_id;
    }

    public void setForm_id(String form_id) {
        this.form_id = form_id;
    }

    @JSON
    public String getForm_method() {
        return this.form_method;
    }

    public void setForm_method(String form_method) {
        this.form_method = form_method;
    }

    @JSON
    public String getViewPage() {
        return this.viewPage;
    }

    @JSON
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    @JSON
    public Map<String, String> getFieldsMessage() {
        return this.fieldsMessage;
    }
}

