/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.component.ssh.SSHPublicKeyHolder;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBasedSSHKeyVerifier
implements ServerKeyVerifier {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private CamelContext camelContext;
    private boolean failOnUnknownHost;
    private String knownHostsResource;

    public ResourceBasedSSHKeyVerifier(CamelContext camelContext, String knownHostsResource) {
        this(camelContext, knownHostsResource, false);
    }

    public ResourceBasedSSHKeyVerifier(CamelContext camelContext, String knownHostsResource, boolean failOnUnknownHost) {
        this.camelContext = camelContext;
        this.knownHostsResource = knownHostsResource;
        this.failOnUnknownHost = failOnUnknownHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        InputStream knownHostsInputStream;
        block5: {
            boolean bl;
            this.log.debug("Trying to find known_hosts file %s", (Object)this.knownHostsResource);
            knownHostsInputStream = null;
            try {
                boolean match;
                knownHostsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.camelContext, (String)this.knownHostsResource);
                List<String> possibleTokens = this.getKnownHostsFileTokensForSocketAddress(remoteAddress);
                this.log.debug("Trying to mach PublicKey against provided known_hosts file");
                PublicKey matchingKey = this.findKeyForServerToken(knownHostsInputStream, possibleTokens);
                if (matchingKey == null) break block5;
                this.log.debug("Found PublicKey match for server");
                bl = match = Arrays.areEqual((byte[])matchingKey.getEncoded(), (byte[])serverKey.getEncoded());
            }
            catch (IOException ioException) {
                try {
                    this.log.debug(String.format("Could not find known_hosts file %s", this.knownHostsResource), (Throwable)ioException);
                }
                catch (Throwable throwable) {
                    IOHelper.close(knownHostsInputStream);
                    throw throwable;
                }
                IOHelper.close((Closeable)knownHostsInputStream);
            }
            IOHelper.close((Closeable)knownHostsInputStream);
            return bl;
        }
        IOHelper.close((Closeable)knownHostsInputStream);
        if (this.failOnUnknownHost) {
            this.log.warn("Could not find matching key for client session, connection will fail due to configuration");
            return false;
        }
        this.log.warn("Could not find matching key for client session, connection will continue anyway due to configuration");
        return true;
    }

    private PublicKey findKeyForServerToken(InputStream knownHostsInputStream, List<String> possibleTokens) {
        String knowHostsLines = (String)this.camelContext.getTypeConverter().convertTo(String.class, (Object)knownHostsInputStream);
        if (knowHostsLines == null) {
            this.log.warn("Could not read from the known_hosts file input stream");
            return null;
        }
        for (String s : knowHostsLines.split("\n")) {
            String[] parts = s.split(" ");
            if (parts.length != 3) {
                this.log.warn("Found malformed entry in known_hosts file");
                continue;
            }
            String entry = parts[0];
            String key = parts[2];
            for (String serverToken : possibleTokens) {
                if (!entry.contains(serverToken)) continue;
                try {
                    return this.loadKey(key);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    this.log.warn(String.format("Could not load key for server token %s", entry), (Throwable)e);
                }
            }
        }
        return null;
    }

    private List<String> getKnownHostsFileTokensForSocketAddress(SocketAddress remoteAddress) {
        LinkedList<String> returnList = new LinkedList<String>();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
            String hostName = inetSocketAddress.getHostName();
            String ipAddress = inetSocketAddress.getAddress().getHostAddress();
            String remotePort = String.valueOf(inetSocketAddress.getPort());
            returnList.add(hostName);
            returnList.add("[" + hostName + "]:" + remotePort);
            returnList.add(ipAddress);
            returnList.add("[" + ipAddress + "]:" + remotePort);
        }
        return returnList;
    }

    private PublicKey loadKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SSHPublicKeyHolder sshPublicKeyHolder = new SSHPublicKeyHolder();
        byte[] keyByteArray = Base64.getDecoder().decode(key);
        int keyByteArrayCursor = 0;
        byte[] tmpData = new byte[4];
        int tmpCursor = 0;
        boolean getLengthMode = true;
        while (keyByteArrayCursor < keyByteArray.length) {
            if (getLengthMode) {
                if (tmpCursor < 4) {
                    tmpData[tmpCursor] = keyByteArray[keyByteArrayCursor];
                    ++tmpCursor;
                    ++keyByteArrayCursor;
                    continue;
                }
                tmpCursor = 0;
                getLengthMode = false;
                tmpData = new byte[this.byteArrayToInt(tmpData)];
            }
            tmpData[tmpCursor] = keyByteArray[keyByteArrayCursor];
            ++keyByteArrayCursor;
            if (++tmpCursor != tmpData.length) continue;
            sshPublicKeyHolder.push(tmpData);
            getLengthMode = true;
            tmpData = new byte[4];
            tmpCursor = 0;
        }
        return sshPublicKeyHolder.toPublicKey();
    }

    private int byteArrayToInt(byte[] tmpData) {
        return new BigInteger(tmpData).intValue();
    }
}

