/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.editor.AppDefinitionListModelRepresentation;
import org.activiti.app.model.editor.ModelRepresentation;
import org.activiti.app.repository.editor.ModelRepository;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.util.XmlUtil;
import org.activiti.bpmn.BpmnAutoLayout;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.web.multipart.MultipartFile;

public class AbstractModelsResource {
    protected static final String FILTER_SHARED_WITH_ME = "sharedWithMe";
    protected static final String FILTER_SHARED_WITH_OTHERS = "sharedWithOthers";
    protected static final String FILTER_FAVORITE = "favorite";
    protected static final String SORT_NAME_ASC = "nameAsc";
    protected static final String SORT_NAME_DESC = "nameDesc";
    protected static final String SORT_MODIFIED_ASC = "modifiedAsc";
    protected static final int MIN_FILTER_LENGTH = 1;
    private final Logger logger = LoggerFactory.getLogger(AbstractModelsResource.class);
    @Inject
    protected ModelRepository modelRepository;
    @Inject
    protected ModelService modelService;
    @Inject
    protected ObjectMapper objectMapper;
    protected BpmnXMLConverter bpmnXmlConverter = new BpmnXMLConverter();
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();

    public ResultListDataRepresentation getModels(String filter, String sort, Integer modelType, HttpServletRequest request) {
        String filterText = null;
        List params = URLEncodedUtils.parse((String)request.getQueryString(), (Charset)Charset.forName("UTF-8"));
        if (params != null) {
            for (NameValuePair nameValuePair : params) {
                if (!"filterText".equalsIgnoreCase(nameValuePair.getName())) continue;
                filterText = nameValuePair.getValue();
            }
        }
        ArrayList<ModelRepresentation> resultList = new ArrayList<ModelRepresentation>();
        List models = null;
        String validFilter = this.makeValidFilterText(filterText);
        User user = SecurityUtils.getCurrentUserObject();
        models = validFilter != null ? this.modelRepository.findModelsCreatedBy(user.getId(), modelType, validFilter, this.getSort(sort, false)) : this.modelRepository.findModelsCreatedBy(user.getId(), modelType, this.getSort(sort, false));
        if (CollectionUtils.isNotEmpty((Collection)models)) {
            ArrayList<String> addedModelIds = new ArrayList<String>();
            for (Model model : models) {
                if (addedModelIds.contains(model.getId())) continue;
                addedModelIds.add(model.getId());
                ModelRepresentation representation = this.createModelRepresentation((AbstractModel)model);
                resultList.add(representation);
            }
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    public ResultListDataRepresentation getModelsToIncludeInAppDefinition() {
        ArrayList<ModelRepresentation> resultList = new ArrayList<ModelRepresentation>();
        User user = SecurityUtils.getCurrentUserObject();
        ArrayList<String> addedModelIds = new ArrayList<String>();
        List models = this.modelRepository.findModelsCreatedBy(user.getId(), Integer.valueOf(0), this.getSort(null, false));
        if (CollectionUtils.isNotEmpty((Collection)models)) {
            for (Model model : models) {
                if (addedModelIds.contains(model.getId())) continue;
                addedModelIds.add(model.getId());
                ModelRepresentation representation = this.createModelRepresentation((AbstractModel)model);
                resultList.add(representation);
            }
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    public ModelRepresentation importProcessModel(HttpServletRequest request, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".bpmn") || fileName.endsWith(".bpmn20.xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), "UTF-8");
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                BpmnModel bpmnModel = this.bpmnXmlConverter.convertToBpmnModel(xtr);
                if (CollectionUtils.isEmpty((Collection)bpmnModel.getProcesses())) {
                    throw new BadRequestException("No process found in definition " + fileName);
                }
                if (bpmnModel.getLocationMap().size() == 0) {
                    BpmnAutoLayout bpmnLayout = new BpmnAutoLayout(bpmnModel);
                    bpmnLayout.execute();
                }
                ObjectNode modelNode = this.bpmnJsonConverter.convertToJson(bpmnModel);
                Process process = bpmnModel.getMainProcess();
                String name = process.getId();
                if (StringUtils.isNotEmpty((CharSequence)process.getName())) {
                    name = process.getName();
                }
                String description = process.getDocumentation();
                ModelRepresentation model = new ModelRepresentation();
                model.setKey(process.getId());
                model.setName(name);
                model.setDescription(description);
                model.setModelType(Integer.valueOf(0));
                Model newModel = this.modelService.createModel(model, modelNode.toString(), SecurityUtils.getCurrentUserObject());
                return new ModelRepresentation((AbstractModel)newModel);
            }
            catch (BadRequestException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Import failed for " + fileName, (Throwable)e);
                throw new BadRequestException("Import failed for " + fileName + ", error message " + e.getMessage());
            }
        }
        throw new BadRequestException("Invalid file name, only .bpmn and .bpmn20.xml files are supported not " + fileName);
    }

    protected ModelRepresentation createModelRepresentation(AbstractModel model) {
        ModelRepresentation representation = null;
        if (model.getModelType() != null && model.getModelType() == 3) {
            representation = new AppDefinitionListModelRepresentation(model);
            AppDefinition appDefinition = null;
            try {
                appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
            }
            catch (Exception e) {
                this.logger.error("Error deserializing app " + model.getId(), (Throwable)e);
                throw new InternalServerErrorException("Could not deserialize app definition");
            }
            ((AppDefinitionListModelRepresentation)representation).setAppDefinition(appDefinition);
        } else {
            representation = new ModelRepresentation(model);
        }
        return representation;
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 1) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }

    protected Sort getSort(String sort, boolean prefixWithProcessModel) {
        Sort.Direction direction;
        String propName;
        if (SORT_NAME_ASC.equals(sort)) {
            propName = prefixWithProcessModel ? "model.name" : "name";
            direction = Sort.Direction.ASC;
        } else if (SORT_NAME_DESC.equals(sort)) {
            propName = prefixWithProcessModel ? "model.name" : "name";
            direction = Sort.Direction.DESC;
        } else if (SORT_MODIFIED_ASC.equals(sort)) {
            propName = prefixWithProcessModel ? "model.lastUpdated" : "lastUpdated";
            direction = Sort.Direction.ASC;
        } else {
            propName = prefixWithProcessModel ? "model.lastUpdated" : "lastUpdated";
            direction = Sort.Direction.DESC;
        }
        return new Sort(direction, new String[]{propName});
    }
}

