/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.dmn.model.DmnElement;
import org.activiti.dmn.model.DmnExtensionAttribute;

public class DmnExtensionElement
extends DmnElement {
    protected String name;
    protected String namespacePrefix;
    protected String namespace;
    protected String elementText;
    protected Map<String, List<DmnExtensionElement>> childElements = new LinkedHashMap<String, List<DmnExtensionElement>>();
    protected Map<String, List<DmnExtensionAttribute>> attributes = new LinkedHashMap<String, List<DmnExtensionAttribute>>();

    public String getElementText() {
        return this.elementText;
    }

    public void setElementText(String elementText) {
        this.elementText = elementText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, List<DmnExtensionElement>> getChildElements() {
        return this.childElements;
    }

    public void addChildElement(DmnExtensionElement childElement) {
        if (childElement != null && childElement.getName() != null && !childElement.getName().trim().isEmpty()) {
            ArrayList elementList = null;
            if (!this.childElements.containsKey(childElement.getName())) {
                elementList = new ArrayList();
                this.childElements.put(childElement.getName(), elementList);
            }
            this.childElements.get(childElement.getName()).add(childElement);
        }
    }

    public void setChildElements(Map<String, List<DmnExtensionElement>> childElements) {
        this.childElements = childElements;
    }

    public DmnExtensionElement clone() {
        DmnExtensionElement clone = new DmnExtensionElement();
        clone.setValues(this);
        return clone;
    }

    public void setValues(DmnExtensionElement otherElement) {
        this.setName(otherElement.getName());
        this.setNamespacePrefix(otherElement.getNamespacePrefix());
        this.setNamespace(otherElement.getNamespace());
        this.setElementText(otherElement.getElementText());
        this.setAttributes(otherElement.getAttributes());
        this.childElements = new LinkedHashMap<String, List<DmnExtensionElement>>();
        if (otherElement.getChildElements() != null && !otherElement.getChildElements().isEmpty()) {
            for (String key : otherElement.getChildElements().keySet()) {
                List<DmnExtensionElement> otherElementList = otherElement.getChildElements().get(key);
                if (otherElementList == null || otherElementList.isEmpty()) continue;
                ArrayList<DmnExtensionElement> elementList = new ArrayList<DmnExtensionElement>();
                for (DmnExtensionElement dmnExtensionElement : otherElementList) {
                    elementList.add(dmnExtensionElement.clone());
                }
                this.childElements.put(key, elementList);
            }
        }
    }
}

