/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.eigenbase.xom.AssertFailure;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.XOMException;

public class DOMElementParser {
    private DOMWrapper wrapper;
    private DOMWrapper[] children;
    private int currentIndex;
    private DOMWrapper currentChild;
    private int optionIndex;
    private String prefix;
    private Class enclosure;

    public DOMElementParser(DOMWrapper wrapper, String prefix, Class enclosure) throws XOMException {
        this.wrapper = wrapper;
        this.children = wrapper.getElementChildren();
        this.currentIndex = 0;
        this.currentChild = null;
        this.getNextElement();
        this.prefix = prefix;
        if (prefix == null) {
            this.prefix = "";
        }
        this.enclosure = enclosure;
    }

    private void getNextElement() {
        this.currentChild = this.currentIndex >= this.children.length ? null : this.children[this.currentIndex++];
    }

    private void requiredName(String name) throws XOMException {
        String augName = this.prefix + name;
        if (this.currentChild == null) {
            throw new XOMException("Expected <" + augName + "> but found " + "nothing.");
        }
        if (!augName.equalsIgnoreCase(this.currentChild.getTagName())) {
            throw new XOMException("Expected <" + augName + "> but found <" + this.currentChild.getTagName() + ">");
        }
    }

    private boolean optionalName(String name) {
        String augName = this.prefix + name;
        if (this.currentChild == null) {
            return false;
        }
        return augName.equalsIgnoreCase(this.currentChild.getTagName());
    }

    private Class getEnclosureClass(Class clazz) {
        Class<?> thisEnclosure = this.enclosure;
        String className = clazz.getName();
        int dollarPos = className.indexOf(36);
        if (dollarPos >= 0) {
            String encName = className.substring(0, dollarPos);
            try {
                thisEnclosure = Class.forName(encName);
            }
            catch (ClassNotFoundException ex) {
                throw new AssertFailure("Enclosure class " + encName + " not found.");
            }
        }
        return thisEnclosure;
    }

    private boolean nameMatchesClass(Class clazz) throws XOMException {
        Class thisEnclosure = this.getEnclosureClass(clazz);
        Class nextClass = ElementDef.getElementClass(this.currentChild, thisEnclosure, this.prefix);
        return nextClass != null && clazz.isAssignableFrom(nextClass);
    }

    public String requiredString(String elementName) throws XOMException {
        this.requiredName(elementName);
        String retval = this.currentChild.getText().trim();
        this.getNextElement();
        return retval;
    }

    public String optionalString(String elementName) throws XOMException {
        if (this.optionalName(elementName)) {
            String retval = this.currentChild.getText().trim();
            this.getNextElement();
            return retval;
        }
        return null;
    }

    public DOMWrapper requiredElement(String elementName) throws XOMException {
        this.requiredName(elementName);
        DOMWrapper prevWrapper = this.currentChild;
        this.getNextElement();
        return prevWrapper;
    }

    public String getText() {
        return this.wrapper.getText().trim();
    }

    public DOMWrapper optionalElement(String elementName) throws XOMException {
        if (this.optionalName(elementName)) {
            DOMWrapper prevChild = this.currentChild;
            this.getNextElement();
            return prevChild;
        }
        return null;
    }

    private String formatOption(String[] elementNames) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < elementNames.length; ++i) {
            sbuf.append("<DM" + this.prefix);
            sbuf.append(elementNames[i]);
            sbuf.append(">");
            if (i >= elementNames.length - 1) continue;
            sbuf.append(" or ");
        }
        return sbuf.toString();
    }

    public DOMWrapper requiredOption(String[] elementNames) throws XOMException {
        if (this.currentChild == null) {
            throw new XOMException("Expecting " + this.formatOption(elementNames) + " but found nothing.");
        }
        for (int i = 0; i < elementNames.length; ++i) {
            String augName = "DM" + elementNames[i];
            if (!augName.equalsIgnoreCase(this.currentChild.getTagName().toString())) continue;
            DOMWrapper prevWrapper = this.currentChild;
            this.getNextElement();
            this.optionIndex = i;
            return prevWrapper;
        }
        throw new XOMException("Expecting " + this.formatOption(elementNames) + " but found <" + this.currentChild.getTagName() + ">.");
    }

    public NodeDef requiredClass(Class classTemplate) throws XOMException {
        if (!this.nameMatchesClass(classTemplate)) {
            throw new XOMException("element <" + this.currentChild.getTagName() + "> does not match expected class " + classTemplate.getName());
        }
        Class currentClass = ElementDef.getElementClass(this.currentChild, this.enclosure, this.prefix);
        DOMWrapper prevWrapper = this.currentChild;
        this.getNextElement();
        return ElementDef.constructElement(prevWrapper, currentClass);
    }

    public int lastOptionIndex() {
        return this.optionIndex;
    }

    public String requiredAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            throw new XOMException("Required attribute '" + attrName + "' is not set.");
        }
        return attr.toString();
    }

    public static String requiredDefAttribute(DOMWrapper wrapper, String attrName, String defaultVal) throws XOMException {
        String attr = wrapper.getAttribute(attrName);
        if (attr == null) {
            if (defaultVal == null) {
                throw new XOMException("Required attribute " + attrName + " is not set.");
            }
            return defaultVal;
        }
        return attr.toString();
    }

    public String optionalAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        return attr.toString();
    }

    public Integer optionalIntegerAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        try {
            return new Integer(attr.toString());
        }
        catch (NumberFormatException ex) {
            throw new XOMException("Illegal integer value \"" + attr.toString() + "\" for attribute " + attrName + ": " + ex.getMessage());
        }
    }

    public Double optionalDoubleAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        try {
            return new Double(attr.toString());
        }
        catch (NumberFormatException ex) {
            throw new XOMException("Illegal double value \"" + attr.toString() + "\" for attribute " + attrName + ": " + ex.getMessage());
        }
    }

    public Integer requiredIntegerAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            throw new XOMException("Required integer attribute " + attrName + " is not set.");
        }
        try {
            return new Integer(attr.toString());
        }
        catch (NumberFormatException ex) {
            throw new XOMException("Illegal integer value \"" + attr.toString() + "\" for attribute " + attrName + ": " + ex.getMessage());
        }
    }

    public Boolean optionalBooleanAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        return new Boolean(attr.toString());
    }

    public Boolean requiredBooleanAttribute(String attrName) throws XOMException {
        String attr = this.wrapper.getAttribute(attrName);
        if (attr == null) {
            throw new XOMException("Required boolean attribute " + attrName + " is not set.");
        }
        return new Boolean(attr.toString());
    }

    public DOMWrapper[] optionalArray(String elemName, int min, int max) throws XOMException {
        Vector<DOMWrapper> vec = new Vector<DOMWrapper>();
        String augName = "DM" + elemName;
        while (this.currentChild != null && augName.equalsIgnoreCase(this.currentChild.getTagName())) {
            vec.addElement(this.currentChild);
            this.getNextElement();
        }
        if (min > 0 && vec.size() < min) {
            throw new XOMException("Expecting at least " + min + " <" + elemName + "> but found " + vec.size());
        }
        if (max > 0 && vec.size() > max) {
            throw new XOMException("Expecting at most " + max + " <" + elemName + "> but found " + vec.size());
        }
        DOMWrapper[] retval = new DOMWrapper[vec.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (DOMWrapper)vec.elementAt(i);
        }
        return retval;
    }

    public NodeDef[] classArray(Class elemClass, int min, int max) throws XOMException {
        Class thisEnclosure = this.getEnclosureClass(elemClass);
        Vector<DOMWrapper> vec = new Vector<DOMWrapper>();
        while (this.currentChild != null && this.nameMatchesClass(elemClass)) {
            vec.addElement(this.currentChild);
            this.getNextElement();
        }
        if (min > 0 && vec.size() < min) {
            throw new XOMException("Expecting at least " + min + " <" + elemClass.getName() + "> but found " + vec.size());
        }
        if (max > 0 && vec.size() > max) {
            throw new XOMException("Expecting at most " + max + " <" + elemClass.getName() + "> but found " + vec.size());
        }
        NodeDef[] retval = new NodeDef[vec.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = ElementDef.constructElement((DOMWrapper)vec.elementAt(i), thisEnclosure, this.prefix);
        }
        return retval;
    }

    public NodeDef getElement(Class elementClass, boolean required) throws XOMException {
        if (this.currentChild == null) {
            return null;
        }
        if (!this.nameMatchesClass(elementClass)) {
            if (required) {
                throw new XOMException("element <" + this.currentChild.getTagName() + "> is not of expected type " + elementClass.getName());
            }
            return null;
        }
        Class thisEnclosure = this.getEnclosureClass(elementClass);
        Class currentClass = ElementDef.getElementClass(this.currentChild, thisEnclosure, this.prefix);
        DOMWrapper prevChild = this.currentChild;
        this.getNextElement();
        return ElementDef.constructElement(prevChild, currentClass);
    }

    public NodeDef[] getArray(Class elemClass, int min, int max) throws XOMException {
        return this.classArray(elemClass, min, max);
    }

    public String getString(String elementName, boolean required) throws XOMException {
        boolean found;
        if (required) {
            this.requiredName(elementName);
            found = true;
        } else {
            found = this.optionalName(elementName);
        }
        if (found) {
            String retval = this.currentChild.getText().trim();
            this.getNextElement();
            return retval;
        }
        return null;
    }

    public String[] getStringArray(String elemName, int min, int max) throws XOMException {
        Vector<DOMWrapper> vec = new Vector<DOMWrapper>();
        String augName = this.prefix + elemName;
        while (this.currentChild != null && augName.equalsIgnoreCase(this.currentChild.getTagName().toString())) {
            vec.addElement(this.currentChild);
            this.getNextElement();
        }
        if (min > 0 && vec.size() < min) {
            throw new XOMException("Expecting at least " + min + " <" + elemName + "> but found " + vec.size());
        }
        if (max > 0 && vec.size() > max) {
            throw new XOMException("Expecting at most " + max + " <" + elemName + "> but found " + vec.size());
        }
        String[] retval = new String[vec.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = ((DOMWrapper)vec.elementAt(i)).getText().trim();
        }
        return retval;
    }

    private boolean stringInArray(String str, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!str.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    private String arrayToString(String[] array) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("{");
        for (int i = 0; i < array.length; ++i) {
            sbuf.append(array[i]);
            if (i >= array.length - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    public static Class getPluginClass(String packageName, String className) throws XOMException {
        Class<?> managerClass = null;
        try {
            managerClass = Class.forName(packageName + "." + className);
        }
        catch (ClassNotFoundException ex) {
            throw new XOMException("Unable to locate plugin class " + packageName + "." + className + ": " + ex.getMessage());
        }
        return DOMElementParser.getPluginClass(managerClass);
    }

    public static Class getPluginClass(Class managerClass) throws XOMException {
        Method[] methods = managerClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() != Class.class || !Modifier.isStatic(methods[i].getModifiers())) continue;
            try {
                Object[] args = new Object[]{};
                return (Class)methods[i].invoke(null, args);
            }
            catch (InvocationTargetException ex) {
                throw new XOMException("Exception while retrieving plugin class: " + ex.getTargetException().toString());
            }
            catch (IllegalAccessException ex) {
                throw new XOMException("Illegal access while retrieving plugin class: " + ex.getMessage());
            }
        }
        throw new XOMException("Plugin class " + managerClass.getName() + " is not an appropriate plugin class; " + "getXMLDefClass() is not defined.");
    }

    public Object getAttribute(String attrName, String attrType, String defaultValue, String[] values, boolean required) throws XOMException {
        if (attrType.indexOf(46) == -1) {
            attrType = "java.lang." + attrType;
        }
        Class<?> typeClass = null;
        try {
            typeClass = Class.forName(attrType);
        }
        catch (ClassNotFoundException ex) {
            throw new XOMException("Class could not be found for attribute type: " + attrType + ": " + ex.getMessage());
        }
        Class[] classArray = new Class[]{String.class};
        Constructor<?> stringConstructor = null;
        try {
            stringConstructor = typeClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException ex) {
            throw new XOMException("Attribute type class " + attrType + " does not have a " + "constructor which takes a String: " + ex.getMessage());
        }
        String attrVal = this.wrapper.getAttribute(attrName);
        if (attrVal == null) {
            attrVal = defaultValue;
        }
        if (attrVal == null) {
            if (required) {
                throw new XOMException("Attribute '" + attrName + "' is unset and has no default value.");
            }
            return null;
        }
        if (values != null && !this.stringInArray(attrVal.toString(), values)) {
            throw new XOMException("Value '" + attrVal.toString() + "' of attribute '" + attrName + "' has illegal value '" + attrVal + "'.  Legal values: " + this.arrayToString(values));
        }
        Object[] args = new Object[]{attrVal.toString()};
        try {
            return stringConstructor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new XOMException("Unable to construct a " + attrType + " from value \"" + attrVal + "\": " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new XOMException("Unable to construct a " + attrType + " from value \"" + attrVal + "\": " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new XOMException("Unable to construct a " + attrType + " from value \"" + attrVal + "\": " + ex.getMessage());
        }
    }
}

