/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import mondrian.spi.impl.PostgreSqlDialect;

public class RedshiftDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(RedshiftDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            return super.acceptsConnection(connection) && JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.REDSHIFT, connection);
        }
    };

    public RedshiftDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.REDSHIFT;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String value) {
        Util.singleQuoteString(value.replaceAll("\\\\", "\\\\\\\\"), buf);
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return false;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegExp) {
        return null;
    }
}

