/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import mondrian.olap.Aggregator;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.AbstractSegmentBody;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.DenseDoubleSegmentBody;
import mondrian.rolap.agg.DenseDoubleSegmentDataset;
import mondrian.rolap.agg.DenseIntSegmentBody;
import mondrian.rolap.agg.DenseIntSegmentDataset;
import mondrian.rolap.agg.DenseObjectSegmentBody;
import mondrian.rolap.agg.DenseObjectSegmentDataset;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.agg.SparseSegmentBody;
import mondrian.rolap.agg.SparseSegmentDataset;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentColumn;
import mondrian.spi.SegmentHeader;
import mondrian.util.ArraySortedSet;
import mondrian.util.Pair;
import org.apache.log4j.Logger;
import org.olap4j.impl.UnmodifiableArrayList;

public class SegmentBuilder {
    private static final Logger LOGGER = Logger.getLogger(SegmentBuilder.class);

    public static SegmentWithData addData(Segment segment, SegmentBody sb) {
        SegmentAxis[] axes = new SegmentAxis[segment.predicates.length];
        for (int i = 0; i < segment.predicates.length; ++i) {
            StarColumnPredicate predicate = segment.predicates[i];
            axes[i] = new SegmentAxis(predicate, sb.getAxisValueSets()[i], sb.getNullAxisFlags()[i]);
        }
        SegmentDataset dataSet = SegmentBuilder.createDataset(sb, axes);
        return new SegmentWithData(segment, dataSet, axes);
    }

    private static SegmentDataset createDataset(SegmentBody body, SegmentAxis[] axes) {
        SegmentDataset dataSet;
        if (body instanceof DenseDoubleSegmentBody) {
            dataSet = new DenseDoubleSegmentDataset(axes, (double[])body.getValueArray(), body.getNullValueIndicators());
        } else if (body instanceof DenseIntSegmentBody) {
            dataSet = new DenseIntSegmentDataset(axes, (int[])body.getValueArray(), body.getNullValueIndicators());
        } else if (body instanceof DenseObjectSegmentBody) {
            dataSet = new DenseObjectSegmentDataset(axes, (Object[])body.getValueArray());
        } else if (body instanceof SparseSegmentBody) {
            dataSet = new SparseSegmentDataset(body.getValueMap());
        } else {
            throw Util.newInternal("Unknown segment body type: " + body.getClass() + ": " + body);
        }
        return dataSet;
    }

    public static Segment toSegment(SegmentHeader header, RolapStar star, BitKey constrainedColumnsBitKey, RolapStar.Column[] constrainedColumns, RolapStar.Measure measure, List<StarPredicate> compoundPredicates) {
        ArrayList<LiteralStarPredicate> predicateList = new ArrayList<LiteralStarPredicate>();
        for (int i = 0; i < constrainedColumns.length; ++i) {
            AbstractColumnPredicate predicate;
            RolapStar.Column constrainedColumn = constrainedColumns[i];
            SortedSet<Comparable> values = header.getConstrainedColumns().get((int)i).values;
            if (values == null) {
                predicate = new LiteralStarPredicate(constrainedColumn, true);
            } else if (values.size() == 1) {
                predicate = new ValueColumnPredicate(constrainedColumn, values.first());
            } else {
                ArrayList<StarColumnPredicate> valuePredicateList = new ArrayList<StarColumnPredicate>();
                for (Object e : values) {
                    valuePredicateList.add(new ValueColumnPredicate(constrainedColumn, e));
                }
                predicate = new ListColumnPredicate(constrainedColumn, valuePredicateList);
            }
            predicateList.add((LiteralStarPredicate)predicate);
        }
        return new Segment(star, constrainedColumnsBitKey, constrainedColumns, measure, predicateList.toArray(new StarColumnPredicate[predicateList.size()]), new ExcludedRegionList(header), compoundPredicates);
    }

    public static Pair<SegmentHeader, SegmentBody> rollup(Map<SegmentHeader, SegmentBody> map, Set<String> keepColumns, BitKey targetBitkey, Aggregator rollupAggregator, Dialect.Datatype datatype) {
        AbstractSegmentBody body;
        Object value;
        assert (SegmentBuilder.allHeadersHaveSameDimensionality(map.keySet()));
        UnmodifiableArrayList segments = UnmodifiableArrayList.of(map.entrySet());
        SegmentHeader firstHeader = (SegmentHeader)((Map.Entry)segments.get(0)).getKey();
        class AxisInfo {
            SegmentColumn column;
            SortedSet<Comparable> requestedValues;
            SortedSet<Comparable> valueSet;
            Comparable[] values;
            boolean hasNull;
            int src;
            boolean lostPredicate;

            AxisInfo() {
            }
        }
        AxisInfo[] axes = new AxisInfo[keepColumns.size()];
        int z = 0;
        int j = 0;
        for (SegmentColumn column : firstHeader.getConstrainedColumns()) {
            if (keepColumns.contains(column.columnExpression)) {
                int n = z++;
                AxisInfo axisInfo = new AxisInfo();
                axes[n] = axisInfo;
                AxisInfo axisInfo2 = axisInfo;
                axisInfo2.src = j;
                axisInfo2.column = column;
                axisInfo2.requestedValues = column.values;
            }
            ++j;
        }
        for (Map.Entry entry : segments) {
            SegmentHeader header = (SegmentHeader)entry.getKey();
            for (AxisInfo axis : axes) {
                boolean filteredHasNull;
                SortedSet<Comparable> filteredValues;
                SortedSet<Comparable> values = ((SegmentBody)entry.getValue()).getAxisValueSets()[axis.src];
                SegmentColumn headerColumn = header.getConstrainedColumn(axis.column.columnExpression);
                boolean hasNull = ((SegmentBody)entry.getValue()).getNullAxisFlags()[axis.src];
                SortedSet<Comparable> requestedValues = headerColumn.getValues();
                if (axis.valueSet == null) {
                    axis.valueSet = new TreeSet<Comparable>(values);
                    axis.hasNull = hasNull;
                    axis.requestedValues = requestedValues;
                    continue;
                }
                if (axis.requestedValues == null && requestedValues == null) {
                    filteredValues = axis.valueSet;
                    filteredValues.addAll(new TreeSet<Comparable>(values));
                    filteredHasNull = hasNull || axis.hasNull;
                } else if (axis.requestedValues == null) {
                    filteredValues = values;
                    filteredHasNull = hasNull;
                    axis.column = headerColumn;
                } else if (requestedValues == null) {
                    filteredValues = axis.requestedValues;
                    filteredHasNull = axis.hasNull;
                } else {
                    filteredValues = Util.intersect(requestedValues, axis.requestedValues);
                    filteredHasNull = false;
                }
                axis.valueSet = filteredValues;
                boolean bl = axis.hasNull = axis.hasNull || filteredHasNull;
                if (Util.equals(axis.requestedValues, requestedValues)) continue;
                if (axis.requestedValues == null) {
                    axis.requestedValues = requestedValues;
                    continue;
                }
                if (requestedValues == null) continue;
                axis.lostPredicate = true;
            }
        }
        for (AxisInfo axis : axes) {
            axis.values = axis.valueSet.toArray(new Comparable[axis.valueSet.size()]);
        }
        HashMap cellValues = new HashMap();
        ArrayList<List<Comparable>> addedIntersections = new ArrayList<List<Comparable>>();
        for (Map.Entry<SegmentHeader, SegmentBody> entry : map.entrySet()) {
            int[] pos = new int[axes.length];
            Comparable[][] valueArrays = new Comparable[firstHeader.getConstrainedColumns().size()][];
            SegmentBody body2 = entry.getValue();
            z = 0;
            for (SortedSet<Comparable> set : body2.getAxisValueSets()) {
                valueArrays[z] = keepColumns.contains(firstHeader.getConstrainedColumns().get((int)z).columnExpression) ? set.toArray(new Comparable[set.size()]) : null;
                ++z;
            }
            Map<CellKey, Object> v = body2.getValueMap();
            block10: for (Map.Entry<CellKey, Object> vEntry : v.entrySet()) {
                List<Comparable> colValues;
                z = 0;
                for (int i = 0; i < vEntry.getKey().size(); ++i) {
                    Comparable[] valueArray = valueArrays[i];
                    if (valueArray == null) continue;
                    int ordinal = vEntry.getKey().getOrdinals()[i];
                    int targetOrdinal = axes[z].hasNull && ordinal == valueArray.length ? axes[z].valueSet.size() : ((value = valueArray[ordinal]) == null ? axes[z].valueSet.size() : Util.binarySearch((Comparable[])axes[z].values, (int)0, (int)axes[z].values.length, (Comparable)value));
                    if (targetOrdinal < 0) continue block10;
                    pos[z++] = targetOrdinal;
                }
                CellKey ck = CellKey.Generator.newCellKey(pos);
                if (!cellValues.containsKey(ck)) {
                    cellValues.put(ck, new ArrayList());
                }
                if (addedIntersections.contains(colValues = SegmentBuilder.getColumnValsAtCellKey(body2, vEntry.getKey()))) continue;
                ((List)cellValues.get(ck)).add(vEntry.getValue());
                addedIntersections.add(colValues);
            }
        }
        ArrayList<Pair<SortedSet<Comparable>, Boolean>> axisList = new ArrayList<Pair<SortedSet<Comparable>, Boolean>>();
        BigInteger bigValueCount = BigInteger.ONE;
        for (AxisInfo axis : axes) {
            axisList.add(Pair.of(axis.valueSet, axis.hasNull));
            int size = axis.values.length;
            bigValueCount = bigValueCount.multiply(BigInteger.valueOf(axis.hasNull ? (long)(size + 1) : (long)size));
        }
        boolean sparse = bigValueCount.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || SegmentLoader.useSparse(bigValueCount.doubleValue(), cellValues.size());
        int[] axisMultipliers = SegmentBuilder.computeAxisMultipliers(axisList);
        if (cellValues.size() == 0) {
            body = new DenseObjectSegmentBody(new Object[0], axisList);
        } else if (sparse) {
            HashMap<CellKey, Object> data = new HashMap<CellKey, Object>();
            for (Map.Entry entry : cellValues.entrySet()) {
                data.put(CellKey.Generator.newCellKey(((CellKey)entry.getKey()).getOrdinals()), rollupAggregator.aggregate((List)entry.getValue(), datatype));
            }
            body = new SparseSegmentBody(data, axisList);
        } else {
            int valueCount = bigValueCount.intValue();
            switch (datatype) {
                case Integer: {
                    int[] ints = new int[valueCount];
                    BitSet nullValues = Util.bitSetBetween(0, valueCount);
                    for (Map.Entry entry : cellValues.entrySet()) {
                        int offset = CellKey.Generator.getOffset(((CellKey)entry.getKey()).getOrdinals(), axisMultipliers);
                        Object value2 = rollupAggregator.aggregate((List)entry.getValue(), datatype);
                        if (value2 == null) continue;
                        ints[offset] = (Integer)value2;
                        nullValues.clear(offset);
                    }
                    body = new DenseIntSegmentBody(nullValues, ints, axisList);
                    break;
                }
                case Numeric: {
                    double[] doubles = new double[valueCount];
                    BitSet nullValues = Util.bitSetBetween(0, valueCount);
                    for (Map.Entry entry : cellValues.entrySet()) {
                        int offset = CellKey.Generator.getOffset(((CellKey)entry.getKey()).getOrdinals(), axisMultipliers);
                        value = rollupAggregator.aggregate((List)entry.getValue(), datatype);
                        if (value == null) continue;
                        doubles[offset] = (Double)value;
                        nullValues.clear(offset);
                    }
                    body = new DenseDoubleSegmentBody(nullValues, doubles, axisList);
                    break;
                }
                default: {
                    Object[] objects = new Object[valueCount];
                    for (Map.Entry entry : cellValues.entrySet()) {
                        int offset = CellKey.Generator.getOffset(((CellKey)entry.getKey()).getOrdinals(), axisMultipliers);
                        objects[offset] = rollupAggregator.aggregate((List)entry.getValue(), datatype);
                    }
                    body = new DenseObjectSegmentBody(objects, axisList);
                }
            }
        }
        ArrayList<SegmentColumn> constrainedColumns = new ArrayList<SegmentColumn>();
        for (int i = 0; i < axes.length; ++i) {
            AxisInfo axisInfo = axes[i];
            constrainedColumns.add(new SegmentColumn(axisInfo.column.getColumnExpression(), axisInfo.column.getValueCount(), axisInfo.lostPredicate ? (SortedSet)((Pair)axisList.get((int)i)).left : axisInfo.column.values));
        }
        SegmentHeader header = new SegmentHeader(firstHeader.schemaName, firstHeader.schemaChecksum, firstHeader.cubeName, firstHeader.measureName, constrainedColumns, firstHeader.compoundPredicates, firstHeader.rolapStarFactTableName, targetBitkey, Collections.emptyList());
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Rolling up segments with parameters: \n");
            builder.append("keepColumns=" + keepColumns + "\n");
            builder.append("aggregator=" + rollupAggregator + "\n");
            builder.append("datatype=" + (Object)((Object)datatype) + "\n");
            for (Map.Entry segment : segments) {
                builder.append(segment.getKey() + "\n");
            }
            builder.append("AxisInfos constructed:");
            for (AxisInfo axis : axes) {
                SortedSet<Comparable> colVals = axis.column.getValues();
                builder.append(String.format("column.columnExpression=%s\ncolumn.valueCount=%s\ncolumn.values=%s\nrequestedValues=%s\nvalueSet=%s\nvalues=%s\nhasNull=%b\nsrc=%d\nlostPredicate=%b\n", axis.column.columnExpression, axis.column.getValueCount(), Arrays.toString(colVals == null ? null : colVals.toArray()), axis.requestedValues, axis.valueSet, Arrays.asList(axis.values), axis.hasNull, axis.src, axis.lostPredicate));
            }
            builder.append("Resulted in Segment:  \n");
            builder.append(header);
            builder.append(body.toString());
            LOGGER.debug((Object)builder.toString());
        }
        return Pair.of(header, body);
    }

    private static List<Comparable> getColumnValsAtCellKey(SegmentBody body, CellKey cellKey) {
        ArrayList<Comparable> columnValues = new ArrayList<Comparable>();
        for (int i = 0; i < body.getAxisValueSets().length; ++i) {
            int valCoord;
            ArrayList<Comparable> columnVals = new ArrayList<Comparable>();
            columnVals.addAll(body.getAxisValueSets()[i]);
            int n = valCoord = body.getNullAxisFlags()[i] ? cellKey.getAxis(i) - 1 : cellKey.getAxis(i);
            if (valCoord >= 0) {
                columnValues.add((Comparable)columnVals.get(valCoord));
                continue;
            }
            columnValues.add(null);
        }
        return columnValues;
    }

    private static boolean allHeadersHaveSameDimensionality(Set<SegmentHeader> headers) {
        Iterator<SegmentHeader> headerIter = headers.iterator();
        SegmentHeader firstHeader = headerIter.next();
        BitKey bitKey = firstHeader.getConstrainedColumnsBitKey();
        while (headerIter.hasNext()) {
            SegmentHeader nextHeader = headerIter.next();
            if (bitKey.equals(nextHeader.getConstrainedColumnsBitKey())) continue;
            return false;
        }
        return true;
    }

    private static int[] computeAxisMultipliers(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        int[] axisMultipliers = new int[axes.size()];
        int multiplier = 1;
        for (int i = axes.size() - 1; i >= 0; --i) {
            axisMultipliers[i] = multiplier;
            int nullAxisAdjustment = (Boolean)axes.get((int)i).right != false ? 1 : 0;
            multiplier *= ((SortedSet)axes.get((int)i).left).size() + nullAxisAdjustment;
        }
        return axisMultipliers;
    }

    public static boolean isSubset(SegmentHeader header, Segment segment) {
        if (!segment.getStar().getSchema().getName().equals(header.schemaName)) {
            return false;
        }
        if (!segment.getStar().getFactTable().getAlias().equals(header.rolapStarFactTableName)) {
            return false;
        }
        if (!segment.measure.getName().equals(header.measureName)) {
            return false;
        }
        if (!segment.measure.getCubeName().equals(header.cubeName)) {
            return false;
        }
        return segment.getConstrainedColumnsBitKey().equals(header.constrainedColsBitKey);
    }

    public static List<SegmentColumn> toConstrainedColumns(StarColumnPredicate[] predicates) {
        return SegmentBuilder.toConstrainedColumns(Arrays.asList(predicates));
    }

    public static List<SegmentColumn> toConstrainedColumns(Collection<StarColumnPredicate> predicates) {
        ArrayList<SegmentColumn> ccs = new ArrayList<SegmentColumn>(predicates.size());
        for (StarColumnPredicate predicate : predicates) {
            if (predicate instanceof LiteralStarPredicate && ((LiteralStarPredicate)predicate).getValue()) {
                ccs.add(SegmentBuilder.segmentColumn(predicate, null));
                continue;
            }
            ArrayList values = new ArrayList();
            predicate.values(Util.cast(values));
            Comparable[] valuesArray = values.toArray(new Comparable[values.size()]);
            Arrays.sort(valuesArray, Util.SqlNullSafeComparator.instance);
            ccs.add(SegmentBuilder.segmentColumn(predicate, new ArraySortedSet(valuesArray)));
        }
        return ccs;
    }

    private static SegmentColumn segmentColumn(StarColumnPredicate predicate, SortedSet<Comparable> set) {
        return new SegmentColumn(predicate.getConstrainedColumn().getExpression().getGenericExpression(), predicate.getConstrainedColumn().getCardinality(), set);
    }

    public static SegmentHeader toHeader(Segment segment) {
        List<SegmentColumn> cc = SegmentBuilder.toConstrainedColumns(segment.predicates);
        ArrayList<String> cp = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (StarPredicate compoundPredicate : segment.compoundPredicateList) {
            buf.setLength(0);
            SqlQuery query = new SqlQuery(segment.star.getSqlQueryDialect());
            compoundPredicate.toSql(query, buf);
            cp.add(buf.toString());
        }
        RolapSchema schema = segment.star.getSchema();
        return new SegmentHeader(schema.getName(), schema.getChecksum(), segment.measure.getCubeName(), segment.measure.getName(), cc, cp, segment.star.getFactTable().getAlias(), segment.constrainedColumnsBitKey, Collections.emptyList());
    }

    private static RolapStar.Column[] getConstrainedColumns(RolapStar star, BitKey bitKey) {
        ArrayList<RolapStar.Column> list = new ArrayList<RolapStar.Column>();
        for (int bit : bitKey) {
            list.add(star.getColumn(bit));
        }
        return list.toArray(new RolapStar.Column[list.size()]);
    }

    public static class StarSegmentConverter
    implements SegmentConverter {
        private final RolapStar.Measure measure;
        private final List<StarPredicate> compoundPredicateList;

        public StarSegmentConverter(RolapStar.Measure measure, List<StarPredicate> compoundPredicateList) {
            this.measure = measure;
            this.compoundPredicateList = compoundPredicateList;
        }

        @Override
        public SegmentWithData convert(SegmentHeader header, SegmentBody body) {
            Segment segment = SegmentBuilder.toSegment(header, this.measure.getStar(), header.getConstrainedColumnsBitKey(), SegmentBuilder.getConstrainedColumns(this.measure.getStar(), header.getConstrainedColumnsBitKey()), this.measure, this.compoundPredicateList);
            return SegmentBuilder.addData(segment, body);
        }
    }

    public static class SegmentConverterImpl
    implements SegmentConverter {
        private final AggregationKey key;
        private final CellRequest request;

        public SegmentConverterImpl(AggregationKey key, CellRequest request) {
            this.key = key;
            this.request = request;
        }

        @Override
        public SegmentWithData convert(SegmentHeader header, SegmentBody body) {
            Segment segment = SegmentBuilder.toSegment(header, this.key.getStar(), header.getConstrainedColumnsBitKey(), SegmentBuilder.getConstrainedColumns(this.key.getStar(), header.getConstrainedColumnsBitKey()), this.request.getMeasure(), this.key.getCompoundPredicateList());
            return SegmentBuilder.addData(segment, body);
        }
    }

    public static interface SegmentConverter {
        public SegmentWithData convert(SegmentHeader var1, SegmentBody var2);
    }

    private static class ExcludedRegionList
    extends AbstractList<Segment.ExcludedRegion>
    implements Segment.ExcludedRegion {
        private final int cellCount;
        private final SegmentHeader header;

        public ExcludedRegionList(SegmentHeader header) {
            this.header = header;
            int cellCount = 1;
            for (SegmentColumn cc : header.getExcludedRegions()) {
                if (cc.values == null) continue;
                cellCount *= cc.values.size();
            }
            this.cellCount = cellCount;
        }

        @Override
        public void describe(StringBuilder buf) {
        }

        @Override
        public int getArity() {
            return this.header.getConstrainedColumns().size();
        }

        @Override
        public int getCellCount() {
            return this.cellCount;
        }

        @Override
        public boolean wouldContain(Object[] keys) {
            assert (keys.length == this.header.getConstrainedColumns().size());
            for (int i = 0; i < keys.length; ++i) {
                SegmentColumn excl = this.header.getExcludedRegion(this.header.getConstrainedColumns().get((int)i).columnExpression);
                if (excl == null || !excl.values.contains(keys[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Segment.ExcludedRegion get(int index) {
            return this;
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

