/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    @Override
    protected boolean restrictMemberTypes() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        Exp filterExpr;
        if (!this.isEnabled()) {
            return null;
        }
        if (!FilterConstraint.isValidContext(evaluator, this.restrictMemberTypes())) {
            return null;
        }
        String funName = fun.getName();
        if (!"Filter".equalsIgnoreCase(funName)) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        List<CrossJoinArg[]> allArgs = this.crossJoinArgFactory().checkCrossJoinArg(evaluator, args[0]);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (this.isPreferInterpreter(cjArgs, false)) {
            return null;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeFilter");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery, null, evaluator, cjArgs[0].getLevel());
        String filterExprStr = sql.generateFilterCondition(filterExpr = args[1]);
        if (filterExprStr == null) {
            return null;
        }
        if (SqlConstraintUtils.containsCalculatedMember(evaluator.getNonAllMembers(), true)) {
            return null;
        }
        LOGGER.debug((Object)"using native filter");
        int savepoint = evaluator.savepoint();
        try {
            CrossJoinArg[] predicateArgs;
            this.overrideContext(evaluator, cjArgs, sql.getStoredMeasure());
            if (!evaluator.isNonEmpty() && sql.getStoredMeasure() == null) {
                for (Member m : evaluator.getMembers()) {
                    evaluator.setContext(m.getLevel().getHierarchy().getDefaultMember());
                }
            }
            CrossJoinArg[] combinedArgs = cjArgs;
            if (allArgs.size() == 2 && (predicateArgs = allArgs.get(1)) != null) {
                combinedArgs = Util.appendArrays(cjArgs, new CrossJoinArg[][]{predicateArgs});
            }
            FilterConstraint constraint = new FilterConstraint(combinedArgs, evaluator, filterExpr);
            RolapNativeSet.SetEvaluator setEvaluator = new RolapNativeSet.SetEvaluator(this, cjArgs, schemaReader, constraint);
            return setEvaluator;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    static class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        Exp filterExpr;

        public FilterConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, Exp filterExpr) {
            super(args, evaluator, true);
            this.filterExpr = filterExpr;
        }

        @Override
        protected boolean isJoinRequired() {
            final AtomicBoolean mustJoin = new AtomicBoolean(false);
            this.filterExpr.accept(new MdxVisitorImpl(){

                @Override
                public Object visit(MemberExpr memberExpr) {
                    if (memberExpr.getMember().isMeasure()) {
                        mustJoin.set(true);
                        return null;
                    }
                    return super.visit(memberExpr);
                }
            });
            return mustJoin.get() || this.getEvaluator().isNonEmpty() && super.isJoinRequired();
        }

        @Override
        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            RolapNativeSql sql = new RolapNativeSql(sqlQuery, aggStar, this.getEvaluator(), this.args[0].getLevel());
            String filterSql = sql.generateFilterCondition(this.filterExpr);
            if (filterSql != null) {
                sqlQuery.addHaving(filterSql);
            }
            if (this.getEvaluator().isNonEmpty() || this.isJoinRequired()) {
                super.addConstraint(sqlQuery, baseCube, aggStar);
            }
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            if (this.filterExpr != null) {
                key.add(this.filterExpr.toString());
            }
            key.add(this.getEvaluator().isNonEmpty());
            if (this.getEvaluator() instanceof RolapEvaluator) {
                key.add(((RolapEvaluator)this.getEvaluator()).getSlicerMembers());
            }
            return key;
        }
    }
}

