/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.Property;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.spi.CellFormatter;
import mondrian.spi.Dialect;

public class RolapBaseCubeMeasure
extends RolapMemberBase
implements RolapStoredMeasure {
    private final MondrianDef.Expression expression;
    private final RolapAggregator aggregator;
    private final RolapCube cube;
    private final Map<String, Annotation> annotationMap;
    private Object starMeasure;
    private RolapResult.ValueFormatter formatter;

    RolapBaseCubeMeasure(RolapCube cube, RolapMember parentMember, RolapLevel level, String name, String caption, String description, String formatString, MondrianDef.Expression expression, String aggregatorName, String datatype, Map<String, Annotation> annotationMap) {
        super(parentMember, level, name, null, Member.MemberType.MEASURE);
        assert (annotationMap != null);
        this.cube = cube;
        this.annotationMap = annotationMap;
        this.caption = caption;
        this.expression = expression;
        if (description != null) {
            this.setProperty(Property.DESCRIPTION.name, description);
        }
        if (formatString == null) {
            formatString = "";
        } else {
            this.setProperty(Property.FORMAT_STRING.name, formatString);
        }
        this.setProperty(Property.FORMAT_EXP_PARSED.name, Literal.createString(formatString));
        this.setProperty(Property.FORMAT_EXP.name, formatString);
        this.aggregator = RolapAggregator.enumeration.getValue(aggregatorName, false);
        if (this.aggregator == null) {
            StringBuilder buf = new StringBuilder();
            for (String aggName : RolapAggregator.enumeration.getNames()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append('\'');
                buf.append(aggName);
                buf.append('\'');
            }
            throw MondrianResource.instance().UnknownAggregator.ex(aggregatorName, buf.toString());
        }
        this.setProperty(Property.AGGREGATION_TYPE.name, this.aggregator);
        if (datatype == null) {
            datatype = this.aggregator == RolapAggregator.Count || this.aggregator == RolapAggregator.DistinctCount ? "Integer" : "Numeric";
        }
        if (DataType.valueOf(datatype) == null) {
            throw MondrianResource.instance().CastInvalidType.ex(datatype);
        }
        this.setProperty(Property.DATATYPE.name, datatype);
    }

    @Override
    public MondrianDef.Expression getMondrianDefExpression() {
        return this.expression;
    }

    @Override
    public RolapAggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public RolapCube getCube() {
        return this.cube;
    }

    @Override
    public RolapResult.ValueFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(CellFormatter cellFormatter) {
        this.formatter = new RolapResult.CellFormatterValueFormatter(cellFormatter);
    }

    @Override
    public Object getStarMeasure() {
        return this.starMeasure;
    }

    void setStarMeasure(Object starMeasure) {
        this.starMeasure = starMeasure;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    public Dialect.Datatype getDatatype() {
        Object datatype = this.getPropertyValue(Property.DATATYPE.name);
        try {
            return Dialect.Datatype.valueOf((String)datatype);
        }
        catch (ClassCastException e) {
            return Dialect.Datatype.String;
        }
        catch (IllegalArgumentException e) {
            return Dialect.Datatype.String;
        }
    }

    static enum DataType {
        Integer,
        Numeric,
        String;

    }
}

