/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapEvaluator;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.IntegerProperty;

public class AggregateFunDef
extends AbstractAggregateFunDef {
    private static final String TIMING_NAME = AggregateFunDef.class.getSimpleName();
    private static final Logger LOGGER = Logger.getLogger(AggregateFunDef.class);
    static final ReflectiveMultiResolver resolver = new ReflectiveMultiResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}, AggregateFunDef.class);

    public AggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    private Member getMember(Exp exp) {
        Member m;
        if (exp instanceof MemberExpr && (m = ((MemberExpr)exp).getMember()).isMeasure() && !m.isCalculated()) {
            return m;
        }
        LOGGER.warn((Object)("Unable to determine aggregator for non-base measures in 2nd parameter of Aggregate(), summing: " + exp.toString()));
        return null;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        Member member = call.getArgCount() > 1 ? this.getMember(call.getArg(1)) : null;
        return new AggregateCalc(call, listCalc, calc, member);
    }

    public static class AggregateCalc
    extends GenericCalc {
        private final ListCalc listCalc;
        private final Calc calc;
        private final Member member;

        public AggregateCalc(Exp exp, ListCalc listCalc, Calc calc, Member member) {
            super(exp, new Calc[]{listCalc, calc});
            this.listCalc = listCalc;
            this.calc = calc;
            this.member = member;
        }

        public AggregateCalc(Exp exp, ListCalc listCalc, Calc calc) {
            this(exp, listCalc, calc, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object evaluate(Evaluator evaluator) {
            evaluator.getTiming().markStart(TIMING_NAME);
            int savepoint = evaluator.savepoint();
            try {
                TupleList list = AbstractAggregateFunDef.evaluateCurrentList(this.listCalc, evaluator);
                if (this.member != null) {
                    evaluator.setContext(this.member);
                }
                Object object = AggregateCalc.aggregate(this.calc, evaluator, list);
                return object;
            }
            finally {
                evaluator.restore(savepoint);
                evaluator.getTiming().markEnd(TIMING_NAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object aggregate(Calc calc, Evaluator evaluator, TupleList tupleList) {
            boolean tupleSizeWithinInListSize;
            Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
            if (aggregator == null) {
                throw FunUtil.newEvalException(null, "Could not find an aggregator in the current evaluation context");
            }
            Aggregator rollup = aggregator.getRollup();
            if (rollup == null) {
                throw FunUtil.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
            }
            if (aggregator != RolapAggregator.DistinctCount && aggregator != RolapAggregator.Avg) {
                int savepoint = evaluator.savepoint();
                try {
                    Object o;
                    evaluator.setNonEmpty(false);
                    Object object = o = rollup.aggregate(evaluator, tupleList, calc);
                    return object;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }
            if (tupleList.size() == 0) {
                return 1.2345E-8;
            }
            boolean unlimitedIn = false;
            if (evaluator instanceof RolapEvaluator) {
                unlimitedIn = ((RolapEvaluator)evaluator).getDialect().supportsUnlimitedValueList();
            }
            boolean bl = tupleSizeWithinInListSize = tupleList.size() <= MondrianProperties.instance().MaxConstraints.get();
            if (!unlimitedIn && !tupleSizeWithinInListSize) {
                tupleList = AggregateCalc.optimizeTupleList(evaluator, tupleList, true);
            }
            Evaluator evaluator2 = evaluator.pushAggregation(tupleList);
            evaluator2.setNonEmpty(false);
            return evaluator2.evaluateCurrent();
        }

        private static boolean canOptimize(Evaluator evaluator, TupleList tupleList) {
            if (tupleList.size() > 0) {
                for (Member member : (List)tupleList.get(0)) {
                    Role.RollupPolicy policy = evaluator.getSchemaReader().getRole().getAccessDetails(member.getHierarchy()).getRollupPolicy();
                    if (policy != Role.RollupPolicy.PARTIAL) continue;
                    return false;
                }
            }
            return true;
        }

        public static TupleList optimizeTupleList(Evaluator evaluator, TupleList tupleList, boolean checkSize) {
            if (!AggregateCalc.canOptimize(evaluator, tupleList)) {
                return tupleList;
            }
            tupleList = AggregateCalc.optimizeChildren(tupleList, evaluator.getSchemaReader(), evaluator.getMeasureCube());
            if (checkSize) {
                AggregateCalc.checkIfAggregationSizeIsTooLarge(tupleList);
            }
            return tupleList;
        }

        public static TupleList removeOverlappingTupleEntries(TupleList list) {
            TupleList trimmedList = list.cloneList(list.size());
            Member[] tuple1 = new Member[list.getArity()];
            Member[] tuple2 = new Member[list.getArity()];
            TupleCursor cursor1 = list.tupleCursor();
            while (cursor1.forward()) {
                cursor1.currentToArray(tuple1, 0);
                if (trimmedList.isEmpty()) {
                    trimmedList.addTuple(tuple1);
                    continue;
                }
                boolean ignore = false;
                TupleIterator iterator = trimmedList.tupleIterator();
                while (iterator.forward()) {
                    iterator.currentToArray(tuple2, 0);
                    if (AggregateCalc.isSuperSet(tuple1, tuple2)) {
                        iterator.remove();
                        continue;
                    }
                    if (!AggregateCalc.isSuperSet(tuple2, tuple1) && !AggregateCalc.isEqual(tuple1, tuple2)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                trimmedList.addTuple(tuple1);
            }
            return trimmedList;
        }

        public static boolean isSuperSet(Member[] tuple1, Member[] tuple2) {
            int parentLevelCount = 0;
            for (int i = 0; i < tuple1.length; ++i) {
                Member member2 = tuple2[i];
                Member member1 = tuple1[i];
                if (!member2.isChildOrEqualTo(member1)) {
                    return false;
                }
                if (member1.getLevel().getDepth() >= member2.getLevel().getDepth()) continue;
                ++parentLevelCount;
            }
            return parentLevelCount > 0;
        }

        private static void checkIfAggregationSizeIsTooLarge(List list) {
            IntegerProperty property = MondrianProperties.instance().MaxConstraints;
            int maxConstraints = property.get();
            if (list.size() > maxConstraints) {
                throw FunUtil.newEvalException(null, "Aggregation is not supported over a list with more than " + maxConstraints + " predicates" + " (see property " + property.getPath() + ")");
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            if (hierarchy.getDimension().isMeasures()) {
                return true;
            }
            return AggregateCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }

        public static TupleList optimizeChildren(TupleList tuples, SchemaReader reader, Cube baseCubeForMeasure) {
            Map<Member, Integer>[] membersOccurencesInTuple = AggregateCalc.membersVersusOccurencesInTuple(tuples);
            int tupleLength = tuples.getArity();
            Set[] sets = new Set[tupleLength];
            boolean optimized = false;
            for (int i = 0; i < tupleLength; ++i) {
                if (Util.areOccurencesEqual(membersOccurencesInTuple[i].values())) {
                    Set<Member> members = membersOccurencesInTuple[i].keySet();
                    int originalSize = members.size();
                    sets[i] = AggregateCalc.optimizeMemberSet(new LinkedHashSet<Member>(members), reader, baseCubeForMeasure);
                    if (sets[i].size() == originalSize) continue;
                    optimized = true;
                    continue;
                }
                sets[i] = new LinkedHashSet<Member>(membersOccurencesInTuple[i].keySet());
            }
            if (optimized) {
                return AggregateCalc.crossProd(sets);
            }
            return tuples;
        }

        public static Map<Member, Integer>[] membersVersusOccurencesInTuple(TupleList tupleList) {
            int tupleLength = tupleList.getArity();
            Map[] counters = new Map[tupleLength];
            for (int i = 0; i < counters.length; ++i) {
                counters[i] = new LinkedHashMap();
            }
            for (List tuple : tupleList) {
                for (int i = 0; i < tuple.size(); ++i) {
                    Map map = counters[i];
                    Member member = (Member)tuple.get(i);
                    if (map.containsKey(member)) {
                        Integer count = (Integer)map.get(member);
                        count = count + 1;
                        map.put(member, count);
                        continue;
                    }
                    map.put(member, 1);
                }
            }
            return counters;
        }

        private static Set<Member> optimizeMemberSet(Set<Member> members, SchemaReader reader, Cube baseCubeForMeasure) {
            LinkedHashSet<Member> membersToBeOptimized = new LinkedHashSet<Member>();
            Set<Member> optimizedMembers = new LinkedHashSet<Member>();
            while (members.size() > 0) {
                boolean didOptimize;
                Iterator<Member> iterator = members.iterator();
                Member first = iterator.next();
                if (first.isAll()) {
                    optimizedMembers.clear();
                    optimizedMembers.add(first);
                    return optimizedMembers;
                }
                membersToBeOptimized.add(first);
                iterator.remove();
                Member firstParentMember = first.getParentMember();
                while (iterator.hasNext()) {
                    Member current = iterator.next();
                    if (current.isAll()) {
                        optimizedMembers.clear();
                        optimizedMembers.add(current);
                        return optimizedMembers;
                    }
                    Member currentParentMember = current.getParentMember();
                    if ((firstParentMember != null || currentParentMember != null) && (firstParentMember == null || !firstParentMember.equals(currentParentMember))) continue;
                    membersToBeOptimized.add(current);
                    iterator.remove();
                }
                int childCountOfParent = -1;
                if (firstParentMember != null) {
                    childCountOfParent = AggregateCalc.getChildCount(firstParentMember, reader);
                }
                if (childCountOfParent != -1 && membersToBeOptimized.size() == childCountOfParent && AggregateCalc.canOptimize(firstParentMember, baseCubeForMeasure)) {
                    optimizedMembers.add(firstParentMember);
                    didOptimize = true;
                } else {
                    optimizedMembers.addAll(membersToBeOptimized);
                    didOptimize = false;
                }
                membersToBeOptimized.clear();
                if (members.size() != 0 || !didOptimize) continue;
                Set<Member> temp = members;
                members = optimizedMembers;
                optimizedMembers = temp;
            }
            return optimizedMembers;
        }

        private static boolean isEqual(Member[] tuple1, Member[] tuple2) {
            for (int i = 0; i < tuple1.length; ++i) {
                if (tuple1[i].getUniqueName().equals(tuple2[i].getUniqueName())) continue;
                return false;
            }
            return true;
        }

        private static boolean canOptimize(Member parentMember, Cube baseCube) {
            return AggregateCalc.dimensionJoinsToBaseCube(parentMember.getDimension(), baseCube) || !parentMember.isAll();
        }

        private static TupleList crossProd(Set<Member>[] sets) {
            ArrayList<TupleList> tupleLists = new ArrayList<TupleList>();
            for (Set<Member> set : sets) {
                tupleLists.add(new UnaryTupleList(new ArrayList<Member>(set)));
            }
            if (tupleLists.size() == 1) {
                return (TupleList)tupleLists.get(0);
            }
            return CrossJoinFunDef.mutableCrossJoin(tupleLists);
        }

        private static boolean dimensionJoinsToBaseCube(Dimension dimension, Cube baseCube) {
            HashSet<Dimension> dimensions = new HashSet<Dimension>();
            dimensions.add(dimension);
            return baseCube.nonJoiningDimensions(dimensions).size() == 0;
        }

        private static int getChildCount(Member parentMember, SchemaReader reader) {
            int childrenCountFromCache = reader.getChildrenCountFromCache(parentMember);
            if (childrenCountFromCache != -1) {
                return childrenCountFromCache;
            }
            return reader.getMemberChildren(parentMember).size();
        }
    }
}

