/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Annotation;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Category;
import mondrian.olap.CellProperty;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.IdBatchResolver;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NameResolver;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Property;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.QueryTiming;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.ValidatorImpl;
import mondrian.olap.Walker;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapUtil;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.spi.ProfileHandler;
import mondrian.util.ArrayStack;
import org.apache.commons.collections.collection.CompositeCollection;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.IdentifierSegment;

public class Query
extends QueryPart {
    private Formula[] formulas;
    public QueryAxis[] axes;
    private QueryAxis slicerAxis;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private final Map<String, Parameter> parametersByName = new HashMap<String, Parameter>();
    private final QueryPart[] cellProps;
    private final Cube cube;
    private final Statement statement;
    public Calc[] axisCalcs;
    public Calc slicerCalc;
    Set<FunDef> alertedNonNativeFunDefs;
    private Set<Member> measuresMembers;
    private boolean nativeCrossJoinVirtualCube;
    private List<RolapCube> baseCubes;
    private boolean strictValidation;
    private ResultStyle resultStyle = Util.Retrowoven ? ResultStyle.LIST : ResultStyle.ITERABLE;
    private Map<String, Object> evalCache = new HashMap<String, Object>();
    private final List<ScopedNamedSet> scopedNamedSets = new ArrayList<ScopedNamedSet>();
    private boolean ownStatement;

    public Query(Statement statement, Formula[] formulas, QueryAxis[] axes, String cube, QueryAxis slicerAxis, QueryPart[] cellProps, boolean strictValidation) {
        this(statement, Util.lookupCube(statement.getSchemaReader(), cube, true), formulas, axes, slicerAxis, cellProps, new Parameter[0], strictValidation);
    }

    public Query(Statement statement, Cube mdxCube, Formula[] formulas, QueryAxis[] axes, QueryAxis slicerAxis, QueryPart[] cellProps, Parameter[] parameters, boolean strictValidation) {
        this.statement = statement;
        this.cube = mdxCube;
        this.formulas = formulas;
        this.axes = axes;
        this.normalizeAxes();
        this.slicerAxis = slicerAxis;
        this.cellProps = cellProps;
        this.parameters.addAll(Arrays.asList(parameters));
        this.measuresMembers = new HashSet<Member>();
        this.nativeCrossJoinVirtualCube = true;
        this.strictValidation = strictValidation;
        this.alertedNonNativeFunDefs = new HashSet<FunDef>();
        statement.setQuery(this);
        this.resolve();
        if (RolapUtil.PROFILE_LOGGER.isDebugEnabled() && statement.getProfileHandler() == null) {
            statement.enableProfiling(new ProfileHandler(){

                @Override
                public void explain(String plan, QueryTiming timing) {
                    if (timing != null) {
                        plan = plan + "\n" + timing;
                    }
                    RolapUtil.PROFILE_LOGGER.debug((Object)plan);
                }
            });
        }
    }

    public void setQueryTimeoutMillis(long queryTimeoutMillis) {
        this.statement.setQueryTimeoutMillis(queryTimeoutMillis);
    }

    public boolean hasCellProperty(String propertyName) {
        for (QueryPart cellProp : this.cellProps) {
            if (!((CellProperty)cellProp).isNameEquals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCellPropertyEmpty() {
        return this.cellProps.length == 0;
    }

    public void addFormula(Id id, Exp exp) {
        this.addFormula(new Formula(false, id, exp, new MemberProperty[0], null, null));
    }

    public void addFormula(Id id, Exp exp, MemberProperty[] memberProperties) {
        this.addFormula(new Formula(true, id, exp, memberProperties, null, null));
    }

    public void addFormula(Formula formula) {
        this.formulas = Util.append(this.formulas, formula);
        this.resolve();
    }

    public void addFormulas(Formula ... additions) {
        this.formulas = Util.appendArrays(this.formulas, new Formula[][]{additions});
        this.resolve();
    }

    public Validator createValidator() {
        return this.createValidator(this.statement.getSchema().getFunTable(), false, new HashMap<QueryPart, QueryPart>());
    }

    public Validator createValidator(Map<QueryPart, QueryPart> resolvedIdentifiers) {
        return this.createValidator(this.statement.getSchema().getFunTable(), false, resolvedIdentifiers);
    }

    public Validator createValidator(FunTable functionTable, boolean alwaysResolveFunDef) {
        return new QueryValidator(functionTable, alwaysResolveFunDef, this, new HashMap<QueryPart, QueryPart>());
    }

    public Validator createValidator(FunTable functionTable, boolean alwaysResolveFunDef, Map<QueryPart, QueryPart> resolvedIdentifiers) {
        return new QueryValidator(functionTable, alwaysResolveFunDef, this, resolvedIdentifiers);
    }

    public Query safeClone() {
        return this.clone();
    }

    public Query clone() {
        return new Query(this.statement, this.cube, Formula.cloneArray(this.formulas), QueryAxis.cloneArray(this.axes), this.slicerAxis == null ? null : (QueryAxis)this.slicerAxis.clone(), this.cellProps, this.parameters.toArray(new Parameter[this.parameters.size()]), this.strictValidation);
    }

    public Connection getConnection() {
        return this.statement.getMondrianConnection();
    }

    public void cancel() {
        try {
            this.statement.cancel();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkCancelOrTimeout() {
        Execution execution0 = this.statement.getCurrentExecution();
        if (execution0 == null) {
            return;
        }
        execution0.checkCancelOrTimeout();
    }

    public long getQueryStartTime() {
        Execution currentExecution = this.statement.getCurrentExecution();
        return currentExecution == null ? 0L : currentExecution.getStartTime();
    }

    public boolean shouldAlertForNonNative(FunDef funDef) {
        return this.alertedNonNativeFunDefs.add(funDef);
    }

    private void normalizeAxes() {
        block0: for (int i = 0; i < this.axes.length; ++i) {
            AxisOrdinal correctOrdinal = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(i);
            if (this.axes[i].getAxisOrdinal() == correctOrdinal) continue;
            for (int j = i + 1; j < this.axes.length; ++j) {
                if (this.axes[j].getAxisOrdinal() != correctOrdinal) continue;
                QueryAxis temp = this.axes[i];
                this.axes[i] = this.axes[j];
                this.axes[j] = temp;
                continue block0;
            }
        }
    }

    public void resolve() {
        this.createFormulaElements();
        Map<QueryPart, QueryPart> resolvedIdentifiers = new IdBatchResolver(this).resolve();
        Validator validator = this.createValidator(resolvedIdentifiers);
        this.resolve(validator);
        Evaluator evaluator = RolapUtil.createEvaluator(this.statement);
        ExpCompiler compiler = this.createCompiler(evaluator, validator, Collections.singletonList(this.resultStyle));
        this.compile(compiler);
    }

    private void createFormulaElements() {
        if (this.formulas != null) {
            for (Formula formula : this.formulas) {
                formula.createElement(this);
            }
        }
    }

    public boolean ignoreInvalidMembers() {
        MondrianProperties props = MondrianProperties.instance();
        boolean load = ((RolapCube)this.getCube()).isLoadInProgress();
        return !this.strictValidation && (load ? props.IgnoreInvalidMembers.get() : props.IgnoreInvalidMembersDuringQuery.get());
    }

    public void setResultStyle(ResultStyle resultStyle) {
        switch (resultStyle) {
            case ITERABLE: {
                this.resultStyle = Util.Retrowoven ? ResultStyle.LIST : ResultStyle.ITERABLE;
                break;
            }
            case LIST: 
            case MUTABLE_LIST: {
                this.resultStyle = resultStyle;
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, resultStyle);
            }
        }
    }

    public ResultStyle getResultStyle() {
        return this.resultStyle;
    }

    private void compile(ExpCompiler compiler) {
        if (this.formulas != null) {
            for (Formula formula : this.formulas) {
                formula.compile();
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axisCalcs[i] = this.axes[i].compile(compiler, this.resultStyle);
            }
        }
        if (this.slicerAxis != null) {
            this.slicerCalc = this.slicerAxis.compile(compiler, this.resultStyle);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resolve(Validator validator) {
        this.parameters.clear();
        this.parametersByName.clear();
        this.accept(new ParameterFinder());
        this.accept(new AliasedExpressionFinder());
        if (this.formulas != null) {
            for (Formula formula : this.formulas) {
                validator.validate(formula);
            }
        }
        if (this.axes != null) {
            HashSet<Integer> axisNames = new HashSet<Integer>();
            for (QueryAxis axis : this.axes) {
                validator.validate(axis);
                if (axisNames.add(axis.getAxisOrdinal().logicalOrdinal())) continue;
                throw MondrianResource.instance().DuplicateAxis.ex(axis.getAxisName());
            }
            int n = AxisOrdinal.StandardAxisOrdinal.COLUMNS.logicalOrdinal();
            for (QueryAxis axis : this.axes) {
                void var3_6;
                if (!axisNames.contains((int)var3_6)) {
                    AxisOrdinal axisName = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal((int)var3_6);
                    throw MondrianResource.instance().NonContiguousAxis.ex((int)var3_6, axisName.name());
                }
                ++var3_6;
            }
        }
        if (this.slicerAxis != null) {
            this.slicerAxis.validate(validator);
        }
        for (Hierarchy hierarchy : ((RolapCube)this.getCube()).getHierarchies()) {
            int useCount = 0;
            for (QueryAxis axis : this.allAxes()) {
                if (!axis.getSet().getType().usesHierarchy(hierarchy, true)) continue;
                ++useCount;
            }
            if (useCount <= true) continue;
            throw MondrianResource.instance().HierarchyInIndependentAxes.ex(hierarchy.getUniqueName());
        }
    }

    @Override
    public void explain(PrintWriter pw) {
        boolean profiling = this.getStatement().getProfileHandler() != null;
        CalcWriter calcWriter = new CalcWriter(pw, profiling);
        for (Formula formula : this.formulas) {
            formula.getMdxMember();
        }
        if (this.slicerCalc != null) {
            pw.println("Axis (FILTER):");
            this.slicerCalc.accept(calcWriter);
            pw.println();
        }
        int i = -1;
        for (QueryAxis axis : this.axes) {
            pw.println("Axis (" + axis.getAxisName() + "):");
            this.axisCalcs[++i].accept(calcWriter);
            pw.println();
        }
        pw.flush();
    }

    private Collection<QueryAxis> allAxes() {
        if (this.slicerAxis == null) {
            return Arrays.asList(this.axes);
        }
        return new CompositeCollection(new Collection[]{Collections.singletonList(this.slicerAxis), Arrays.asList(this.axes)});
    }

    @Override
    public void unparse(PrintWriter pw) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                if (i == 0) {
                    pw.print("with ");
                } else {
                    pw.print("  ");
                }
                this.formulas[i].unparse(pw);
                pw.println();
            }
        }
        pw.print("select ");
        if (this.axes != null) {
            for (i = 0; i < this.axes.length; ++i) {
                this.axes[i].unparse(pw);
                if (i < this.axes.length - 1) {
                    pw.println(",");
                    pw.print("  ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.cube != null) {
            pw.println("from [" + this.cube.getName() + "]");
        }
        if (this.slicerAxis != null) {
            pw.print("where ");
            this.slicerAxis.unparse(pw);
            pw.println();
        }
    }

    public String toString() {
        this.resolve();
        return Util.unparse(this);
    }

    @Override
    public Object[] getChildren() {
        ArrayList<QueryPart> list = new ArrayList<QueryPart>();
        list.addAll(Arrays.asList(this.axes));
        if (this.slicerAxis != null) {
            list.add(this.slicerAxis);
        }
        list.addAll(Arrays.asList(this.formulas));
        return list.toArray();
    }

    public QueryAxis getSlicerAxis() {
        return this.slicerAxis;
    }

    public void setSlicerAxis(QueryAxis axis) {
        this.slicerAxis = axis;
    }

    public void addLevelToAxis(AxisOrdinal axis, Level level) {
        assert (axis != null);
        this.axes[axis.logicalOrdinal()].addLevel(level);
    }

    private Hierarchy[] collectHierarchies(Exp queryPart) {
        Type exprType = queryPart.getType();
        if (exprType instanceof SetType) {
            exprType = ((SetType)exprType).getElementType();
        }
        if (exprType instanceof TupleType) {
            Type[] types = ((TupleType)exprType).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (Type type : types) {
                hierarchyList.add(this.getTypeHierarchy(type));
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{this.getTypeHierarchy(exprType)};
    }

    private Hierarchy getTypeHierarchy(Type type) {
        Hierarchy hierarchy = type.getHierarchy();
        if (hierarchy != null) {
            return hierarchy;
        }
        Dimension dimension = type.getDimension();
        if (dimension != null) {
            return dimension.getHierarchy();
        }
        return null;
    }

    public void setParameter(final String parameterName, final Object value) {
        Parameter param;
        if (this.parameters.isEmpty()) {
            this.resolve();
        }
        if ((param = this.getSchemaReader(false).getParameter(parameterName)) == null) {
            throw MondrianResource.instance().UnknownParameter.ex(parameterName);
        }
        if (!param.isModifiable()) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(parameterName, param.getScope().name());
        }
        Object value2 = Locus.execute(new Execution(this.statement, 0L), "Query.quickParse", new Locus.Action<Object>(){

            @Override
            public Object execute() {
                return Query.quickParse(parameterName, param.getType(), value, Query.this);
            }
        });
        param.setValue(value2);
    }

    private static Object quickParse(String parameterName, Type type, Object value, Query query) throws NumberFormatException {
        int category = TypeUtil.typeToCategory(type);
        switch (category) {
            case 7: {
                if (value instanceof Number || value == null) {
                    return value;
                }
                if (value instanceof String) {
                    String s = (String)value;
                    try {
                        return new Integer(s);
                    }
                    catch (NumberFormatException e) {
                        return new Double(s);
                    }
                }
                throw Util.newInternal("Invalid value '" + value + "' for parameter '" + parameterName + "', type " + type);
            }
            case 9: {
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
            case 8: {
                if (value instanceof String) {
                    value = IdentifierParser.parseIdentifierList((String)((String)value));
                }
                if (!(value instanceof List)) {
                    throw Util.newInternal("Invalid value '" + value + "' for parameter '" + parameterName + "', type " + type);
                }
                ArrayList<Member> expList = new ArrayList<Member>();
                List<Id.Segment> list = value;
                SetType setType = (SetType)type;
                Type elementType = setType.getElementType();
                for (Id.Segment o : list) {
                    if (o == null) continue;
                    Member member = (Member)Query.quickParse(parameterName, elementType, o, query);
                    expList.add(member);
                }
                return expList;
            }
            case 6: {
                List<IdentifierSegment> olap4jSegmentList;
                List<Id.Segment> segmentList;
                OlapElement olapElement;
                List<Id.Segment> segmentList2;
                OlapElement olapElement2;
                if (value == null) {
                    if (type.getHierarchy() != null) {
                        value = type.getHierarchy().getNullMember();
                    } else if (type.getDimension() != null) {
                        value = type.getDimension().getHierarchy().getNullMember();
                    }
                }
                if (value instanceof String) {
                    value = Util.parseIdentifier((String)value);
                }
                if (value instanceof List && Util.canCast(value, Id.Segment.class) && (olapElement2 = Util.lookup(query, segmentList2 = Util.cast((List)value))) instanceof Member) {
                    value = olapElement2;
                }
                if (value instanceof List && Util.canCast(value, IdentifierSegment.class) && (olapElement = Util.lookup(query, segmentList = Util.convert(olap4jSegmentList = Util.cast((List)value)))) instanceof Member) {
                    value = olapElement;
                }
                if (value instanceof Member && type.isInstance(value)) {
                    return value;
                }
                throw Util.newInternal("Invalid value '" + value + "' for parameter '" + parameterName + "', type " + type);
            }
        }
        throw Category.instance.badValue(category);
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getSet();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            Exp e1 = this.axes[1].getSet();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setSet(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[0].setSet(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
        }
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public Cube getCube() {
        return this.cube;
    }

    public SchemaReader getSchemaReader(boolean accessControlled) {
        Role role = accessControlled ? this.getConnection().getRole() : null;
        SchemaReader cubeSchemaReader = this.cube.getSchemaReader(role);
        return new QuerySchemaReader(cubeSchemaReader, this);
    }

    public Member lookupMemberFromCache(String memberUniqueName) {
        for (Member member : this.getDefinedMembers()) {
            if (!Util.equalName(member.getUniqueName(), memberUniqueName) && !Util.equalName(this.getUniqueNameWithoutAll(member), memberUniqueName)) continue;
            return member;
        }
        return null;
    }

    private String getUniqueNameWithoutAll(Member member) {
        Member parentMember = member.getParentMember();
        if (parentMember != null && !parentMember.isAll()) {
            return Util.makeFqName(this.getUniqueNameWithoutAll(parentMember), member.getName());
        }
        return Util.makeFqName(member.getHierarchy(), member.getName());
    }

    private NamedSet lookupNamedSet(Id.Segment segment) {
        if (!(segment instanceof Id.NameSegment)) {
            return null;
        }
        Id.NameSegment nameSegment = (Id.NameSegment)segment;
        for (Formula formula : this.formulas) {
            if (formula.isMember() || formula.getElement() == null || !formula.getName().equals(nameSegment.getName())) continue;
            return (NamedSet)formula.getElement();
        }
        return null;
    }

    public ScopedNamedSet createScopedNamedSet(String name, QueryPart scope, Exp expr) {
        ScopedNamedSet scopedNamedSet = new ScopedNamedSet(name, scope, expr);
        this.scopedNamedSets.add(scopedNamedSet);
        return scopedNamedSet;
    }

    ScopedNamedSet lookupScopedNamedSet(List<Id.Segment> nameParts, ArrayStack<QueryPart> scopeList) {
        if (nameParts.size() != 1) {
            return null;
        }
        if (!(nameParts.get(0) instanceof Id.NameSegment)) {
            return null;
        }
        String name = ((Id.NameSegment)nameParts.get(0)).getName();
        ScopedNamedSet bestScopedNamedSet = null;
        int bestScopeOrdinal = -1;
        for (ScopedNamedSet scopedNamedSet : this.scopedNamedSets) {
            int scopeOrdinal;
            if (!Util.equalName(scopedNamedSet.name, name) || (scopeOrdinal = scopeList.indexOf(scopedNamedSet.scope)) <= bestScopeOrdinal) continue;
            bestScopedNamedSet = scopedNamedSet;
            bestScopeOrdinal = scopeOrdinal;
        }
        return bestScopedNamedSet;
    }

    public Formula[] getFormulas() {
        return this.formulas;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void removeFormula(String uniqueName, boolean failIfUsedInQuery) {
        Formula formula = this.findFormula(uniqueName);
        if (failIfUsedInQuery && formula != null) {
            OlapElement mdxElement = formula.getElement();
            Walker walker = new Walker(this);
            while (walker.hasMoreElements()) {
                Object queryElement = walker.nextElement();
                if (!queryElement.equals(mdxElement)) continue;
                String formulaType = formula.isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                int i = 0;
                Object parent = walker.getAncestor(i);
                Object grandParent = walker.getAncestor(i + 1);
                while (parent != null && grandParent != null) {
                    if (grandParent instanceof Query) {
                        if (parent instanceof Axis) {
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedOnAxis.ex(formulaType, uniqueName, ((QueryAxis)parent).getAxisName());
                        }
                        if (parent instanceof Formula) {
                            String parentFormulaType = ((Formula)parent).isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedInFormula.ex(formulaType, uniqueName, parentFormulaType, ((Formula)parent).getUniqueName());
                        }
                        throw MondrianResource.instance().MdxCalculatedFormulaUsedOnSlicer.ex(formulaType, uniqueName);
                    }
                    parent = walker.getAncestor(++i);
                    grandParent = walker.getAncestor(i + 1);
                }
                throw MondrianResource.instance().MdxCalculatedFormulaUsedInQuery.ex(formulaType, uniqueName, Util.unparse(this));
            }
        }
        ArrayList<Formula> formulaList = new ArrayList<Formula>();
        for (Formula formula1 : this.formulas) {
            if (formula1.getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            formulaList.add(formula1);
        }
        this.formulas = formulaList.toArray(new Formula[formulaList.size()]);
    }

    public boolean canRemoveFormula(String uniqueName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            return false;
        }
        OlapElement mdxElement = formula.getElement();
        Walker walker = new Walker(this);
        while (walker.hasMoreElements()) {
            Object queryElement = walker.nextElement();
            if (queryElement instanceof MemberExpr && ((MemberExpr)queryElement).getMember().equals(mdxElement)) {
                return false;
            }
            if (!(queryElement instanceof NamedSetExpr) || !((NamedSetExpr)queryElement).getNamedSet().equals(mdxElement)) continue;
            return false;
        }
        return true;
    }

    public Formula findFormula(String uniqueName) {
        for (Formula formula : this.formulas) {
            if (!formula.getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            return formula;
        }
        return null;
    }

    public void renameFormula(String uniqueName, String newName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            throw MondrianResource.instance().MdxFormulaNotFound.ex("formula", uniqueName, Util.unparse(this));
        }
        formula.rename(newName);
    }

    List<Member> getDefinedMembers() {
        ArrayList<Member> definedMembers = new ArrayList<Member>();
        for (Formula formula : this.formulas) {
            if (!formula.isMember() || formula.getElement() == null || !this.getConnection().getRole().canAccess(formula.getElement())) continue;
            definedMembers.add((Member)formula.getElement());
        }
        return definedMembers;
    }

    public void setAxisShowEmptyCells(int axis, boolean showEmpty) {
        if (axis >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(axis);
        }
        this.axes[axis].setNonEmpty(!showEmpty);
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(AxisOrdinal axis) {
        if (axis.logicalOrdinal() >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(axis.logicalOrdinal());
        }
        QueryAxis queryAxis = axis.isFilter() ? this.slicerAxis : this.axes[axis.logicalOrdinal()];
        return this.collectHierarchies(queryAxis.getSet());
    }

    public Calc compileExpression(Exp exp, boolean scalar, ResultStyle resultStyle) {
        this.statement.setQuery(this);
        Evaluator evaluator = RolapEvaluator.create(this.statement);
        Validator validator = this.createValidator();
        List<ResultStyle> resultStyleList = Collections.singletonList(resultStyle != null ? resultStyle : this.resultStyle);
        ExpCompiler compiler = this.createCompiler(evaluator, validator, resultStyleList);
        if (scalar) {
            return compiler.compileScalar(exp, false);
        }
        return compiler.compile(exp);
    }

    public ExpCompiler createCompiler() {
        this.statement.setQuery(this);
        Evaluator evaluator = RolapEvaluator.create(this.statement);
        Validator validator = this.createValidator();
        return this.createCompiler(evaluator, validator, Collections.singletonList(this.resultStyle));
    }

    private ExpCompiler createCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyleList) {
        ExpCompiler compiler = ExpCompiler.Factory.getExpCompiler(evaluator, validator, resultStyleList);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        ProfileHandler profileHandler = this.statement.getProfileHandler();
        if (profileHandler != null) {
            compiler = RolapUtil.createProfilingCompiler(compiler);
        } else if (expDeps > 0) {
            compiler = RolapUtil.createDependencyTestingCompiler(compiler);
        }
        return compiler;
    }

    public void addMeasuresMembers(OlapElement olapElement) {
        Member member;
        if (olapElement instanceof Member && (member = (Member)olapElement).isMeasure()) {
            this.measuresMembers.add(member);
        }
    }

    public Set<Member> getMeasuresMembers() {
        return Collections.unmodifiableSet(this.measuresMembers);
    }

    public void setVirtualCubeNonNativeCrossJoin() {
        this.nativeCrossJoinVirtualCube = false;
    }

    public boolean nativeCrossJoinVirtualCube() {
        return this.nativeCrossJoinVirtualCube;
    }

    public void setBaseCubes(List<RolapCube> baseCubes) {
        this.baseCubes = baseCubes;
    }

    public List<RolapCube> getBaseCubes() {
        return this.baseCubes;
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        if (visitor.shouldVisitChildren()) {
            for (Formula formula : this.formulas) {
                formula.accept(visitor);
            }
            for (QueryPart queryPart : this.axes) {
                ((QueryAxis)queryPart).accept(visitor);
            }
            if (this.slicerAxis != null) {
                this.slicerAxis.accept(visitor);
            }
        }
        return o;
    }

    public void putEvalCache(String key, Object value) {
        this.evalCache.put(key, value);
    }

    public Object getEvalCache(String key) {
        return this.evalCache.get(key);
    }

    public void clearEvalCache() {
        this.evalCache.clear();
    }

    public void close() {
        if (this.ownStatement) {
            this.statement.close();
        }
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setOwnStatement(boolean ownStatement) {
        this.ownStatement = ownStatement;
    }

    private class AliasedExpressionFinder
    extends MdxVisitorImpl {
        private AliasedExpressionFinder() {
        }

        @Override
        public Object visit(QueryAxis queryAxis) {
            this.registerAlias(queryAxis, queryAxis.getSet());
            return super.visit(queryAxis);
        }

        @Override
        public Object visit(UnresolvedFunCall call) {
            this.registerAliasArgs(call);
            return super.visit(call);
        }

        @Override
        public Object visit(ResolvedFunCall call) {
            this.registerAliasArgs(call);
            return super.visit(call);
        }

        private void registerAliasArgs(FunCall call) {
            for (Exp exp : call.getArgs()) {
                this.registerAlias((QueryPart)((Object)call), exp);
            }
        }

        private void registerAlias(QueryPart parent, Exp exp) {
            FunCall call2;
            if (exp instanceof FunCall && (call2 = (FunCall)exp).getSyntax() == Syntax.Infix && call2.getFunName().equals("AS")) {
                assert (call2.getArgCount() == 2);
                if (call2.getArg(1) instanceof Id) {
                    Id id = (Id)call2.getArg(1);
                    Query.this.createScopedNamedSet(((Id.NameSegment)id.getSegments().get(0)).getName(), parent, call2.getArg(0));
                } else if (call2.getArg(1) instanceof NamedSetExpr) {
                    NamedSetExpr set = (NamedSetExpr)call2.getArg(1);
                    Query.this.createScopedNamedSet(set.getNamedSet().getName(), parent, call2.getArg(0));
                }
            }
        }
    }

    private class ParameterFinder
    extends MdxVisitorImpl {
        private ParameterFinder() {
        }

        @Override
        public Object visit(ParameterExpr parameterExpr) {
            Parameter parameter = parameterExpr.getParameter();
            if (!Query.this.parameters.contains(parameter)) {
                Query.this.parameters.add(parameter);
                Query.this.parametersByName.put(parameter.getName(), parameter);
            }
            return null;
        }

        @Override
        public Object visit(UnresolvedFunCall call) {
            if (call.getFunName().equals("Parameter")) {
                String parameterName = ParameterFunDef.getParameterName(call.getArgs());
                if (Query.this.parametersByName.get(parameterName) != null) {
                    throw MondrianResource.instance().ParameterDefinedMoreThanOnce.ex(parameterName);
                }
                Type type = ParameterFunDef.getParameterType(call.getArgs());
                ParameterImpl parameter = new ParameterImpl(parameterName, Literal.nullValue, null, type);
                Query.this.parameters.add(parameter);
                Query.this.parametersByName.put(parameterName, parameter);
            }
            return null;
        }
    }

    public static class ScopedNamedSet
    implements NamedSet {
        private final String name;
        private final QueryPart scope;
        private Exp expr;

        private ScopedNamedSet(String name, QueryPart scope, Exp expr) {
            this.name = name;
            this.scope = scope;
            this.expr = expr;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNameUniqueWithinQuery() {
            return System.identityHashCode(this) + "";
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public Exp getExp() {
            return this.expr;
        }

        public void setExp(Exp expr) {
            this.expr = expr;
        }

        @Override
        public void setName(String newName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type getType() {
            return this.expr.getType();
        }

        @Override
        public Map<String, Annotation> getAnnotationMap() {
            return Collections.emptyMap();
        }

        @Override
        public NamedSet validate(Validator validator) {
            Exp newExpr = this.expr.accept(validator);
            Type type = newExpr.getType();
            if (type instanceof MemberType || type instanceof TupleType) {
                newExpr = new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{newExpr}).accept(validator);
            }
            this.expr = newExpr;
            return this;
        }

        @Override
        public String getUniqueName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCaption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isVisible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hierarchy getHierarchy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension getDimension() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocalized(OlapElement.LocalizedProperty prop, Locale locale) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ScopedSchemaReader
    extends DelegatingSchemaReader
    implements NameResolver.Namespace {
        private final QueryValidator queryValidator;
        private final boolean accessControlled;

        private ScopedSchemaReader(QueryValidator queryValidator, boolean accessControlled) {
            super(queryValidator.getQuery().getSchemaReader(accessControlled));
            this.queryValidator = queryValidator;
            this.accessControlled = accessControlled;
        }

        @Override
        public SchemaReader withoutAccessControl() {
            if (!this.accessControlled) {
                return this;
            }
            return new ScopedSchemaReader(this.queryValidator, false);
        }

        @Override
        public List<NameResolver.Namespace> getNamespaces() {
            ArrayList<NameResolver.Namespace> list = new ArrayList<NameResolver.Namespace>();
            list.add(this);
            list.addAll(super.getNamespaces());
            return list;
        }

        @Override
        public OlapElement lookupCompoundInternal(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
            switch (category) {
                case 0: 
                case 8: {
                    ScopedNamedSet namedSet = this.queryValidator.getQuery().lookupScopedNamedSet(names, this.queryValidator.getScopeStack());
                    if (namedSet == null) break;
                    return namedSet;
                }
            }
            return super.lookupCompoundInternal(parent, names, failIfNotFound, category, matchType);
        }

        @Override
        public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment, MatchType matchType) {
            return this.lookupChild(parent, segment);
        }

        @Override
        public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment) {
            if (!(parent instanceof Cube)) {
                return null;
            }
            return this.queryValidator.getQuery().lookupScopedNamedSet(Collections.singletonList(Util.convert(segment)), this.queryValidator.getScopeStack());
        }
    }

    private static class QueryValidator
    extends ValidatorImpl {
        private final boolean alwaysResolveFunDef;
        private Query query;
        private final SchemaReader schemaReader;

        public QueryValidator(FunTable functionTable, boolean alwaysResolveFunDef, Query query, Map<QueryPart, QueryPart> resolvedIdentifiers) {
            super(functionTable, resolvedIdentifiers);
            this.alwaysResolveFunDef = alwaysResolveFunDef;
            this.query = query;
            this.schemaReader = new ScopedSchemaReader(this, true);
        }

        @Override
        public SchemaReader getSchemaReader() {
            return this.schemaReader;
        }

        @Override
        protected void defineParameter(Parameter param) {
            String name = param.getName();
            this.query.parameters.add(param);
            this.query.parametersByName.put(name, param);
        }

        @Override
        public Query getQuery() {
            return this.query;
        }

        @Override
        public boolean alwaysResolveFunDef() {
            return this.alwaysResolveFunDef;
        }

        public ArrayStack<QueryPart> getScopeStack() {
            return this.stack;
        }
    }

    private static class ConnectionParameterImpl
    extends ParameterImpl {
        public ConnectionParameterImpl(String name, Literal defaultValue) {
            super(name, defaultValue, "Connection property", new StringType());
        }

        @Override
        public Parameter.Scope getScope() {
            return Parameter.Scope.Connection;
        }

        @Override
        public void setValue(Object value) {
            throw MondrianResource.instance().ParameterIsNotModifiable.ex(this.getName(), this.getScope().name());
        }
    }

    private static class QuerySchemaReader
    extends DelegatingSchemaReader
    implements NameResolver.Namespace {
        private final Query query;

        public QuerySchemaReader(SchemaReader cubeSchemaReader, Query query) {
            super(cubeSchemaReader);
            this.query = query;
        }

        @Override
        public SchemaReader withoutAccessControl() {
            return new QuerySchemaReader(this.schemaReader.withoutAccessControl(), this.query);
        }

        @Override
        public Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
            String uniqueName = Util.implode(uniqueNameParts);
            Member member = this.query.lookupMemberFromCache(uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(uniqueNameParts, failIfNotFound, matchType);
            }
            if (!failIfNotFound && member == null) {
                return null;
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        @Override
        public List<Member> getLevelMembers(Level level, boolean includeCalculated) {
            List<Member> members = super.getLevelMembers(level, false);
            if (includeCalculated) {
                members = Util.addLevelCalculatedMembers(this, level, members);
            }
            return members;
        }

        @Override
        public Member getCalculatedMember(List<Id.Segment> nameParts) {
            for (Formula formula : this.query.formulas) {
                Member member;
                if (!formula.isMember() || (member = (Member)formula.getElement()) == null || !Util.matches(member, nameParts) || !this.query.getConnection().getRole().canAccess(member)) continue;
                return member;
            }
            return null;
        }

        @Override
        public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
            ArrayList<Member> result = new ArrayList<Member>();
            List<Member> calculatedMembers = super.getCalculatedMembers(hierarchy);
            result.addAll(calculatedMembers);
            for (Member member : this.query.getDefinedMembers()) {
                if (!member.getHierarchy().equals(hierarchy)) continue;
                result.add(member);
            }
            return result;
        }

        @Override
        public List<Member> getCalculatedMembers(Level level) {
            List<Member> hierarchyMembers = this.getCalculatedMembers(level.getHierarchy());
            ArrayList<Member> result = new ArrayList<Member>();
            for (Member member : hierarchyMembers) {
                if (!member.getLevel().equals(level)) continue;
                result.add(member);
            }
            return result;
        }

        @Override
        public List<Member> getCalculatedMembers() {
            return this.query.getDefinedMembers();
        }

        @Override
        public OlapElement getElementChild(OlapElement parent, Id.Segment s) {
            return this.getElementChild(parent, s, MatchType.EXACT);
        }

        @Override
        public OlapElement getElementChild(OlapElement parent, Id.Segment s, MatchType matchType) {
            OlapElement mdxElement = this.schemaReader.getElementChild(parent, s, matchType);
            if (mdxElement != null) {
                return mdxElement;
            }
            if (!(s instanceof Id.NameSegment)) {
                return null;
            }
            String name = ((Id.NameSegment)s).getName();
            for (Formula formula : this.query.formulas) {
                Id id;
                if (formula.isMember() || (id = formula.getIdentifier()).getSegments().size() != 1 || !id.getSegments().get(0).matches(name)) continue;
                return formula.getNamedSet();
            }
            return mdxElement;
        }

        @Override
        public OlapElement lookupCompoundInternal(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
            Member member;
            Formula formula;
            OlapElement oe;
            if (matchType == MatchType.EXACT && (oe = this.lookupCompound(parent, names, failIfNotFound, category, MatchType.EXACT_SCHEMA)) != null) {
                return oe;
            }
            switch (category) {
                case 0: 
                case 6: {
                    Member calculatedMember;
                    if (parent != this.query.cube || (calculatedMember = this.getCalculatedMember(names)) == null) break;
                    return calculatedMember;
                }
            }
            switch (category) {
                case 0: 
                case 8: {
                    NamedSet namedSet;
                    if (parent != this.query.cube || (namedSet = this.getNamedSet(names)) == null) break;
                    return namedSet;
                }
            }
            OlapElement olapElement = super.lookupCompoundInternal(parent, names, failIfNotFound, category, matchType);
            if (olapElement instanceof Member && (formula = (Formula)(member = (Member)olapElement).getPropertyValue(Property.FORMULA.name)) != null) {
                Formula formulaClone = (Formula)formula.clone();
                formulaClone.createElement(this.query);
                formulaClone.accept(this.query.createValidator());
                olapElement = formulaClone.getMdxMember();
            }
            return olapElement;
        }

        @Override
        public NamedSet getNamedSet(List<Id.Segment> nameParts) {
            if (nameParts.size() != 1) {
                return null;
            }
            return this.query.lookupNamedSet(nameParts.get(0));
        }

        @Override
        public Parameter getParameter(String name) {
            for (Parameter parameter : this.query.parameters) {
                if (!parameter.getName().equals(name)) continue;
                return parameter;
            }
            if (Util.lookup(RolapConnectionProperties.class, name) != null) {
                Object value = this.query.statement.getProperty(name);
                Literal defaultValue = Literal.createString(String.valueOf(value));
                return new ConnectionParameterImpl(name, defaultValue);
            }
            return super.getParameter(name);
        }

        @Override
        public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment, MatchType matchType) {
            return this.lookupChild(parent, segment);
        }

        @Override
        public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment) {
            for (Formula formula : this.query.getFormulas()) {
                if (!NameResolver.matches(formula, parent, segment)) continue;
                return formula.getElement();
            }
            return null;
        }

        @Override
        public List<NameResolver.Namespace> getNamespaces() {
            ArrayList<NameResolver.Namespace> list = new ArrayList<NameResolver.Namespace>();
            list.add(this);
            list.addAll(super.getNamespaces());
            return list;
        }
    }
}

