/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.api.FormDeployment;
import org.activiti.form.api.FormDeploymentBuilder;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.FormRepositoryServiceImpl;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntityManager;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.io.IOUtils;

public class FormDeploymentBuilderImpl
implements FormDeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected transient FormRepositoryServiceImpl repositoryService;
    protected transient ResourceEntityManager resourceEntityManager;
    protected FormDeploymentEntity deployment;
    protected boolean isDuplicateFilterEnabled;

    public FormDeploymentBuilderImpl() {
        FormEngineConfiguration formEngineConfiguration = Context.getFormEngineConfiguration();
        this.repositoryService = (FormRepositoryServiceImpl)formEngineConfiguration.getFormRepositoryService();
        this.deployment = (FormDeploymentEntity)formEngineConfiguration.getDeploymentEntityManager().create();
        this.resourceEntityManager = formEngineConfiguration.getResourceEntityManager();
    }

    public FormDeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        if (inputStream == null) {
            throw new ActivitiFormException("inputStream for resource '" + resourceName + "' is null");
        }
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new ActivitiFormException("could not get byte array from resource '" + resourceName + "'");
        }
        if (bytes == null) {
            throw new ActivitiFormException("byte array for resource '" + resourceName + "' is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    public FormDeploymentBuilder addClasspathResource(String resource) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (inputStream == null) {
            throw new ActivitiFormException("resource '" + resource + "' not found");
        }
        return this.addInputStream(resource, inputStream);
    }

    public FormDeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new ActivitiFormException("text is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        try {
            resource.setBytes(text.getBytes(DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new ActivitiFormException("Unable to get process bytes.", e);
        }
        this.deployment.addResource(resource);
        return this;
    }

    public FormDeploymentBuilder addFormBytes(String resourceName, byte[] formBytes) {
        if (formBytes == null) {
            throw new ActivitiFormException("form bytes is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(formBytes);
        this.deployment.addResource(resource);
        return this;
    }

    public FormDeploymentBuilder addFormDefinition(String resourceName, FormDefinition formDefinition) {
        FormJsonConverter formConverter = new FormJsonConverter();
        String formJson = formConverter.convertToJson(formDefinition);
        this.addString(resourceName, formJson);
        return this;
    }

    public FormDeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    public FormDeploymentBuilder category(String category) {
        this.deployment.setCategory(category);
        return this;
    }

    public FormDeploymentBuilder tenantId(String tenantId) {
        this.deployment.setTenantId(tenantId);
        return this;
    }

    public FormDeploymentBuilder parentDeploymentId(String parentDeploymentId) {
        this.deployment.setParentDeploymentId(parentDeploymentId);
        return this;
    }

    public FormDeployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public FormDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }
}

