/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.activiti.form.engine.ActivitiFormIllegalArgumentException;
import org.activiti.form.engine.impl.cmd.GetDeploymentResourceCmd;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;

public class GetDeploymentFormResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formId;

    public GetDeploymentFormResourceCmd(String formId) {
        if (formId == null || formId.length() < 1) {
            throw new ActivitiFormIllegalArgumentException("The form id is mandatory, but '" + formId + "' has been provided.");
        }
        this.formId = formId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        FormEntity form = commandContext.getFormEngineConfiguration().getDeploymentManager().findDeployedFormById(this.formId);
        String deploymentId = form.getDeploymentId();
        String resourceName = form.getResourceName();
        InputStream formStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return formStream;
    }
}

