/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.api.SubmittedForm;
import org.activiti.form.api.SubmittedFormQuery;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.ActivitiFormObjectNotFoundException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.FormExpression;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.model.CompletedFormDefinition;
import org.activiti.form.model.ExpressionFormField;
import org.activiti.form.model.FormDefinition;
import org.activiti.form.model.FormField;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCompletedFormDefinitionCmd
implements Command<CompletedFormDefinition>,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(GetCompletedFormDefinitionCmd.class);
    private static final long serialVersionUID = 1L;
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formId;
    protected String taskId;
    protected String processInstanceId;
    protected String tenantId;
    protected Map<String, Object> variables;

    public GetCompletedFormDefinitionCmd(String formDefinitionKey, String formId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, null, formId, null, taskId, processInstanceId, variables);
    }

    public GetCompletedFormDefinitionCmd(String formDefinitionKey, String parentDeploymentId, String formId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, parentDeploymentId, formId, null, taskId, processInstanceId, variables);
    }

    public GetCompletedFormDefinitionCmd(String formDefinitionKey, String parentDeploymentId, String formId, String taskId, String processInstanceId, String tenantId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, parentDeploymentId, formId, tenantId, taskId, processInstanceId, variables);
    }

    @Override
    public CompletedFormDefinition execute(CommandContext commandContext) {
        if (this.taskId == null && this.processInstanceId == null) {
            throw new ActivitiFormException("A task id or process instance id should be provided");
        }
        FormCacheEntry formCacheEntry = this.resolveForm(commandContext);
        SubmittedForm submittedForm = this.resolveSubmittedForm(commandContext);
        CompletedFormDefinition formDefinition = this.resolveRuntimeFormDefinition(formCacheEntry, submittedForm, commandContext);
        this.fillFormFieldValues(submittedForm, formDefinition, commandContext);
        return formDefinition;
    }

    protected void initializeValues(String formDefinitionKey, String parentDeploymentId, String formId, String tenantId, String taskId, String processInstanceId, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.parentDeploymentId = parentDeploymentId;
        this.formId = formId;
        this.tenantId = tenantId;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void fillFormFieldValues(SubmittedForm submittedForm, CompletedFormDefinition formDefinition, CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = commandContext.getFormEngineConfiguration();
        List allFields = formDefinition.listAllFields();
        if (allFields != null) {
            Map<String, JsonNode> submittedFormFieldMap = this.fillPreviousFormValues(submittedForm, formEngineConfiguration);
            this.fillSubmittedFormValues(formDefinition, submittedForm, submittedFormFieldMap, formEngineConfiguration.getObjectMapper());
            this.fillVariablesWithFormValues(submittedFormFieldMap, allFields);
            for (FormField field : allFields) {
                if (field instanceof ExpressionFormField) {
                    ExpressionFormField expressionField = (ExpressionFormField)field;
                    FormExpression formExpression = formEngineConfiguration.getExpressionManager().createExpression(expressionField.getExpression());
                    try {
                        field.setValue(formExpression.getValue(this.variables));
                    }
                    catch (Exception e) {
                        logger.error("Error getting value for expression " + expressionField.getExpression() + " " + e.getMessage());
                    }
                } else {
                    field.setValue(this.variables.get(field.getId()));
                }
                field.setReadOnly(true);
            }
        }
    }

    protected FormCacheEntry resolveForm(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getFormEngineConfiguration().getDeploymentManager();
        FormEntity formEntity = null;
        if (this.formId != null) {
            formEntity = deploymentManager.findDeployedFormById(this.formId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for id = '" + this.formId + "'", FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formEntity = deploymentManager.findDeployedLatestFormByKey(this.formDefinitionKey);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "'", FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyAndParentDeploymentId(this.formDefinitionKey, this.parentDeploymentId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyParentDeploymentIdAndTenantId(this.formDefinitionKey, this.parentDeploymentId, this.tenantId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormEntity.class);
            }
        } else {
            throw new ActivitiFormObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormCacheEntry formCacheEntry = deploymentManager.resolveForm(formEntity);
        return formCacheEntry;
    }

    protected SubmittedForm resolveSubmittedForm(CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = commandContext.getFormEngineConfiguration();
        SubmittedFormQuery submittedFormQuery = formEngineConfiguration.getFormService().createSubmittedFormQuery().formId(this.formId);
        if (this.taskId != null) {
            submittedFormQuery.taskId(this.taskId);
        } else {
            submittedFormQuery.processInstanceId(this.processInstanceId);
        }
        List submittedForms = submittedFormQuery.list();
        if (submittedForms.size() == 0) {
            throw new ActivitiFormException("No submitted form could be found");
        }
        SubmittedForm submittedForm = null;
        if (this.taskId != null) {
            if (submittedForms.size() > 1) {
                throw new ActivitiFormException("Multiple submitted forms are found for the same task");
            }
            submittedForm = (SubmittedForm)submittedForms.get(0);
        } else {
            for (SubmittedForm form : submittedForms) {
                if (form.getTaskId() != null) continue;
                submittedForm = form;
                break;
            }
        }
        if (submittedForm == null) {
            throw new ActivitiFormException("No submitted form could be found");
        }
        return submittedForm;
    }

    protected Map<String, JsonNode> fillPreviousFormValues(SubmittedForm submittedForm, FormEngineConfiguration formEngineConfiguration) {
        HashMap<String, JsonNode> submittedFormMap = new HashMap<String, JsonNode>();
        if (this.taskId != null && this.processInstanceId != null) {
            List submittedForms = ((SubmittedFormQuery)formEngineConfiguration.getFormService().createSubmittedFormQuery().processInstanceId(this.processInstanceId).submittedDateBefore(submittedForm.getSubmittedDate()).orderBySubmittedDate().desc()).list();
            for (SubmittedForm otherForm : submittedForms) {
                if (otherForm.getId().equals(submittedForm.getId())) continue;
                try {
                    JsonNode submittedNode = formEngineConfiguration.getObjectMapper().readTree(submittedForm.getFormValueBytes());
                    if (submittedNode == null || submittedNode.get("values") != null) continue;
                    JsonNode valuesNode = submittedNode.get("values");
                    Iterator fieldIdIterator = valuesNode.fieldNames();
                    while (fieldIdIterator.hasNext()) {
                        String fieldId = (String)fieldIdIterator.next();
                        if (submittedFormMap.containsKey(fieldId)) continue;
                        JsonNode valueNode = valuesNode.get(fieldId);
                        submittedFormMap.put(fieldId, valueNode);
                    }
                }
                catch (Exception e) {
                    throw new ActivitiFormException("Error parsing submitted form " + submittedForm.getId());
                }
            }
        }
        return submittedFormMap;
    }

    protected void fillSubmittedFormValues(CompletedFormDefinition runtimeFormDefinition, SubmittedForm submittedForm, Map<String, JsonNode> submittedFormFieldMap, ObjectMapper objectMapper) {
        try {
            JsonNode outcomeNode;
            JsonNode submittedNode = objectMapper.readTree(submittedForm.getFormValueBytes());
            if (submittedNode == null) {
                return;
            }
            if (submittedNode.get("values") != null) {
                JsonNode valuesNode = submittedNode.get("values");
                Iterator fieldIdIterator = valuesNode.fieldNames();
                while (fieldIdIterator.hasNext()) {
                    String fieldId = (String)fieldIdIterator.next();
                    JsonNode valueNode = valuesNode.get(fieldId);
                    submittedFormFieldMap.put(fieldId, valueNode);
                }
            }
            if (submittedNode.get("outcome") != null && !(outcomeNode = submittedNode.get("outcome")).isNull() && StringUtils.isNotEmpty((CharSequence)outcomeNode.asText())) {
                runtimeFormDefinition.setSelectedOutcome(outcomeNode.asText());
            }
        }
        catch (Exception e) {
            throw new ActivitiFormException("Error parsing submitted form " + submittedForm.getId(), e);
        }
    }

    public void fillVariablesWithFormValues(Map<String, JsonNode> submittedFormFieldMap, List<FormField> allFields) {
        for (FormField field : allFields) {
            JsonNode fieldValueNode = submittedFormFieldMap.get(field.getId());
            if (fieldValueNode == null || fieldValueNode.isNull()) continue;
            String fieldType = field.getType();
            String fieldValue = fieldValueNode.asText();
            if ("date".equals(fieldType)) {
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    LocalDate dateValue = LocalDate.parse((String)fieldValue);
                    this.variables.put(field.getId(), dateValue.toString("d-M-yyyy"));
                }
                catch (Exception e) {
                    logger.error("Error parsing form date value for process instance " + this.processInstanceId + " and task " + this.taskId + " with value " + fieldValue, (Throwable)e);
                }
                continue;
            }
            this.variables.put(field.getId(), fieldValue);
        }
    }

    protected CompletedFormDefinition resolveRuntimeFormDefinition(FormCacheEntry formCacheEntry, SubmittedForm submittedForm, CommandContext commandContext) {
        FormEntity formEntity = formCacheEntry.getFormEntity();
        FormJsonConverter formJsonConverter = commandContext.getFormEngineConfiguration().getFormJsonConverter();
        FormDefinition formDefinition = formJsonConverter.convertToForm(formCacheEntry.getFormJson(), formEntity.getId(), formEntity.getVersion());
        CompletedFormDefinition runtimeFormDefinition = new CompletedFormDefinition(formDefinition);
        runtimeFormDefinition.setId(formEntity.getId());
        runtimeFormDefinition.setName(formEntity.getName());
        runtimeFormDefinition.setKey(formEntity.getKey());
        runtimeFormDefinition.setTenantId(formEntity.getTenantId());
        runtimeFormDefinition.setSubmittedFormId(submittedForm.getId());
        runtimeFormDefinition.setTaskId(submittedForm.getTaskId());
        runtimeFormDefinition.setProcessInstanceId(submittedForm.getProcessInstanceId());
        runtimeFormDefinition.setProcessDefinitionId(submittedForm.getProcessDefinitionId());
        runtimeFormDefinition.setSubmittedBy(submittedForm.getSubmittedBy());
        runtimeFormDefinition.setSubmittedDate(submittedForm.getSubmittedDate());
        return runtimeFormDefinition;
    }
}

