/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl;

import java.io.InputStream;
import java.util.List;
import org.activiti.form.api.Form;
import org.activiti.form.api.FormDeployment;
import org.activiti.form.api.FormDeploymentBuilder;
import org.activiti.form.api.FormDeploymentQuery;
import org.activiti.form.api.FormQuery;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.api.NativeFormDeploymentQuery;
import org.activiti.form.api.NativeFormQuery;
import org.activiti.form.engine.impl.FormDeploymentQueryImpl;
import org.activiti.form.engine.impl.FormQueryImpl;
import org.activiti.form.engine.impl.NativeFormDeploymentQueryImpl;
import org.activiti.form.engine.impl.NativeFormQueryImpl;
import org.activiti.form.engine.impl.ServiceImpl;
import org.activiti.form.engine.impl.cmd.DeleteDeploymentCmd;
import org.activiti.form.engine.impl.cmd.DeployCmd;
import org.activiti.form.engine.impl.cmd.GetDeploymentFormCmd;
import org.activiti.form.engine.impl.cmd.GetDeploymentFormResourceCmd;
import org.activiti.form.engine.impl.cmd.GetDeploymentResourceCmd;
import org.activiti.form.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.activiti.form.engine.impl.cmd.GetFormDefinitionCmd;
import org.activiti.form.engine.impl.cmd.SetDeploymentCategoryCmd;
import org.activiti.form.engine.impl.cmd.SetDeploymentTenantIdCmd;
import org.activiti.form.engine.impl.cmd.SetFormCategoryCmd;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.repository.FormDeploymentBuilderImpl;
import org.activiti.form.model.FormDefinition;

public class FormRepositoryServiceImpl
extends ServiceImpl
implements FormRepositoryService {
    public FormDeploymentBuilder createDeployment() {
        return this.commandExecutor.execute(new Command<FormDeploymentBuilder>(){

            @Override
            public FormDeploymentBuilder execute(CommandContext commandContext) {
                return new FormDeploymentBuilderImpl();
            }
        });
    }

    public FormDeployment deploy(FormDeploymentBuilderImpl deploymentBuilder) {
        return this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId));
    }

    public FormQuery createFormQuery() {
        return new FormQueryImpl(this.commandExecutor);
    }

    public NativeFormQuery createNativeFormQuery() {
        return new NativeFormQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return this.commandExecutor.execute(new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute(new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute(new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public FormDeploymentQuery createDeploymentQuery() {
        return new FormDeploymentQueryImpl(this.commandExecutor);
    }

    public NativeFormDeploymentQuery createNativeDeploymentQuery() {
        return new NativeFormDeploymentQueryImpl(this.commandExecutor);
    }

    public Form getForm(String formId) {
        return this.commandExecutor.execute(new GetDeploymentFormCmd(formId));
    }

    public FormDefinition getFormDefinitionById(String formId) {
        return this.commandExecutor.execute(new GetFormDefinitionCmd(null, formId));
    }

    public FormDefinition getFormDefinitionByKey(String formDefinitionKey) {
        return this.commandExecutor.execute(new GetFormDefinitionCmd(formDefinitionKey, null));
    }

    public FormDefinition getFormDefinitionByKey(String formDefinitionKey, String tenantId) {
        return this.commandExecutor.execute(new GetFormDefinitionCmd(formDefinitionKey, null, tenantId));
    }

    public FormDefinition getFormDefinitionByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        return this.commandExecutor.execute(new GetFormDefinitionCmd(formDefinitionKey, null, null, parentDeploymentId));
    }

    public FormDefinition getFormDefinitionByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        return this.commandExecutor.execute(new GetFormDefinitionCmd(formDefinitionKey, null, tenantId, parentDeploymentId));
    }

    public InputStream getFormResource(String formId) {
        return this.commandExecutor.execute(new GetDeploymentFormResourceCmd(formId));
    }

    public void setFormCategory(String formId, String category) {
        this.commandExecutor.execute(new SetFormCategoryCmd(formId, category));
    }
}

