/*
 * Decompiled with CFR 0.152.
 */
package org.espy.arima;

import org.espy.arima.DoubleUtils;

class StationarityTest {
    private static final double STATIONARITY_THRESHOLD = 0.10815;

    StationarityTest() {
    }

    public static Result test(double[] observations, Result previousResult) {
        boolean stationary;
        double c2;
        if (observations.length < 2) {
            return new Result(true, 0.0);
        }
        double min = observations[0];
        double max = observations[0];
        double total = observations[0];
        int medianIndex = observations.length / 2;
        int i = 1;
        while (i < medianIndex) {
            double observation = observations[i];
            total += observation;
            if (min > observation) {
                min = observation;
            } else if (max < observation) {
                max = observation;
            }
            ++i;
        }
        double sum1 = total;
        int i2 = medianIndex;
        while (i2 < observations.length) {
            double observation = observations[i2];
            total += observation;
            if (min > observation) {
                min = observation;
            } else if (max < observation) {
                max = observation;
            }
            ++i2;
        }
        if (DoubleUtils.isApproximateEqual(min, max)) {
            return new Result(true, min);
        }
        double sum2 = total - sum1;
        double mean = total / (double)observations.length;
        double mean1 = sum1 / (double)medianIndex;
        double mean2 = sum2 / (double)(observations.length - medianIndex);
        double c1 = Math.abs(mean - mean1) + Math.abs(mean - mean2);
        double stationarityEstimation = c1 / (c2 = max - min);
        boolean bl = stationary = stationarityEstimation < 0.10815;
        if (!stationary && previousResult != null) {
            stationary = Math.abs(stationarityEstimation - previousResult.stationarityEstimation) < 0.01;
        }
        return new Result(stationary, mean, stationarityEstimation);
    }

    public static final class Result {
        public final boolean stationary;
        public final double mean;
        public final double stationarityEstimation;

        public Result(boolean stationary, double mean) {
            this(stationary, mean, -1.0);
        }

        public Result(boolean stationary, double mean, double stationarityEstimation) {
            this.stationary = stationary;
            this.mean = mean;
            this.stationarityEstimation = stationarityEstimation;
        }
    }
}

