/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime.variable;

import org.activiti.app.model.runtime.RestVariable;
import org.activiti.app.rest.runtime.variable.RestVariableConverter;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.springframework.stereotype.Component;

@Component
public class DoubleRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "double";
    }

    @Override
    public Class<?> getVariableType() {
        return Double.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert doubles");
            }
            return ((Number)result.getValue()).doubleValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Double)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert doubles");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

