/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.idm;

import java.util.ArrayList;
import java.util.List;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.idm.GroupRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/admin/groups"})
public class IdmGroupsResource {
    @Autowired
    private IdentityService identityService;

    @RequestMapping(method={RequestMethod.GET})
    public List<GroupRepresentation> getGroups() {
        this.validateAdminRole();
        List groups = this.identityService.createGroupQuery().list();
        ArrayList<GroupRepresentation> result = new ArrayList<GroupRepresentation>(groups.size());
        for (Group group : groups) {
            result.add(new GroupRepresentation(group));
        }
        return result;
    }

    @RequestMapping(value={"/{groupId}"}, method={RequestMethod.GET})
    public GroupRepresentation getGroup(@PathVariable String groupId) {
        this.validateAdminRole();
        return new GroupRepresentation((Group)this.identityService.createGroupQuery().groupId(groupId).singleResult());
    }

    @RequestMapping(value={"/{groupId}/users"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getGroupUsers(@PathVariable String groupId, @RequestParam(required=false) String filter, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer pageSize) {
        this.validateAdminRole();
        int pageValue = page != null ? page : 0;
        int pageSizeValue = pageSize != null ? pageSize : 50;
        UserQuery userQuery = this.identityService.createUserQuery().memberOfGroup(groupId);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            userQuery.userFullNameLike("%" + filter + "%");
        }
        List users = userQuery.listPage(pageValue, pageSizeValue);
        ArrayList<UserRepresentation> userRepresentations = new ArrayList<UserRepresentation>(users.size());
        for (User user : users) {
            userRepresentations.add(new UserRepresentation(user));
        }
        ResultListDataRepresentation resultListDataRepresentation = new ResultListDataRepresentation(userRepresentations);
        resultListDataRepresentation.setStart(Integer.valueOf(pageValue * pageSizeValue));
        resultListDataRepresentation.setSize(Integer.valueOf(userRepresentations.size()));
        resultListDataRepresentation.setTotal(Long.valueOf(userQuery.count()));
        return resultListDataRepresentation;
    }

    @RequestMapping(method={RequestMethod.POST})
    public GroupRepresentation createNewGroup(@RequestBody GroupRepresentation groupRepresentation) {
        this.validateAdminRole();
        if (StringUtils.isBlank((CharSequence)groupRepresentation.getName())) {
            throw new BadRequestException("Group name required");
        }
        Group newGroup = this.identityService.newGroup(groupRepresentation.getId());
        newGroup.setName(groupRepresentation.getName());
        if (groupRepresentation.getType() == null) {
            newGroup.setType("assignment");
        } else {
            newGroup.setType(groupRepresentation.getType());
        }
        this.identityService.saveGroup(newGroup);
        return new GroupRepresentation(newGroup);
    }

    @RequestMapping(value={"/{groupId}"}, method={RequestMethod.PUT})
    public GroupRepresentation updateGroup(@PathVariable String groupId, @RequestBody GroupRepresentation groupRepresentation) {
        this.validateAdminRole();
        if (StringUtils.isBlank((CharSequence)groupRepresentation.getName())) {
            throw new BadRequestException("Group name required");
        }
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        group.setName(groupRepresentation.getName());
        this.identityService.saveGroup(group);
        return new GroupRepresentation(group);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/{groupId}"}, method={RequestMethod.DELETE})
    public void deleteGroup(@PathVariable String groupId) {
        this.validateAdminRole();
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        this.identityService.deleteGroup(groupId);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/{groupId}/members/{userId}"}, method={RequestMethod.POST})
    public void addGroupMember(@PathVariable String groupId, @PathVariable String userId) {
        this.validateAdminRole();
        this.verifyGroupMemberExists(groupId, userId);
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (user == null) {
            throw new NotFoundException();
        }
        this.identityService.createMembership(userId, groupId);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/{groupId}/members/{userId}"}, method={RequestMethod.DELETE})
    public void deleteGroupMember(@PathVariable String groupId, @PathVariable String userId) {
        this.validateAdminRole();
        this.verifyGroupMemberExists(groupId, userId);
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        if (user == null) {
            throw new NotFoundException();
        }
        this.identityService.deleteMembership(userId, groupId);
    }

    protected void verifyGroupMemberExists(String groupId, String userId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
        for (User groupMember : this.identityService.createUserQuery().memberOfGroup(groupId).list()) {
            if (!groupMember.getId().equals(userId)) continue;
            user = groupMember;
        }
        if (group == null || user == null) {
            throw new NotFoundException();
        }
    }

    protected void validateAdminRole() {
        boolean isAdmin;
        boolean bl = isAdmin = this.identityService.createGroupQuery().groupId("ROLE_ADMIN").groupMember(SecurityUtils.getCurrentUserId()).count() > 0L;
        if (!isAdmin) {
            throw new NotPermittedException();
        }
    }
}

