/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.idm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.app.model.idm.GroupRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.UnauthorizedException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AccountResource {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private IdentityService identityService;

    @RequestMapping(value={"/rest/authenticate"}, method={RequestMethod.GET}, produces={"application/json"})
    public ObjectNode isAuthenticated(HttpServletRequest request) {
        String user = request.getRemoteUser();
        if (user == null) {
            throw new UnauthorizedException("Request did not contain valid authorization");
        }
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("login", user);
        return result;
    }

    @RequestMapping(value={"/rest/account"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserRepresentation getAccount() {
        User user = SecurityUtils.getCurrentActivitiAppUser().getUserObject();
        UserRepresentation userRepresentation = new UserRepresentation(user);
        List groups = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        for (Group group : groups) {
            userRepresentation.getGroups().add(new GroupRepresentation(group));
        }
        return userRepresentation;
    }
}

