/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StencilSetResource {
    private final Logger log = LoggerFactory.getLogger(StencilSetResource.class);
    @Inject
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/rest/stencil-sets/editor"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getStencilSetForEditor() {
        try {
            JsonNode stencilNode = this.objectMapper.readTree(this.getClass().getClassLoader().getResourceAsStream("stencilset_bpmn.json"));
            return stencilNode;
        }
        catch (Exception e) {
            this.log.error("Error reading bpmn stencil set json", (Throwable)e);
            throw new InternalServerErrorException("Error reading bpmn stencil set json");
        }
    }
}

