/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import java.net.URL;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;
import org.renjin.repackaged.guava.annotations.VisibleForTesting;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.ImmutableList;

public class ClasspathFileProvider
extends AbstractFileProvider {
    private static final Collection<Capability> CAPABILITIES = ImmutableList.of(Capability.DISPATCHER);
    private final ClassLoader classLoader;

    public ClasspathFileProvider(ClassLoader classLoader) {
        Preconditions.checkNotNull(classLoader, "classloader");
        this.classLoader = classLoader;
    }

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        StringBuilder buf = new StringBuilder(80);
        UriParser.extractScheme((String)uri, (StringBuilder)buf);
        String resourceName = buf.toString();
        URL url2 = this.classLoader.getResource(resourceName);
        if (url2 == null) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", (Object)uri);
        }
        String normalizeUri = ClasspathFileProvider.normalizeNestedJarUris(url2.toExternalForm());
        return this.getContext().getFileSystemManager().resolveFile(normalizeUri);
    }

    @VisibleForTesting
    public static String normalizeNestedJarUris(String uri) {
        if (!uri.startsWith("jar:file:")) {
            return uri;
        }
        String[] parts = uri.split("!");
        StringBuilder normalized = new StringBuilder();
        normalized.append(parts[0]);
        normalized.append("!");
        for (int i = 1; i < parts.length - 1; ++i) {
            normalized.insert(0, "jar:");
            normalized.append(parts[i]);
            normalized.append("!");
        }
        if (parts.length > 1) {
            normalized.append(parts[parts.length - 1]);
        }
        return normalized.toString();
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return new DefaultFileSystemConfigBuilder();
    }

    public void closeFileSystem(FileSystem filesystem) {
    }

    public Collection<Capability> getCapabilities() {
        return CAPABILITIES;
    }
}

