/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.tools;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.repackaged.guava.hash.Funnels;
import org.renjin.repackaged.guava.hash.Hasher;
import org.renjin.repackaged.guava.hash.Hashing;
import org.renjin.repackaged.guava.io.ByteStreams;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class Md5 {
    public static StringVector hashFiles(@Current Context context, StringVector files2) {
        StringVector.Builder builder = StringVector.newBuilder();
        for (String file2 : files2) {
            try {
                builder.add(Md5.hashFile(context.resolveFile(file2)));
            }
            catch (IOException e) {
                builder.addNA();
            }
        }
        builder.setAttribute(Symbols.NAMES, (SEXP)files2);
        return builder.build();
    }

    private static String hashFile(FileObject fileObject) throws IOException {
        Hasher hasher = Hashing.md5().newHasher();
        try (InputStream inputStream = fileObject.getContent().getInputStream();){
            ByteStreams.copy(inputStream, Funnels.asOutputStream(hasher));
        }
        return hasher.hash().toString();
    }
}

