/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals;

import java.lang.invoke.MethodHandle;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.nmath.dbeta;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.dcauchy;
import org.renjin.nmath.dchisq;
import org.renjin.nmath.dexp;
import org.renjin.nmath.df;
import org.renjin.nmath.dgamma;
import org.renjin.nmath.dgeom;
import org.renjin.nmath.dhyper;
import org.renjin.nmath.dlnorm;
import org.renjin.nmath.dlogis;
import org.renjin.nmath.dnbeta;
import org.renjin.nmath.dnbinom;
import org.renjin.nmath.dnchisq;
import org.renjin.nmath.dnf;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.dnt;
import org.renjin.nmath.dpois;
import org.renjin.nmath.dt;
import org.renjin.nmath.dunif;
import org.renjin.nmath.dweibull;
import org.renjin.nmath.pbeta;
import org.renjin.nmath.pbinom;
import org.renjin.nmath.pcauchy;
import org.renjin.nmath.pchisq;
import org.renjin.nmath.pexp;
import org.renjin.nmath.pf;
import org.renjin.nmath.pgamma;
import org.renjin.nmath.pgeom;
import org.renjin.nmath.phyper;
import org.renjin.nmath.plnorm;
import org.renjin.nmath.plogis;
import org.renjin.nmath.pnbeta;
import org.renjin.nmath.pnbinom;
import org.renjin.nmath.pnchisq;
import org.renjin.nmath.pnf;
import org.renjin.nmath.pnorm;
import org.renjin.nmath.pnt;
import org.renjin.nmath.ppois;
import org.renjin.nmath.pt;
import org.renjin.nmath.ptukey;
import org.renjin.nmath.punif;
import org.renjin.nmath.pweibull;
import org.renjin.nmath.qbeta;
import org.renjin.nmath.qbinom;
import org.renjin.nmath.qcauchy;
import org.renjin.nmath.qchisq;
import org.renjin.nmath.qexp;
import org.renjin.nmath.qf;
import org.renjin.nmath.qgamma;
import org.renjin.nmath.qgeom;
import org.renjin.nmath.qhyper;
import org.renjin.nmath.qlnorm;
import org.renjin.nmath.qlogis;
import org.renjin.nmath.qnbeta;
import org.renjin.nmath.qnbinom;
import org.renjin.nmath.qnchisq;
import org.renjin.nmath.qnf;
import org.renjin.nmath.qnorm;
import org.renjin.nmath.qnt;
import org.renjin.nmath.qpois;
import org.renjin.nmath.qt;
import org.renjin.nmath.qtukey;
import org.renjin.nmath.qunif;
import org.renjin.nmath.qweibull;
import org.renjin.nmath.rbeta;
import org.renjin.nmath.rbinom;
import org.renjin.nmath.rcauchy;
import org.renjin.nmath.rchisq;
import org.renjin.nmath.rexp;
import org.renjin.nmath.rf;
import org.renjin.nmath.rgamma;
import org.renjin.nmath.rgeom;
import org.renjin.nmath.rhyper;
import org.renjin.nmath.rlnorm;
import org.renjin.nmath.rlogis;
import org.renjin.nmath.rmultinom;
import org.renjin.nmath.rnbinom;
import org.renjin.nmath.rnchisq;
import org.renjin.nmath.rnorm;
import org.renjin.nmath.rpois;
import org.renjin.nmath.rt;
import org.renjin.nmath.runif;
import org.renjin.nmath.rweibull;
import org.renjin.nmath.signrank;
import org.renjin.nmath.wilcox;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Vector;

public class Distributions {
    public static int toInt(boolean x) {
        return x ? 1 : 0;
    }

    @DataParallel
    @Internal
    public static double pbeta(double q, @Recycle double shape1, @Recycle double shape2, boolean lowerTail, boolean logP) {
        return pbeta.pbeta(q, shape1, shape2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qbeta(double p, @Recycle double shape1, @Recycle double shape2, boolean lowerTail, boolean logP) {
        return qbeta.qbeta(p, shape1, shape2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dbeta(double x, @Recycle double shape1, @Recycle double shape2, boolean log3) {
        return dbeta.dbeta(x, shape1, shape2, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pnbeta(double q, @Recycle double shape1, @Recycle double shape2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return pnbeta.pnbeta(q, shape1, shape2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnbeta(double p, @Recycle double shape1, @Recycle double shape2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return qnbeta.qnbeta(p, shape1, shape2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnbeta(double x, @Recycle double shape1, @Recycle double shape2, @Recycle double ncp, boolean log3) {
        return dnbeta.dnbeta(x, shape1, shape2, ncp, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pbinom(double q, @Recycle double size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return pbinom.pbinom(q, size, prob, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qbinom(double p, @Recycle double size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return qbinom.qbinom(p, size, prob, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dbinom(double x, @Recycle double size, @Recycle double prob, boolean log3) {
        return dbinom.dbinom(x, size, prob, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pnbinom(double q, @Recycle double size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return pnbinom.pnbinom(q, size, prob, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnbinom(double p, @Recycle double size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return qnbinom.qnbinom(p, size, prob, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnbinom(double x, @Recycle double size, @Recycle double prob, boolean log3) {
        return dnbinom.dnbinom(x, size, prob, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pnbinom_mu(double q, @Recycle double size, @Recycle double mu, boolean lowerTail, boolean logP) {
        return pnbinom.pnbinom_mu(q, size, mu, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnbinom_mu(double p, @Recycle double size, @Recycle double mu, boolean lowerTail, boolean logP) {
        return qnbinom.qnbinom_mu(p, size, mu, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnbinom_mu(double x, @Recycle double size, @Recycle double mu, boolean log3) {
        return dnbinom.dnbinom_mu(x, size, mu, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pcauchy(double q, @Recycle double location, @Recycle double scale, boolean lowerTail, boolean logP) {
        return pcauchy.pcauchy(q, location, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qcauchy(double p, @Recycle double location, @Recycle double scale, boolean lowerTail, boolean logP) {
        return qcauchy.qcauchy(p, location, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dcauchy(double x, @Recycle double location, @Recycle double scale, boolean log3) {
        return dcauchy.dcauchy(x, location, scale, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pchisq(double q, @Recycle double df2, boolean lowerTail, boolean logP) {
        return pchisq.pchisq(q, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qchisq(double p, @Recycle double df2, boolean lowerTail, boolean logP) {
        return qchisq.qchisq(p, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dchisq(double x, @Recycle double df2, boolean log3) {
        return dchisq.dchisq(x, df2, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pnchisq(double q, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return pnchisq.pnchisq(q, df2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnchisq(double p, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return qnchisq.qnchisq(p, df2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnchisq(double x, @Recycle double df2, @Recycle double ncp, boolean log3) {
        return dnchisq.dnchisq(x, df2, ncp, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pexp(double q, @Recycle double scale, boolean lowerTail, boolean logP) {
        return pexp.pexp(q, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qexp(double p, @Recycle double scale, boolean lowerTail, boolean logP) {
        return qexp.qexp(p, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dexp(double x, @Recycle double scale, boolean log3) {
        return dexp.dexp(x, scale, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pf(double q, @Recycle double df1, @Recycle double df2, boolean lowerTail, boolean logP) {
        return pf.pf(q, df1, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qf(double p, @Recycle double df1, @Recycle double df2, boolean lowerTail, boolean logP) {
        return qf.qf(p, df1, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double df(double x, @Recycle double df1, @Recycle double df2, boolean log3) {
        return df.df(x, df1, df2, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pnf(double q, @Recycle double df1, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return pnf.pnf(q, df1, df2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnf(double p, @Recycle double df1, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return qnf.qnf(p, df1, df2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnf(double x, @Recycle double df1, @Recycle double df2, @Recycle double ncp, boolean log3) {
        return dnf.dnf(x, df1, df2, ncp, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pgamma(double q, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return pgamma.pgamma(q, shape, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qgamma(double p, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return qgamma.qgamma(p, shape, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dgamma(double x, @Recycle double shape, @Recycle double scale, boolean log3) {
        return dgamma.dgamma(x, shape, scale, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pgeom(double q, @Recycle double prob, boolean lowerTail, boolean logP) {
        return pgeom.pgeom(q, prob, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qgeom(double p, @Recycle double prob, boolean lowerTail, boolean logP) {
        return qgeom.qgeom(p, prob, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dgeom(double x, @Recycle double prob, boolean log3) {
        return dgeom.dgeom(x, prob, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double phyper(double q, @Recycle double m, @Recycle double n, @Recycle double k, boolean lowerTail, boolean logP) {
        return phyper.phyper(q, m, n, k, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qhyper(double p, @Recycle double m, @Recycle double n, @Recycle double k, boolean lowerTail, boolean logP) {
        return qhyper.qhyper(p, m, n, k, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dhyper(double x, @Recycle double m, @Recycle double n, @Recycle double k, boolean log3) {
        return dhyper.dhyper(x, m, n, k, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double plnorm(double q, @Recycle double meanlog, @Recycle double sdlog, boolean lowerTail, boolean logP) {
        return plnorm.plnorm(q, meanlog, sdlog, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qlnorm(double p, @Recycle double meanlog, @Recycle double sdlog, boolean lowerTail, boolean logP) {
        return qlnorm.qlnorm(p, meanlog, sdlog, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dlnorm(double x, @Recycle double meanlog, @Recycle double sdlog, boolean log3) {
        return dlnorm.dlnorm(x, meanlog, sdlog, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double plogis(double q, @Recycle double location, @Recycle double scale, boolean lowerTail, boolean logP) {
        return plogis.plogis(q, location, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qlogis(double p, @Recycle double location, @Recycle double scale, boolean lowerTail, boolean logP) {
        return qlogis.qlogis(p, location, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dlogis(double x, @Recycle double location, @Recycle double scale, boolean log3) {
        return dlogis.dlogis(x, location, scale, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pnorm(double q, @Recycle double mean2, @Recycle double sd, boolean lowerTail, boolean logP) {
        return pnorm.pnorm5(q, mean2, sd, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnorm(double p, @Recycle double mean2, @Recycle double sd, boolean lowerTail, boolean logP) {
        return qnorm.qnorm5(p, mean2, sd, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnorm(double x, @Recycle double mean2, @Recycle double sd, boolean log3) {
        return dnorm.dnorm4(x, mean2, sd, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double ppois(double q, @Recycle double lambda, boolean lowerTail, boolean logP) {
        return ppois.ppois(q, lambda, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qpois(double p, @Recycle double lambda, boolean lowerTail, boolean logP) {
        return qpois.qpois(p, lambda, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dpois(double x, @Recycle double lambda, boolean log3) {
        return dpois.dpois(x, lambda, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double psignrank(double q, @Recycle double n, boolean lowerTail, boolean logP) {
        return signrank.psignrank(q, n, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qsignrank(double p, @Recycle double n, boolean lowerTail, boolean logP) {
        return signrank.qsignrank(p, n, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dsignrank(double x, @Recycle double n, boolean log3) {
        return signrank.dsignrank(x, n, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pt(double q, @Recycle double df2, boolean lowerTail, boolean logP) {
        return pt.pt(q, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qt(double p, @Recycle double df2, boolean lowerTail, boolean logP) {
        return qt.qt(p, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dt(double x, @Recycle double df2, boolean log3) {
        return dt.dt(x, df2, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double ptukey(double q, @Recycle double nranges, @Recycle double nmeans, @Recycle double df2, boolean lowerTail, boolean logP) {
        return ptukey.ptukey(q, nranges, nmeans, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qtukey(double p, @Recycle double nranges, @Recycle double nmeans, @Recycle double df2, boolean lowerTail, boolean logP) {
        return qtukey.qtukey(p, nranges, nmeans, df2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double pnt(double q, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return pnt.pnt(q, df2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qnt(double p, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return qnt.qnt(p, df2, ncp, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dnt(double x, @Recycle double df2, @Recycle double ncp, boolean log3) {
        return dnt.dnt(x, df2, ncp, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double punif(double q, @Recycle double min2, @Recycle double max2, boolean lowerTail, boolean logP) {
        return punif.punif(q, min2, max2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qunif(double p, @Recycle double min2, @Recycle double max2, boolean lowerTail, boolean logP) {
        return qunif.qunif(p, min2, max2, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dunif(double x, @Recycle double min2, @Recycle double max2, boolean log3) {
        return dunif.dunif(x, min2, max2, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pweibull(double q, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return pweibull.pweibull(q, shape, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qweibull(double p, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return qweibull.qweibull(p, shape, scale, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dweibull(double x, @Recycle double shape, @Recycle double scale, boolean log3) {
        return dweibull.dweibull(x, shape, scale, Distributions.toInt(log3));
    }

    @DataParallel
    @Internal
    public static double pwilcox(double q, @Recycle double m, @Recycle double n, boolean lowerTail, boolean logP) {
        return wilcox.pwilcox(q, m, n, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double qwilcox(double p, @Recycle double m, @Recycle double n, boolean lowerTail, boolean logP) {
        return wilcox.qwilcox(p, m, n, Distributions.toInt(lowerTail), Distributions.toInt(logP));
    }

    @DataParallel
    @Internal
    public static double dwilcox(double x, @Recycle double m, @Recycle double n, boolean log3) {
        return wilcox.dwilcox(x, m, n, Distributions.toInt(log3));
    }

    @Internal
    public static DoubleVector runif(@Current Context context, Vector nVector, AtomicVector min2, AtomicVector max2) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int minLength = min2.length();
        int maxLength = min2.length();
        if (minLength == 0 || maxLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runifMethod = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(runif.runif(runifMethod, min2.getElementAsDouble(j), max2.getElementAsDouble(k)));
            ++k;
            if (++j == minLength) {
                j = 0;
            }
            if (k != maxLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnorm(@Current Context context, Vector nVector, AtomicVector mean2, AtomicVector sd) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int meanLength = mean2.length();
        int sdLength = sd.length();
        if (meanLength == 0 || sdLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rnorm.rnorm(runif2, mean2.getElementAsDouble(j), sd.getElementAsDouble(k)));
            ++k;
            if (++j == meanLength) {
                j = 0;
            }
            if (k != sdLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rgamma(@Current Context context, Vector nVector, AtomicVector shape, AtomicVector scale) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int shapeLength = shape.length();
        int scaleLength = scale.length();
        if (shapeLength == 0 || scaleLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rgamma.rgamma(runif2, shape.getElementAsDouble(j), scale.getElementAsDouble(k)));
            ++k;
            if (++j == shapeLength) {
                j = 0;
            }
            if (k != scaleLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rchisq(@Current Context context, Vector nVector, AtomicVector df2) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int dfLength = df2.length();
        boolean hasNA = df2.containsNA();
        if (dfLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        if (hasNA) {
            for (int i = 0; i < n; ++i) {
                double dfElement = df2.getElementAsDouble(j);
                if (DoubleVector.isNA(dfElement)) {
                    vb.add(Double.NaN);
                } else {
                    vb.add(rchisq.rchisq(runif2, df2.getElementAsDouble(j)));
                }
                if (++j != dfLength) continue;
                j = 0;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                vb.add(rchisq.rchisq(runif2, df2.getElementAsDouble(j)));
                if (++j != dfLength) continue;
                j = 0;
            }
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnchisq(@Current Context context, Vector nVector, AtomicVector df2, double ncp) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int dfLength = df2.length();
        if (dfLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rnchisq.rnchisq(runif2, df2.getElementAsDouble(j), ncp));
            if (++j != dfLength) continue;
            j = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rexp(@Current Context context, Vector nVector, AtomicVector invrate) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int invrateLength = invrate.length();
        if (invrateLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rexp.rexp(runif2, invrate.getElementAsDouble(j)));
            if (++j != invrateLength) continue;
            j = 0;
        }
        return vb.build();
    }

    @Internal
    public static IntVector rpois(@Current Context context, Vector nVector, AtomicVector mu) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return IntVector.EMPTY;
        }
        int muLength = mu.length();
        if (muLength == 0) {
            return IntArrayVector.Builder.withInitialSize(n).build();
        }
        IntArrayVector.Builder vb = IntArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rpois.rpois(runif2, mu.getElementAsDouble(j)));
            if (++j != muLength) continue;
            j = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rsignrank(@Current Context context, Vector nnVector, AtomicVector n) {
        int nn = Distributions.defineSize(nnVector);
        if (nn == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int nLength = n.length();
        if (nLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(nn).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(nn);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        for (int i = 0; i < nn; ++i) {
            vb.add(signrank.rsignrank(runif2, n.getElementAsDouble(j)));
            if (++j != nLength) continue;
            j = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rwilcox(@Current Context context, Vector nnVector, AtomicVector m, AtomicVector n) {
        int nn = Distributions.defineSize(nnVector);
        if (nn == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int mLength = m.length();
        int nLength = n.length();
        if (mLength == 0 || nLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(nn).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(nn);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < nn; ++i) {
            vb.add(wilcox.rwilcox(runif2, m.getElementAsDouble(j), n.getElementAsDouble(k)));
            ++k;
            if (++j == mLength) {
                j = 0;
            }
            if (k != nLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static IntVector rgeom(@Current Context context, Vector nVector, AtomicVector p) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return IntVector.EMPTY;
        }
        int pLength = p.length();
        if (pLength == 0) {
            return IntArrayVector.Builder.withInitialSize(n).build();
        }
        IntArrayVector.Builder vb = IntArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rgeom.rgeom(runif2, p.getElementAsDouble(j)));
            if (++j != pLength) continue;
            j = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rt(@Current Context context, Vector nVector, AtomicVector df2) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int dfLength = df2.length();
        if (dfLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rt.rt(runif2, df2.getElementAsDouble(j)));
            if (++j != dfLength) continue;
            j = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rcauchy(@Current Context context, Vector nVector, AtomicVector location, AtomicVector scale) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int locationLength = location.length();
        int scaleLength = scale.length();
        if (locationLength == 0 || scaleLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rcauchy.rcauchy(runif2, location.getElementAsDouble(j), scale.getElementAsDouble(k)));
            ++k;
            if (++j == locationLength) {
                j = 0;
            }
            if (k != scaleLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rlnorm(@Current Context context, Vector nVector, AtomicVector meanlog, AtomicVector sdlog) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int meanlogLenght = meanlog.length();
        int sdlogLength = sdlog.length();
        if (meanlogLenght == 0 || sdlogLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rlnorm.rlnorm(runif2, meanlog.getElementAsDouble(j), sdlog.getElementAsDouble(k)));
            ++k;
            if (++j == meanlogLenght) {
                j = 0;
            }
            if (k != sdlogLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rlogis(@Current Context context, Vector nVector, AtomicVector location, AtomicVector scale) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int locationLength = location.length();
        int scaleLength = scale.length();
        if (locationLength == 0 || scaleLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rlogis.rlogis(runif2, location.getElementAsDouble(j), scale.getElementAsDouble(k)));
            ++k;
            if (++j == locationLength) {
                j = 0;
            }
            if (k != scaleLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rweibull(@Current Context context, Vector nVector, AtomicVector shape, AtomicVector scale) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int shapeLength = shape.length();
        int scaleLength = scale.length();
        if (shapeLength == 0 || scaleLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rweibull.rweibull(runif2, shape.getElementAsDouble(j), scale.getElementAsDouble(k)));
            ++k;
            if (++j == shapeLength) {
                j = 0;
            }
            if (k != scaleLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static IntVector rnbinom(@Current Context context, Vector nVector, AtomicVector size, AtomicVector prob) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return IntVector.EMPTY;
        }
        int sizeLength = size.length();
        int probLength = prob.length();
        if (sizeLength == 0 || probLength == 0) {
            return IntArrayVector.Builder.withInitialSize(n).build();
        }
        IntArrayVector.Builder vb = IntArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rnbinom.rnbinom(runif2, size.getElementAsDouble(j), prob.getElementAsDouble(k)));
            ++k;
            if (++j == sizeLength) {
                j = 0;
            }
            if (k != probLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rnbinom_mu(@Current Context context, Vector nVector, AtomicVector size, AtomicVector mu) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int sizeLength = size.length();
        int muLenght = mu.length();
        if (sizeLength == 0 || muLenght == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rnbinom.rnbinom_mu(runif2, size.getElementAsDouble(j), mu.getElementAsDouble(k)));
            ++k;
            if (++j == sizeLength) {
                j = 0;
            }
            if (k != muLenght) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static IntVector rbinom(@Current Context context, Vector nVector, AtomicVector size, AtomicVector prob) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return IntVector.EMPTY;
        }
        int sizeLength = size.length();
        int probLength = prob.length();
        if (sizeLength == 0 || probLength == 0) {
            return IntArrayVector.Builder.withInitialSize(n).build();
        }
        IntArrayVector.Builder vb = IntArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rbinom.rbinom(runif2, size.getElementAsDouble(j), prob.getElementAsDouble(k)));
            ++k;
            if (++j == sizeLength) {
                j = 0;
            }
            if (k != probLength) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rf(@Current Context context, Vector nVector, AtomicVector df1, AtomicVector df2) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int df1Length = df1.length();
        int df2Length = df2.length();
        if (df1Length == 0 || df2.length() == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rf.rf(runif2, df1.getElementAsDouble(j), df2.getElementAsDouble(k)));
            ++k;
            if (++j == df1Length) {
                j = 0;
            }
            if (k != df2Length) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rbeta(@Current Context context, Vector nVector, AtomicVector shape1, AtomicVector shape2) {
        int n = Distributions.defineSize(nVector);
        if (n == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int shape1Length = shape1.length();
        int shape2Length = shape2.length();
        if (shape1Length == 0 || shape2Length == 0) {
            return DoubleArrayVector.Builder.withInitialSize(n).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(n);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            vb.add(rbeta.rbeta(runif2, shape1.getElementAsDouble(j), shape2.getElementAsDouble(k)));
            ++k;
            if (++j == shape1Length) {
                j = 0;
            }
            if (k != shape2Length) continue;
            k = 0;
        }
        return vb.build();
    }

    @Internal
    public static DoubleVector rhyper(@Current Context context, Vector nnVector, AtomicVector m, AtomicVector n, AtomicVector k) {
        int nn = Distributions.defineSize(nnVector);
        if (nn == 0) {
            return DoubleArrayVector.EMPTY;
        }
        int mLength = m.length();
        int nLength = n.length();
        int kLength = k.length();
        if (mLength == 0 || nLength == 0 || kLength == 0) {
            return DoubleArrayVector.Builder.withInitialSize(nn).build();
        }
        DoubleArrayVector.Builder vb = DoubleArrayVector.Builder.withInitialCapacity(nn);
        MethodHandle runif2 = context.getSession().getRngMethod();
        int j = 0;
        int p = 0;
        int q = 0;
        for (int i = 0; i < nn; ++i) {
            vb.add(rhyper.rhyper(runif2, m.getElementAsDouble(j), n.getElementAsDouble(p), k.getElementAsDouble(q)));
            ++p;
            ++q;
            if (++j == mLength) {
                j = 0;
            }
            if (p == nLength) {
                p = 0;
            }
            if (q != kLength) continue;
            q = 0;
        }
        return vb.build();
    }

    @Internal
    public static IntVector rmultinom(@Current Context context, int n, int size, AtomicVector probVector) {
        if (IntVector.isNA(size) || size < 0) {
            throw new EvalException("invalid second argument 'size'", new Object[0]);
        }
        double[] prob = Distributions.normalizeProbabilities(probVector);
        DoublePtr probPtr = new DoublePtr(prob);
        int k = prob.length;
        MethodHandle runif2 = context.getSession().getRngMethod();
        int[] ans = new int[n * k];
        int ik = 0;
        int i = 0;
        while (i < n) {
            rmultinom.rmultinom(runif2, size, probPtr, k, new IntPtr(ans, ik));
            ++i;
            ik += k;
        }
        return IntArrayVector.unsafe(ans, AttributeMap.builder().setDim(prob.length, n).build());
    }

    private static double[] normalizeProbabilities(AtomicVector vector2) {
        int i;
        double[] p = vector2.toDoubleArray();
        int n = p.length;
        double sum2 = 0.0;
        int npos = 0;
        for (i = 0; i < n; ++i) {
            if (!DoubleVector.isFinite(p[i])) {
                throw new EvalException("NA in probability vector", new Object[0]);
            }
            if (p[i] < 0.0) {
                throw new EvalException("negative probability", new Object[0]);
            }
            if (!(p[i] > 0.0)) continue;
            ++npos;
            sum2 += p[i];
        }
        if (npos == 0) {
            throw new EvalException("no positive probabilities", new Object[0]);
        }
        i = 0;
        while (i < n) {
            int n2 = i++;
            p[n2] = p[n2] / sum2;
        }
        return p;
    }

    public static int defineSize(Vector input) {
        int inputLength;
        int n = inputLength = input.length() == 1 ? input.getElementAsInt(0) : input.length();
        if (input.length() == 1 && (input.isElementNA(0) || input.isElementNaN(0))) {
            throw new EvalException("invalid arguments.", new Object[0]);
        }
        return inputLength;
    }
}

