/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.invoke.reflection.converters.RuntimeConverter;
import org.renjin.parser.RParser;
import org.renjin.primitives.Warning;
import org.renjin.primitives.special.BreakException;
import org.renjin.primitives.special.NextException;
import org.renjin.repackaged.guava.io.CharSource;
import org.renjin.script.RenjinBindings;
import org.renjin.script.RenjinScriptContext;
import org.renjin.script.RenjinScriptEngineFactory;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class RenjinScriptEngine
implements ScriptEngine,
Invocable {
    private final RenjinScriptEngineFactory factory;
    private final Context topLevelContext;
    private final ScriptContext scriptContext;
    private static final String INLINE_STRING = "inline-string";
    private static final String UNKNOWN = "unknown";

    RenjinScriptEngine(RenjinScriptEngineFactory factory, Session session) {
        this.factory = factory;
        this.topLevelContext = session.getTopLevelContext();
        this.scriptContext = new RenjinScriptContext(this.topLevelContext);
    }

    public Session getSession() {
        return this.topLevelContext.getSession();
    }

    public Context getTopLevelContext() {
        return this.topLevelContext;
    }

    @Override
    public Bindings createBindings() {
        return new RenjinBindings(new HashFrame());
    }

    @Override
    public Object get(String key) {
        return this.topLevelContext.getEnvironment().getVariable(this.topLevelContext, Symbol.get(key));
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return new RenjinBindings(this.topLevelContext.getEnvironment().getFrame());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptContext getContext() {
        return this.scriptContext;
    }

    @Override
    public void put(String key, Object value) {
        SEXP convertedValue = value == null ? Null.INSTANCE : Converters.get(value.getClass()).convertToR(value);
        this.topLevelContext.getEnvironment().setVariable(this.topLevelContext, Symbol.get(key), convertedValue);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
    }

    @Override
    public void setContext(ScriptContext context) {
        throw new UnsupportedOperationException("Cannot set the context");
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        throw new UnsupportedOperationException("nyi");
    }

    @Override
    public Object eval(String script) throws ScriptException {
        String filename = this.getFilenameFromContext(this.scriptContext, INLINE_STRING);
        return this.eval(this.topLevelContext, RParser.parseSource(script + "\n", filename));
    }

    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        String filename = this.getFilenameFromContext(scriptContext, INLINE_STRING);
        ExpressionVector source = RParser.parseSource(script + "\n", filename);
        return this.eval(this.unwrapContext(scriptContext), source);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        String filename = this.getFilenameFromContext(this.scriptContext, INLINE_STRING);
        return this.eval(reader, this.topLevelContext, filename);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        String filename = this.getFilenameFromContext(scriptContext, UNKNOWN);
        return this.eval(reader, this.unwrapContext(scriptContext), filename);
    }

    private Object eval(Reader reader, Context context, String filename) throws ScriptException {
        ExpressionVector source;
        try {
            CharSource terminated = CharSource.concat(this.newReaderSupplier(reader), CharSource.wrap("\n"));
            source = RParser.parseSource(terminated, (SEXP)new CHARSEXP(filename));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        return this.eval(context, source);
    }

    private Object eval(Context context, SEXP source) {
        try {
            return context.evaluate(source, context.getEnvironment());
        }
        catch (BreakException e) {
            throw new EvalException("no loop for break", new Object[0]);
        }
        catch (NextException e) {
            throw new EvalException("no loop for next", new Object[0]);
        }
    }

    public void eval(File file2) throws IOException, ScriptException {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(file2));
        this.scriptContext.setAttribute("javax.script.filename", file2.getName(), 100);
        this.eval(reader);
        reader.close();
    }

    private CharSource newReaderSupplier(final Reader reader) {
        return new CharSource(){

            @Override
            public Reader openStream() throws IOException {
                return reader;
            }
        };
    }

    private Context unwrapContext(ScriptContext scriptContext) {
        return ((RenjinScriptContext)scriptContext).getContext();
    }

    private String getFilenameFromContext(ScriptContext ctx, String defaultValue) {
        String fileName = defaultValue;
        Object oFileName = this.scriptContext.getAttribute("javax.script.filename");
        if (oFileName != null) {
            fileName = oFileName.toString();
        }
        return fileName;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clasz}, new InvocationHandler(){

            @Override
            public Object invoke(Object instance, Method method, Object[] arguments) throws Exception {
                SEXP result = RenjinScriptEngine.this.invokeFunction(method.getName(), arguments);
                return Converters.get(method.getReturnType()).convertToJava(result);
            }
        });
    }

    @Override
    public <T> T getInterface(final Object thiz, Class<T> clasz) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clasz}, new InvocationHandler(){

            @Override
            public Object invoke(Object instance, Method method, Object[] arguments) throws Exception {
                SEXP result = RenjinScriptEngine.this.invokeMethod(thiz, method.getName(), arguments);
                return Converters.get(method.getReturnType()).convertToJava(result);
            }
        });
    }

    @Override
    public SEXP invokeFunction(String name, Object ... arguments) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Function function2 = this.topLevelContext.getEnvironment().findFunction(this.topLevelContext, Symbol.get(name));
        if (function2 == null) {
            throw new NoSuchMethodException(name);
        }
        return this.invoke(function2, arguments);
    }

    @Override
    public SEXP invokeMethod(Object thiz, String name, Object ... arguments) throws ScriptException, NoSuchMethodException {
        SEXP element;
        if (thiz instanceof Environment) {
            element = ((Environment)thiz).getVariable(this.topLevelContext, name);
        } else if (thiz instanceof ListVector) {
            element = ((ListVector)thiz).get(name);
        } else {
            throw new NoSuchMethodException(name);
        }
        if (!(element instanceof Function)) {
            throw new NoSuchMethodException(name);
        }
        Function method = (Function)element;
        return this.invoke(method, arguments);
    }

    private SEXP invoke(Function function2, Object ... arguments) {
        PairList.Builder argList = new PairList.Builder();
        for (Object argument : arguments) {
            argList.add(RuntimeConverter.INSTANCE.convertToR(argument));
        }
        FunctionCall call2 = new FunctionCall(function2, argList.build());
        return this.topLevelContext.evaluate(call2);
    }

    public FunctionCallBuilder invoke(String functionName) {
        return new FunctionCallBuilder(functionName);
    }

    public void printWarnings() {
        SEXP warnings = this.topLevelContext.getBaseEnvironment().getVariable(this.topLevelContext, Warning.LAST_WARNING);
        if (warnings != Symbol.UNBOUND_VALUE) {
            this.topLevelContext.evaluate(FunctionCall.newCall(Symbol.get("print.warnings"), warnings), this.topLevelContext.getBaseEnvironment());
        }
        this.topLevelContext.getBaseEnvironment().remove(Warning.LAST_WARNING);
    }

    public Context getRuntimeContext() {
        return this.topLevelContext;
    }

    public class FunctionCallBuilder {
        private Symbol function;
        private PairList.Builder arguments = new PairList.Builder();

        private FunctionCallBuilder(String functionName) {
            this.function = Symbol.get(functionName);
        }

        public FunctionCallBuilder withArgument(Object argument) {
            this.arguments.add(RuntimeConverter.INSTANCE.convertToR(argument));
            return this;
        }

        public FunctionCallBuilder withNamedArgument(String name, Object argument) {
            this.arguments.add(name, RuntimeConverter.INSTANCE.convertToR(argument));
            return this;
        }

        public <S extends SEXP> S apply() {
            FunctionCall call2 = new FunctionCall(this.function, this.arguments.build());
            return (S)RenjinScriptEngine.this.topLevelContext.evaluate(call2);
        }
    }
}

