/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.renjin.repackaged.guava.base.Joiner;

public class Signature {
    private final String fullSignature;
    private final String[] arguments;

    public Signature(String signature) {
        this.fullSignature = signature;
        this.arguments = signature.split("#");
    }

    public Signature(String[] classes) {
        this.arguments = classes;
        this.fullSignature = Joiner.on('#').join(classes);
    }

    public int getLength() {
        return this.arguments.length;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature1 = (Signature)o;
        return Objects.equals(this.fullSignature, signature1.fullSignature) && Arrays.equals(this.arguments, signature1.arguments);
    }

    public int hashCode() {
        int result = Objects.hash(this.fullSignature);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String getClass(int index) {
        if (index < this.arguments.length) {
            return this.arguments[index];
        }
        return "ANY";
    }

    public List<String> getClasses() {
        return Arrays.asList(this.arguments);
    }

    public String toString() {
        return this.fullSignature;
    }
}

