/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.methods.Methods;
import org.renjin.primitives.Attributes;
import org.renjin.s4.S4;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class S4Slot {
    private String name;
    private List<String> validAssignmentClasses;

    public S4Slot(String name, List<String> validAssignmentClasses) {
        this.name = name;
        this.validAssignmentClasses = validAssignmentClasses;
    }

    public void checkAssignment(Context context, String valueClass) {
        if (this.validAssignmentClasses.contains(valueClass) || this.validAssignmentClasses.contains("ANY")) {
            return;
        }
        this.doCheckAssignment(context, valueClass);
        this.validAssignmentClasses.add(valueClass);
    }

    private void doCheckAssignment(Context context, String valueClass) {
        String slotClass = this.validAssignmentClasses.get(0);
        StringVector class1 = StringVector.valueOf(valueClass);
        SEXP classDef1 = Methods.getClassDef(context, class1, Null.INSTANCE, Null.INSTANCE, true);
        StringVector valueSuperclasses = Attributes.getSlotElementsNames(classDef1, S4.CONTAINS);
        StringVector valueSubclasses = Attributes.getSlotElementsNames(classDef1, S4.SUBCLASSES);
        StringVector class2 = StringVector.valueOf(slotClass);
        SEXP classDef2 = Methods.getClassDef(context, class2, Null.INSTANCE, Null.INSTANCE, true);
        if (classDef2 == null) {
            throw new EvalException("assignment of an object of class " + valueClass + " is not valid for @" + this.name + " in an object of class %s; is(value, \"" + slotClass + "\") is not TRUE", new Object[0]);
        }
        if (Arrays.asList(valueSuperclasses.toArray()).contains(slotClass)) {
            return;
        }
        if (valueSubclasses.length() > 0 || valueSuperclasses.length() > 0) {
            String classDef2Class = ((StringVector)classDef2.getAttribute(Symbols.CLASS)).getElementAsString(0);
            if (!"classRepresenation".equals(classDef2Class) && "ClassUnionRepresentation".equals(classDef2Class)) {
                ArrayList<String> allClasses = new ArrayList<String>();
                allClasses.add(valueClass);
                allClasses.addAll(Arrays.asList(valueSuperclasses.toArray()));
                StringVector slotSubclasses = Attributes.getSlotElementsNames(classDef2, S4.SUBCLASSES);
                if (slotSubclasses.length() > 0) {
                    allClasses.addAll(Arrays.asList(slotSubclasses.toArray()));
                }
                if (this.hasDuplicate(allClasses)) {
                    return;
                }
            }
        } else {
            List<String> namesList;
            StringVector slotclassNames;
            SEXP slotclassContains = classDef2.getAttribute(S4.CONTAINS);
            if (slotclassContains != null && (slotclassNames = (StringVector)slotclassContains.getAttribute(Symbols.NAMES)) != null && (namesList = Arrays.asList(slotclassNames.toArray())).contains(valueClass)) {
                return;
            }
        }
        if (!slotClass.equals("ANY") && !this.validAssignmentClasses.contains(valueClass)) {
            throw new EvalException("invalid class object: invalid object for slot \"" + this.name + "\": got class \"" + valueClass + "\", should be or extend class \"" + slotClass + "\"", new Object[0]);
        }
    }

    private <T> boolean hasDuplicate(Iterable<T> all2) {
        HashSet<T> set2 = new HashSet<T>();
        for (T each : all2) {
            if (set2.add(each)) continue;
            return true;
        }
        return false;
    }
}

