/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.eval.ArgumentMatcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.s4.DistanceCalculator;
import org.renjin.s4.Generic;
import org.renjin.s4.Method;
import org.renjin.s4.RankedMethod;
import org.renjin.s4.S4ClassCache;
import org.renjin.s4.Signature;
import org.renjin.s4.SignatureAndInheritance;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class S4MethodTable {
    private Generic generic;
    private ArgumentMatcher argumentMatcher;
    private List<Method> methods = new ArrayList<Method>();
    private int maximumSignatureLength = 0;
    private Map<String, Method> signatureMap = new HashMap<String, Method>();
    private Map<SignatureAndInheritance, RankedMethod> cachedMethods = new HashMap<SignatureAndInheritance, RankedMethod>();

    S4MethodTable(Context context, Generic generic) {
        this.initializeS4Method(context, generic);
    }

    private void initializeS4Method(Context context, Generic generic) {
        this.generic = generic;
        ArrayList<Frame> namespaceFrames = new ArrayList<Frame>();
        namespaceFrames.add(context.getGlobalEnvironment().getFrame());
        for (Namespace namespace : context.getNamespaceRegistry().getLoadedNamespaces()) {
            namespaceFrames.add(namespace.getNamespaceEnvironment().getFrame());
        }
        for (Frame frame2 : namespaceFrames) {
            this.addMethods(context, frame2, generic.getGenericMethodTableName(), 0);
            if (generic.isOps()) {
                this.addMethods(context, frame2, generic.getSubGroupGenericMethodTableName(), 1);
            }
            if (generic.isGroupGeneric()) {
                this.addMethods(context, frame2, generic.getGroupGenericMethodTableName(), 2);
            }
            if (!generic.isStdGenericWithGroup()) continue;
            for (String group : generic.getGroup()) {
                this.addMethods(context, frame2, generic.getGroupStdGenericMethodTableName(group), 1);
            }
        }
        if (this.signatureMap.isEmpty()) {
            this.argumentMatcher = new ArgumentMatcher(Null.INSTANCE);
        } else {
            Method method = this.signatureMap.values().iterator().next();
            this.argumentMatcher = new ArgumentMatcher(method.getDefinition().getFormals());
        }
    }

    private void addMethods(Context context, Frame namespaceFrame, Symbol methodTableName, int groupLevel) {
        SEXP tableValue = namespaceFrame.getVariable(methodTableName);
        if (tableValue == Symbol.UNBOUND_VALUE) {
            return;
        }
        SEXP forcedTable = tableValue.force(context);
        if (!(forcedTable instanceof Environment)) {
            throw new EvalException("Expected an environment object, found " + forcedTable.getTypeName(), new Object[0]);
        }
        Environment table = (Environment)forcedTable;
        for (Symbol symbol2 : table.getSymbolNames()) {
            SEXP definition;
            String signature = symbol2.getPrintName();
            Method method = new Method(this.generic, groupLevel, signature, definition = table.getVariable(context, symbol2));
            if (method.getSignatureLength() > this.maximumSignatureLength) {
                this.maximumSignatureLength = method.getSignatureLength();
            }
            this.methods.add(method);
            this.signatureMap.put(signature, method);
        }
    }

    public boolean isEmpty() {
        return this.signatureMap.isEmpty();
    }

    public ArgumentMatcher getArgumentMatcher() {
        return this.argumentMatcher;
    }

    public int getMaximumSignatureLength() {
        return this.maximumSignatureLength;
    }

    public RankedMethod selectMethod(Context context, Generic generic, Signature signature, boolean[] useInheritance) {
        SignatureAndInheritance methodKey = new SignatureAndInheritance(signature.getArguments(), useInheritance);
        if (this.isEmpty()) {
            this.initializeS4Method(context, generic);
        } else if (this.cachedMethods.containsKey(methodKey)) {
            return this.cachedMethods.get(methodKey);
        }
        S4ClassCache classCache = context.getSession().getS4Cache().getS4ClassCache();
        DistanceCalculator calculator = new DistanceCalculator(classCache);
        RankedMethod bestMatch = null;
        for (Method method : this.methods) {
            RankedMethod rankedMethod = new RankedMethod(context, method, signature, calculator, useInheritance);
            if (!rankedMethod.isCandidate() || bestMatch != null && !rankedMethod.isBetterThan(bestMatch)) continue;
            bestMatch = rankedMethod;
        }
        this.cachedMethods.put(methodKey, bestMatch);
        return bestMatch;
    }
}

