/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.s4.S4Class;
import org.renjin.sexp.Frame;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class S4ClassCache {
    private Map<String, S4Class> classTable = null;

    S4ClassCache() {
    }

    private void initializeCache(Context context) {
        this.classTable = new HashMap<String, S4Class>();
        ArrayList<Frame> loaded2 = new ArrayList<Frame>();
        loaded2.add(context.getGlobalEnvironment().getFrame());
        for (Namespace namespace : context.getNamespaceRegistry().getLoadedNamespaces()) {
            loaded2.add(namespace.getNamespaceEnvironment().getFrame());
        }
        for (Frame frame2 : loaded2) {
            for (Symbol symbol2 : frame2.getSymbols()) {
                if (!symbol2.getPrintName().startsWith(".__C__")) continue;
                String className = symbol2.getPrintName().substring(".__C__".length());
                S4Object classRepresentation = (S4Object)frame2.getVariable(symbol2).force(context);
                this.classTable.put(className, new S4Class(classRepresentation));
            }
        }
    }

    public S4Class lookupClass(Context context, String className) {
        if (this.classTable == null) {
            this.initializeCache(context);
        }
        return this.classTable.get(className);
    }

    public boolean isSimple(String from, String to) {
        S4Class classDef = this.classTable.get(from);
        return classDef.isSimpleCoercion(to);
    }

    public SEXP coerceComplex(Context context, SEXP value, String from, String to) {
        S4Class classDef = this.classTable.get(from);
        return classDef.coerceTo(context, value, to);
    }
}

