/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.methods.MethodDispatch;
import org.renjin.methods.Methods;
import org.renjin.primitives.Primitives;
import org.renjin.s4.CallingArguments;
import org.renjin.s4.Generic;
import org.renjin.s4.RankedMethod;
import org.renjin.s4.S4Cache;
import org.renjin.s4.S4Class;
import org.renjin.s4.S4MethodCache;
import org.renjin.s4.S4MethodTable;
import org.renjin.s4.Signature;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class S4 {
    private static final String R_methods = "methods";
    private static final String R_package = "package";
    public static final String CLASS_PREFIX = ".__C__";
    public static final String METHOD_PREFIX = ".__T__";
    public static final Symbol CONTAINS = Symbol.get("contains");
    public static final Symbol SUBCLASSES = Symbol.get("subclasses");
    public static final Symbol DISTANCE = Symbol.get("distance");
    public static final Symbol COERCE = Symbol.get("coerce");
    public static final Symbol REPLACE = Symbol.get("replace");
    public static final Symbol BY = Symbol.get("by");
    public static final Symbol SIMPLE = Symbol.get("simple");
    public static final Symbol TEST = Symbol.get("test");
    public static final Symbol PACKAGE = Symbol.get("package");
    public static final Symbol GROUP = Symbol.get("group");

    private S4() {
        throw new IllegalStateException("'S4' is a utility class and cannot be instantiated.");
    }

    public static SEXP tryS4DispatchFromPrimitive(@Current Context context, SEXP source, PairList args2, Environment rho, String group, String opName) {
        Generic generic = group == null ? Generic.primitive(opName, new ArrayList<String>()) : Generic.primitive(opName, Collections.singletonList(group));
        S4MethodCache methodCache = context.getSession().getS4Cache().getS4MethodCache();
        S4MethodTable methodTable = methodCache.getMethod(context, generic, opName);
        if (methodTable == null || methodTable.isEmpty()) {
            return null;
        }
        CallingArguments arguments = CallingArguments.primitiveArguments(context, rho, methodTable.getArgumentMatcher(), source, args2);
        Signature signature = arguments.getSignature(methodTable.getMaximumSignatureLength());
        boolean[] useInheritance = new boolean[methodTable.getMaximumSignatureLength()];
        Arrays.fill(useInheritance, Boolean.TRUE);
        RankedMethod selectedMethod = methodTable.selectMethod(context, generic, signature, useInheritance);
        if (selectedMethod == null) {
            return null;
        }
        Closure function2 = selectedMethod.getMethodDefinition();
        PairList coercedArgs = Methods.coerce(context, arguments, selectedMethod);
        FunctionCall call2 = new FunctionCall(function2, args2);
        if (S4.dispatchWithoutMeta(opName, source, selectedMethod)) {
            return context.evaluate(call2);
        }
        Map<Symbol, SEXP> metadata = S4.generateCallMetaData(context, selectedMethod, signature, opName);
        return ClosureDispatcher.apply(context, rho, call2, function2, coercedArgs, metadata);
    }

    private static boolean dispatchWithoutMeta(String opName, SEXP source, RankedMethod rank2) {
        boolean hasS3Class = source.getAttribute(Symbol.get(".S3Class")).length() != 0;
        boolean genericExact = !rank2.getMethod().isGroupGeneric() && rank2.isExact();
        return !opName.contains("<-") && (genericExact || hasS3Class);
    }

    public static Map<Symbol, SEXP> generateCallMetaData(Context context, RankedMethod method, Signature signature, String opName) {
        HashMap<Symbol, SEXP> metadata = new HashMap<Symbol, SEXP>();
        metadata.put(MethodDispatch.R_dot_defined, S4.buildDotDefined(context, method));
        metadata.put(MethodDispatch.R_dot_target, S4.buildDotTarget(method, signature));
        metadata.put(MethodDispatch.DOT_GENERIC, method.getMethod().getGeneric().asSEXP());
        metadata.put(MethodDispatch.R_dot_Method, method.getMethodDefinition());
        if (Primitives.isBuiltin(opName)) {
            metadata.put(MethodDispatch.s_dot_Methods, Symbol.get(".Primitive(\"" + opName + "\")"));
        } else {
            metadata.put(MethodDispatch.s_dot_Methods, Null.INSTANCE);
        }
        return metadata;
    }

    private static SEXP buildDotTarget(RankedMethod method, Signature signature) {
        List<String> argumentClasses = signature.getClasses();
        ArrayList<String> argumentPackages = new ArrayList<String>(Collections.nCopies(argumentClasses.size(), R_methods));
        return new StringVector.Builder().addAll(argumentClasses).setAttribute("names", (SEXP)method.getMethod().getFormalNames()).setAttribute(R_package, (SEXP)new StringArrayVector((Collection<String>)argumentPackages)).setAttribute("class", S4.signatureClass()).build();
    }

    private static SEXP buildDotDefined(Context context, RankedMethod method) {
        List<String> argumentClasses = method.getMethod().getSignature().getClasses();
        ArrayList<String> argumentPackages = new ArrayList<String>();
        for (String argumentClass : argumentClasses) {
            argumentPackages.add(S4.getClassPackage(context, argumentClass));
        }
        return new StringVector.Builder().addAll(argumentClasses).setAttribute("names", (SEXP)method.getMethod().getFormalNames()).setAttribute(R_package, (SEXP)new StringArrayVector((Collection<String>)argumentPackages)).setAttribute("class", S4.signatureClass()).build();
    }

    private static SEXP signatureClass() {
        return StringVector.valueOf("signature").setAttribute(R_package, (SEXP)StringVector.valueOf(R_methods));
    }

    public static String getClassPackage(Context context, String objClass) {
        if ("ANY".equals(objClass) || "signature".equals(objClass)) {
            return R_methods;
        }
        S4Cache s4Cache = context.getSession().getS4Cache();
        S4Class s4Class = s4Cache.getS4ClassCache().lookupClass(context, objClass);
        SEXP classDef = s4Class.getDefinition();
        StringArrayVector packageSlot = (StringArrayVector)classDef.getAttribute(PACKAGE);
        return packageSlot.getElementAsString(0);
    }

    public static AtomicVector computeDataClassesS4(Context context, String objClass) {
        S4Class s4Class = context.getSession().getS4Cache().getS4ClassCache().lookupClass(context, objClass);
        if (s4Class != null) {
            return s4Class.getDefinition().getAttribute(CONTAINS).getNames();
        }
        return null;
    }

    public static Symbol classNameMetadata(String className) {
        return Symbol.get(CLASS_PREFIX + className);
    }

    @Internal
    public static void invalidateS4Cache(@Current Context context, String msg) {
        context.getSession().getS4Cache().invalidate();
    }

    @Internal
    public static void invalidateS4MethodCache(@Current Context context, String msg) {
        context.getSession().getS4Cache().invalidateMethodCache();
    }
}

