/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.s4.S4;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Generic {
    private static final Set<String> ARITH_GROUP = Sets.newHashSet("+", "-", "*", "^", "%%", "%/%", "/");
    private static final Set<String> COMPARE_GROUP = Sets.newHashSet("==", ">", "<", "!=", "<=", ">=");
    private static final Set<String> LOGIC_GROUP = Sets.newHashSet("!", "&", "&&", "|", "||", "xor");
    private final String name;
    private final String packageName;
    private final List<String> group;
    private final String subGroup;
    private final boolean stdGeneric;
    private final Closure genericFunction;

    public static Generic primitive(String name, List<String> group) {
        return new Generic(name, group, "base", null);
    }

    public static Generic standardGeneric(Context context, String fname, String packageName) {
        Closure genericFunction = Generic.findGenericFunction(context, fname, packageName);
        ArrayList<String> group = new ArrayList<String>();
        Environment namespaceEnv = Generic.getPackageNamespaceEnvironment(context, packageName);
        SEXP generic = namespaceEnv.getVariableUnsafe(fname).force(context);
        if (generic == Symbol.UNBOUND_VALUE) {
            return new Generic(fname, group, packageName, genericFunction);
        }
        if (Generic.isOps(fname)) {
            group.add("Ops");
        } else {
            int groupSize;
            SEXP groupSlot = generic.getAttribute(S4.GROUP);
            if (groupSlot instanceof ListVector && (groupSize = groupSlot.length()) > 0) {
                for (int i = 0; i < groupSize; ++i) {
                    group.add(((ListVector)groupSlot).getElementAsString(i));
                }
            }
        }
        return new Generic(fname, group, packageName, genericFunction);
    }

    private static Environment getPackageNamespaceEnvironment(Context context, String packageName) {
        Environment namespaceEnv = ".GlobalEnv".equals(packageName) ? context.getGlobalEnvironment() : context.getNamespaceRegistry().getNamespace(context, packageName).getNamespaceEnvironment();
        return namespaceEnv;
    }

    public static Closure findGenericFunction(Context context, String fname, String packageName) {
        StringArrayVector fclass;
        SEXP funClass;
        Closure genericFunction = null;
        Frame packageFrame = ".GlobalEnv".equals(packageName) ? context.getGlobalEnvironment().getFrame() : context.getNamespaceRegistry().getNamespace(context, packageName).getNamespaceEnvironment().getFrame();
        SEXP foundFunction = packageFrame.getVariable(Symbol.get(fname)).force(context);
        if (foundFunction instanceof Closure && (funClass = foundFunction.getAttribute(Symbols.CLASS)) instanceof StringArrayVector && ("standardGeneric".equals((fclass = (StringArrayVector)funClass).getElementAsString(0)) || "nonstandardGenericFunction".equals(fclass.getElementAsString(0)))) {
            genericFunction = (Closure)foundFunction;
        }
        return genericFunction;
    }

    public Generic(String name, List<String> groups, String packageName, Closure genericFunction) {
        this.name = Generic.applyAliases(name);
        this.packageName = packageName;
        this.group = groups;
        this.stdGeneric = true;
        this.genericFunction = genericFunction;
        this.subGroup = !this.group.isEmpty() && "Ops".equals(this.group.get(0)) ? Generic.opsSubGroupOf(name) : null;
    }

    private static String opsSubGroupOf(String name) {
        if (ARITH_GROUP.contains(name)) {
            return "Arith";
        }
        if (COMPARE_GROUP.contains(name)) {
            return "Compare";
        }
        if (LOGIC_GROUP.contains(name)) {
            return "Logic";
        }
        throw new IllegalArgumentException(name + " is not a member of the Ops group");
    }

    private static String applyAliases(String name) {
        if ("as.double".equals(name)) {
            return "as.numeric";
        }
        return name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGroupGeneric() {
        return this.group != null && this.group.size() > 0;
    }

    public boolean isStdGenericWithGroup() {
        return this.stdGeneric && this.group != null && this.group.size() > 0;
    }

    public Closure getGenericFunction() {
        return this.genericFunction;
    }

    public Set<String> getSignatureArgumentNames() {
        SEXP signature;
        if (this.genericFunction != null && (signature = this.genericFunction.getAttribute(Symbol.get("signature"))) instanceof StringArrayVector) {
            return new HashSet<String>(Arrays.asList(((StringArrayVector)signature).toArray()));
        }
        return new HashSet<String>();
    }

    public boolean isOps() {
        return ARITH_GROUP.contains(this.name) || COMPARE_GROUP.contains(this.name) || LOGIC_GROUP.contains(this.name);
    }

    public static boolean isOps(String fname) {
        return ARITH_GROUP.contains(fname) || COMPARE_GROUP.contains(fname) || LOGIC_GROUP.contains(fname);
    }

    public String getSubGroup() {
        assert (this.subGroup != null) : "not a member of the Ops group";
        return this.subGroup;
    }

    public List<String> getGroup() {
        return this.group;
    }

    Symbol getGenericMethodTableName() {
        return Symbol.get(".__T__" + this.name + ":" + this.packageName);
    }

    Symbol getGroupGenericMethodTableName() {
        assert (!this.group.isEmpty());
        return Symbol.get(".__T__" + this.group.get(0) + ":" + this.packageName);
    }

    Symbol getGroupStdGenericMethodTableName(String grp) {
        return Symbol.get(".__T__" + grp + ":" + this.packageName);
    }

    Symbol getSubGroupGenericMethodTableName() {
        assert (this.subGroup != null);
        if ("Compare".equals(this.subGroup)) {
            return Symbol.get(".__T__" + this.subGroup + ":methods");
        }
        return Symbol.get(".__T__" + this.subGroup + ":" + this.packageName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Generic generic = (Generic)o;
        return Objects.equals(this.name, generic.name) && Objects.equals(this.subGroup, generic.subGroup) && Objects.equals(this.group, generic.group);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.subGroup, this.group);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Generic{");
        s.append(this.name);
        if (this.isOps()) {
            s.append("/").append(this.subGroup);
        } else if (this.isGroupGeneric()) {
            s.append(this.group);
        }
        s.append("}");
        return s.toString();
    }

    public SEXP asSEXP() {
        StringVector.Builder builder = new StringVector.Builder();
        if (this.name.isEmpty()) {
            builder.add(this.group.get(0));
        } else {
            builder.add(this.name);
        }
        builder.setAttribute("package", (SEXP)StringVector.valueOf(this.packageName));
        return builder.build();
    }
}

