/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import org.renjin.eval.Context;
import org.renjin.s4.S4Class;
import org.renjin.s4.S4ClassCache;

public class DistanceCalculator {
    private static final int FAR_AWAY = 0x7FFFFFFE;
    private S4ClassCache classCache;

    public DistanceCalculator(S4ClassCache classCache) {
        this.classCache = classCache;
    }

    public int distance(Context context, String from, String to) {
        S4Class subclasses;
        if (to.equals("ANY")) {
            if (from.equals("missing")) {
                return Integer.MAX_VALUE;
            }
            return 0x7FFFFFFE;
        }
        S4Class providedClass = this.classCache.lookupClass(context, from);
        if (providedClass == null) {
            return -1;
        }
        int distanceToSuperClass = providedClass.extractDistanceFromS4Class(to);
        if (distanceToSuperClass == -1 && (subclasses = this.classCache.lookupClass(context, to)) != null && subclasses.isUnionClass()) {
            distanceToSuperClass = subclasses.getDistanceToUnionClass(from);
        }
        return distanceToSuperClass;
    }
}

