/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.escape;

import java.util.HashMap;
import java.util.Map;
import org.renjin.repackaged.guava.annotations.Beta;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.escape.CharEscaper;
import org.renjin.repackaged.guava.escape.Escaper;

@Beta
@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    public CharEscaperBuilder addEscape(char c2, String r) {
        this.map.put(Character.valueOf(c2), Preconditions.checkNotNull(r));
        if (c2 > this.max) {
            this.max = c2;
        }
        return this;
    }

    public CharEscaperBuilder addEscapes(char[] cs, String r) {
        Preconditions.checkNotNull(r);
        for (char c2 : cs) {
            this.addEscape(c2, r);
        }
        return this;
    }

    public char[][] toArray() {
        char[][] result = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            result[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return result;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static class CharArrayDecorator
    extends CharEscaper {
        private final char[][] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[][] replacements) {
            this.replacements = replacements;
            this.replaceLength = replacements.length;
        }

        @Override
        public String escape(String s) {
            int slen = s.length();
            for (int index = 0; index < slen; ++index) {
                char c2 = s.charAt(index);
                if (c2 >= this.replacements.length || this.replacements[c2] == null) continue;
                return this.escapeSlow(s, index);
            }
            return s;
        }

        @Override
        protected char[] escape(char c2) {
            return c2 < this.replaceLength ? this.replacements[c2] : null;
        }
    }
}

