/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.collect;

import javax.annotation.Nullable;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.ImmutableList;
import org.renjin.repackaged.guava.collect.Iterators;
import org.renjin.repackaged.guava.collect.UnmodifiableListIterator;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] array2, int offset, int size) {
        this.offset = offset;
        this.size = size;
        this.array = array2;
    }

    RegularImmutableList(Object[] array2) {
        this(array2, 0, array2.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    boolean isPartialView() {
        return this.size != this.array.length;
    }

    @Override
    int copyIntoArray(Object[] dst, int dstOff) {
        System.arraycopy(this.array, this.offset, dst, dstOff, this.size);
        return dstOff + this.size;
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        return (E)this.array[index + this.offset];
    }

    @Override
    public int indexOf(@Nullable Object object2) {
        if (object2 == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.array[this.offset + i].equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object2) {
        if (object2 == null) {
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.array[this.offset + i].equals(object2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        return new RegularImmutableList<E>(this.array, this.offset + fromIndex, toIndex - fromIndex);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return Iterators.forArray(this.array, this.offset, this.size, index);
    }
}

