/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

class ZeroBasedWeekday
implements TemporalField {
    public static final ZeroBasedWeekday INSTANCE = new ZeroBasedWeekday();

    private ZeroBasedWeekday() {
    }

    @Override
    public TemporalUnit getBaseUnit() {
        return ChronoField.DAY_OF_WEEK.getBaseUnit();
    }

    @Override
    public TemporalUnit getRangeUnit() {
        return ChronoField.DAY_OF_WEEK.getRangeUnit();
    }

    @Override
    public ValueRange range() {
        return ValueRange.of(0L, 6L);
    }

    @Override
    public boolean isDateBased() {
        return ChronoField.DAY_OF_WEEK.isDateBased();
    }

    @Override
    public boolean isTimeBased() {
        return ChronoField.DAY_OF_WEEK.isTimeBased();
    }

    @Override
    public boolean isSupportedBy(TemporalAccessor temporal) {
        return temporal.isSupported(ChronoField.DAY_OF_WEEK);
    }

    @Override
    public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
        return this.range();
    }

    @Override
    public long getFrom(TemporalAccessor temporal) {
        int dayOfWeek = temporal.get(ChronoField.DAY_OF_WEEK);
        if (dayOfWeek == 7) {
            return 0L;
        }
        return dayOfWeek;
    }

    @Override
    public <R extends Temporal> R adjustInto(R temporal, long newValue) {
        if (newValue == 0L) {
            newValue = 7L;
        }
        return ChronoField.DAY_OF_WEEK.adjustInto(temporal, newValue);
    }
}

