/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.primitives.time.RDateTimeFormatter;
import org.renjin.primitives.time.ZeroBasedWeekday;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.StringVector;

public class RDateTimeFormats {
    private RDateTimeFormats() {
    }

    public static RDateTimeFormatter forPattern(String pattern, boolean useTz, ZoneId timeZone) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseLenient();
        boolean hasTime = false;
        boolean hasZone = false;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == '%' && i + 1 < pattern.length()) {
                char specifier = pattern.charAt(++i);
                block0 : switch (specifier) {
                    case '%': {
                        builder.appendLiteral("%");
                        break;
                    }
                    case 'a': {
                        builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT);
                        break;
                    }
                    case 'A': {
                        builder.appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.FULL);
                        break;
                    }
                    case 'b': {
                        builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT);
                        break;
                    }
                    case 'B': {
                        builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.FULL);
                        break;
                    }
                    case 'c': {
                        throw new UnsupportedOperationException("%c not yet implemented");
                    }
                    case 'd': {
                        builder.appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'H': {
                        hasTime = true;
                        builder.appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'I': {
                        hasTime = true;
                        builder.appendValue(ChronoField.CLOCK_HOUR_OF_AMPM, 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'j': {
                        builder.appendValue(ChronoField.DAY_OF_YEAR, 3, 3, SignStyle.NEVER);
                        break;
                    }
                    case 'm': {
                        builder.appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'M': {
                        hasTime = true;
                        builder.appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'n': {
                        builder.appendLiteral('\n');
                        break;
                    }
                    case 'p': {
                        builder.appendText((TemporalField)ChronoField.AMPM_OF_DAY, TextStyle.SHORT);
                        break;
                    }
                    case 'O': {
                        if (i + 1 >= pattern.length()) {
                            builder.appendLiteral("%O");
                            break;
                        }
                        switch (pattern.charAt(++i)) {
                            case 'S': {
                                builder.appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NEVER);
                                break block0;
                            }
                        }
                        throw new EvalException("%O[dHImMUVwWy] not yet implemented", new Object[0]);
                    }
                    case 'S': {
                        builder.appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'U': {
                        builder.appendValue(WeekFields.of(DayOfWeek.SUNDAY, 7).weekOfYear(), 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'w': {
                        builder.appendValue(ZeroBasedWeekday.INSTANCE);
                        break;
                    }
                    case 'W': {
                        builder.appendValue(WeekFields.of(DayOfWeek.MONDAY, 7).weekOfYear(), 2, 2, SignStyle.NEVER);
                        break;
                    }
                    case 'x': {
                        builder.append(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
                        break;
                    }
                    case 'X': {
                        builder.append(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT));
                        break;
                    }
                    case 'y': {
                        builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.of(1968, 1, 1));
                        break;
                    }
                    case 'Y': {
                        builder.appendValue(ChronoField.YEAR, 4, 4, SignStyle.NEVER);
                        break;
                    }
                    case 'z': {
                        hasZone = true;
                        builder.appendOffset("+HHMM", "+0000");
                        break;
                    }
                    case 'Z': {
                        hasZone = true;
                        builder.appendZoneText(TextStyle.SHORT);
                        break;
                    }
                    default: {
                        throw new EvalException("%" + specifier + " not yet implemented. (Implement me!)", new Object[0]);
                    }
                }
                continue;
            }
            builder.appendLiteral(pattern.substring(i, i + 1));
        }
        if (useTz) {
            hasZone = true;
            builder.appendLiteral(" ");
            builder.appendZoneText(TextStyle.SHORT);
        }
        return new RDateTimeFormatter(pattern, builder.toFormatter(), hasTime, hasZone, timeZone);
    }

    public static RDateTimeFormatter forPattern(String pattern) {
        return RDateTimeFormats.forPattern(pattern, false, ZoneId.systemDefault());
    }

    public static List<RDateTimeFormatter> forPatterns(StringVector patterns, boolean useTz, ZoneId timeZone) {
        ArrayList<RDateTimeFormatter> formatters = Lists.newArrayListWithCapacity(patterns.length());
        for (String format2 : patterns) {
            formatters.add(RDateTimeFormats.forPattern(format2, useTz, timeZone));
        }
        return formatters;
    }
}

