/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.renjin.primitives.time.Time;
import org.renjin.primitives.time.TimeVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbols;

public class PosixCtVector
extends TimeVector {
    private final AtomicVector vector;
    private final ZoneId dateTimeZone;

    public PosixCtVector(AtomicVector vector2) {
        this.vector = vector2;
        this.dateTimeZone = Time.timeZoneFromPosixObject(vector2);
    }

    @Override
    public int length() {
        return this.vector.length();
    }

    @Override
    public ZonedDateTime getElementAsDateTime(int i) {
        return Instant.ofEpochSecond((long)this.vector.getElementAsDouble(i)).atZone(this.dateTimeZone);
    }

    public static class Builder {
        private final DoubleArrayVector.Builder vector;

        public Builder() {
            this.vector = new DoubleArrayVector.Builder();
        }

        public Builder setTimeZone(SEXP timeZoneAttribute) {
            this.vector.setAttribute(Symbols.TZONE, timeZoneAttribute);
            return this;
        }

        public Builder(int initialCapacity) {
            this.vector = new DoubleArrayVector.Builder(0, initialCapacity);
        }

        public Builder add(ZonedDateTime dateTime) {
            if (dateTime == null) {
                this.vector.add(DoubleVector.NA);
            } else {
                this.vector.add(dateTime.toInstant().getEpochSecond());
            }
            return this;
        }

        public Builder addNA() {
            this.vector.addNA();
            return this;
        }

        public Builder addAll(Iterable<ZonedDateTime> dateTimes) {
            for (ZonedDateTime dateTime : dateTimes) {
                this.add(dateTime);
            }
            return this;
        }

        public DoubleVector buildDoubleVector() {
            this.vector.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("POSIXct", "POSIXt"));
            return this.vector.build();
        }
    }
}

