/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text;

import org.renjin.eval.EvalException;
import org.renjin.gcc.format.FormatInput;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;

public class VectorFormatInput
implements FormatInput {
    private final AtomicVector[] vectors;
    private final int[] vectorLengths;
    private int index;

    public VectorFormatInput(AtomicVector[] vectors) {
        this.vectors = vectors;
        this.vectorLengths = new int[vectors.length];
        for (int i = 0; i < vectors.length; ++i) {
            this.vectorLengths[i] = vectors[i].length();
        }
    }

    public void next() {
        ++this.index;
    }

    @Override
    public boolean isNA(int argumentIndex) {
        return this.vectors[argumentIndex].isElementNA(this.elementIndex(argumentIndex));
    }

    @Override
    public int getInt(int argumentIndex) {
        AtomicVector vector2 = this.vectors[argumentIndex];
        int index = this.elementIndex(argumentIndex);
        if (vector2 instanceof DoubleVector) {
            return (int)this.checkInt(vector2.getElementAsDouble(index));
        }
        return vector2.getElementAsInt(index);
    }

    private int elementIndex(int argumentIndex) {
        return this.index % this.vectorLengths[argumentIndex];
    }

    @Override
    public long getLong(int argumentIndex) {
        AtomicVector vector2 = this.vectors[argumentIndex];
        int index = this.elementIndex(argumentIndex);
        if (vector2 instanceof DoubleVector) {
            return (long)this.checkInt(vector2.getElementAsDouble(index));
        }
        return vector2.getElementAsInt(index);
    }

    @Override
    public long getUnsignedLong(int argumentIndex) {
        AtomicVector vector2 = this.vectors[argumentIndex];
        int index = this.elementIndex(argumentIndex);
        if (vector2 instanceof DoubleVector) {
            return (long)this.checkInt(vector2.getElementAsDouble(index));
        }
        return Integer.toUnsignedLong(vector2.getElementAsInt(index));
    }

    @Override
    public double getDouble(int argumentIndex) {
        return this.vectors[argumentIndex].getElementAsDouble(this.elementIndex(argumentIndex));
    }

    @Override
    public String getString(int argumentIndex) {
        return this.vectors[argumentIndex].getElementAsString(this.elementIndex(argumentIndex));
    }

    private double checkInt(double x) {
        if (!Double.isFinite(x) || Math.floor(x) != x) {
            throw new EvalException("invalid integral format; use format %f, %e, %g or %a for numeric objects", new Object[0]);
        }
        return x;
    }
}

