/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset.lazy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.repackaged.guava.primitives.Ints;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.Vector;

public class ShadedRowMatrix
extends DoubleVector
implements MemoizedComputation {
    private Vector base = null;
    private int columnLength = 1;
    private Map<Integer, Vector> rowMap = new HashMap<Integer, Vector>();
    private double[] result;

    public ShadedRowMatrix(Vector source) {
        super(source.getAttributes());
        this.base = source;
        int[] dimr = this.base.getAttributes().getDimArray();
        this.columnLength = dimr[0];
    }

    public ShadedRowMatrix withShadedRow(int row2, Vector elements) {
        return this.cloneWithNewAttributes(this.getAttributes()).setShadedRow(row2, elements);
    }

    public ShadedRowMatrix setShadedRow(int row2, Vector elements) {
        this.rowMap.put(row2, elements);
        return this;
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    protected ShadedRowMatrix cloneWithNewAttributes(AttributeMap attributes2) {
        ShadedRowMatrix clone = new ShadedRowMatrix(this.base);
        clone.rowMap = new HashMap<Integer, Vector>(this.rowMap);
        return clone;
    }

    @Override
    public double getElementAsDouble(int index) {
        int col2 = index / this.columnLength;
        int row2 = index % this.columnLength;
        if (this.rowMap.containsKey(row2)) {
            return this.rowMap.get(row2).getElementAsDouble(col2);
        }
        return this.base.getElementAsDouble(index);
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public Vector[] getOperands() {
        ArrayList<Vector> ops = new ArrayList<Vector>();
        ops.add(this.base);
        ops.add(new IntArrayVector(Ints.toArray(this.rowMap.keySet())));
        ops.addAll(this.rowMap.values());
        return ops.toArray(new Vector[ops.size()]);
    }

    @Override
    public String getComputationName() {
        return "ShadedRowMatrix";
    }

    @Override
    public Vector forceResult() {
        double[] matrix2 = new double[this.length()];
        this.base.copyTo(matrix2, 0, this.length());
        int rowLength = this.length() / this.columnLength;
        for (Map.Entry<Integer, Vector> entry : this.rowMap.entrySet()) {
            int rowIndex;
            Vector vector2 = entry.getValue();
            int index = rowIndex = entry.getKey().intValue();
            for (int i = 0; i < rowLength; ++i) {
                matrix2[index] = vector2.getElementAsDouble(i);
                index += this.columnLength;
            }
        }
        this.result = matrix2;
        return DoubleArrayVector.unsafe(matrix2, this.getAttributes());
    }

    @Override
    public void setResult(Vector result) {
        this.result = ((DoubleArrayVector)result).toDoubleArrayUnsafe();
    }

    @Override
    public boolean isCalculated() {
        return this.result != null;
    }

    @Override
    public boolean isDeferred() {
        return !this.isCalculated();
    }
}

