/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.primitives.subset.SubsetAssertions;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.util.NamesBuilder;

class NamedSelection
implements SelectionStrategy {
    private static final int NOT_FOUND = -1;
    private static final int MULTIPLE_PARTIAL_MATCHES = -2;
    private StringVector selectedNames;

    public NamedSelection(StringVector selectedNames) {
        this.selectedNames = selectedNames;
    }

    @Override
    public SEXP getVectorSubset(Context context, Vector source, boolean drop2) {
        boolean resultHasNames;
        Map<String, Integer> nameMap = this.buildNameMap(source);
        Vector.Builder result = source.newBuilderWithInitialCapacity(this.selectedNames.length());
        StringVector.Builder resultNames = new StringVector.Builder();
        boolean anyMatching = false;
        for (int i = 0; i < this.selectedNames.length(); ++i) {
            String selectedName = this.selectedNames.getElementAsString(i);
            Integer index = null;
            if (!StringVector.isNA(selectedName)) {
                index = nameMap.get(selectedName);
            }
            if (index == null) {
                result.addNA();
                resultNames.addNA();
                continue;
            }
            result.addFrom(source, index);
            resultNames.add(selectedName);
            anyMatching = true;
        }
        boolean oneDimensionalArray = source.getAttributes().getDim().length() == 1;
        boolean bl = resultHasNames = anyMatching || source.hasNames();
        if (oneDimensionalArray && (!drop2 || result.length() > 1)) {
            result.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(result.length()));
            if (resultHasNames) {
                result.setAttribute(Symbols.DIMNAMES, (SEXP)new ListVector(resultNames.build()));
            }
        } else if (resultHasNames) {
            result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
        }
        return result.build();
    }

    @Override
    public ListVector replaceListElements(Context context, ListVector source, Vector replacements) {
        if (replacements == Null.INSTANCE) {
            return this.removeListElements(source);
        }
        Map<String, Integer> nameMap = this.buildNameMap(source);
        Vector.Builder result = source.newCopyBuilder(replacements.getVectorType());
        NamesBuilder resultNames = NamesBuilder.clonedFrom(source);
        int replacementIndex = 0;
        int replacementLength = replacements.length();
        for (int i = 0; i < this.selectedNames.length(); ++i) {
            String selectedName = this.selectedNames.getElementAsString(i);
            Integer index = nameMap.get(selectedName);
            if (index != null) {
                result.setFrom(index, replacements, replacementIndex++);
            } else {
                int newIndex = result.length();
                if (replacements.length() == 0) {
                    throw new EvalException("replacement has zero length", new Object[0]);
                }
                result.setFrom(newIndex, replacements, replacementIndex++);
                resultNames.add(selectedName);
                nameMap.put(selectedName, newIndex);
            }
            if (replacementIndex < replacementLength) continue;
            replacementIndex = 0;
        }
        if (replacementIndex != 0) {
            throw new EvalException("number of items to replace is not a multiple of replacement length", new Object[0]);
        }
        result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
        result.removeAttribute(Symbols.DIM);
        result.removeAttribute(Symbols.DIMNAMES);
        return (ListVector)result.build();
    }

    private ListVector removeListElements(ListVector source) {
        if (!source.hasNames()) {
            AttributeMap.Builder newAttributes = source.getAttributes().copy();
            newAttributes.remove(Symbols.DIM);
            newAttributes.remove(Symbols.DIMNAMES);
            return (ListVector)source.setAttributes(newAttributes);
        }
        HashSet<String> selectedSet = Sets.newHashSet();
        for (String selectedName : this.selectedNames) {
            selectedSet.add(selectedName);
        }
        ListVector.NamedBuilder result = ListVector.newNamedBuilder();
        StringVector sourceNames = (StringVector)source.getNames();
        for (int i = 0; i < source.length(); ++i) {
            String sourceName = sourceNames.getElementAsString(i);
            if (selectedSet.contains(sourceName)) {
                selectedSet.remove(sourceName);
                continue;
            }
            result.add(sourceName, source.getElementAsSEXP(i));
        }
        for (Symbol attribute : source.getAttributes().names()) {
            if (attribute == Symbols.DIMNAMES || attribute == Symbols.DIM || attribute == Symbols.NAMES) continue;
            result.setAttribute(attribute, source.getAttribute(attribute));
            result.setAttribute(attribute, source.getAttribute(attribute));
        }
        return result.build();
    }

    @Override
    public Vector replaceAtomicVectorElements(Context context, AtomicVector source, Vector replacements) {
        StringVector.Builder resultNames;
        if (this.selectedNames.length() == 0) {
            AttributeMap.Builder newAttributes = source.getAttributes().copy();
            newAttributes.remove(Symbols.DIM);
            newAttributes.remove(Symbols.DIMNAMES);
            return (Vector)source.setAttributes(newAttributes);
        }
        Vector.Builder result = source.newCopyBuilder(replacements.getVectorType());
        AtomicVector sourceNames = source.getNames();
        if (sourceNames != Null.INSTANCE) {
            resultNames = new StringVector.Builder((StringVector)sourceNames);
        } else {
            resultNames = new StringVector.Builder(0, source.length());
            for (int i = 0; i < source.length(); ++i) {
                resultNames.add("");
            }
        }
        Map<String, Integer> nameMap = this.buildNameMap(source);
        int replacementIndex = 0;
        int replacementLength = replacements.length();
        for (int i = 0; i < this.selectedNames.length(); ++i) {
            String selectedName = this.selectedNames.getElementAsString(i);
            if (StringVector.isNA(selectedName) || selectedName.isEmpty()) {
                result.addFrom(replacements, replacementIndex++);
                resultNames.add(selectedName);
            } else {
                Integer index = nameMap.get(selectedName);
                if (index != null) {
                    result.setFrom(index, replacements, replacementIndex++);
                } else {
                    int newIndex = result.length();
                    result.setFrom(newIndex, replacements, replacementIndex++);
                    resultNames.add(selectedName);
                    nameMap.put(selectedName, newIndex);
                }
            }
            if (replacementIndex < replacementLength) continue;
            replacementIndex = 0;
        }
        if (replacementIndex != 0) {
            context.warn("number of items to replace is not a multiple of replacement length");
        }
        result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
        result.removeAttribute(Symbols.DIM);
        result.removeAttribute(Symbols.DIMNAMES);
        return result.build();
    }

    private Map<String, Integer> buildNameMap(Vector source) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        AtomicVector names2 = source.getNames();
        if (names2 instanceof StringVector) {
            for (int i = 0; i < names2.length(); ++i) {
                String name = names2.getElementAsString(i);
                if (map.containsKey(name)) continue;
                map.put(name, i);
            }
        }
        return map;
    }

    @Override
    public SEXP getSingleListElement(ListVector source, boolean exact) {
        int index = this.findSelectedElement(source, exact);
        if (index == -1) {
            return Null.INSTANCE;
        }
        return source.getElementAsSEXP(index);
    }

    @Override
    public AtomicVector getSingleAtomicVectorElement(AtomicVector source, boolean exact) {
        int index = this.findSelectedElement(source, exact);
        if (index == -1) {
            throw SubsetAssertions.outOfBounds();
        }
        return (AtomicVector)source.getElementAsSEXP(index);
    }

    private int findSelectedElement(Vector source, boolean exact) {
        String selectedName = this.computeUniqueSelectedName();
        AtomicVector names2 = source.getNames();
        if (names2 == Null.INSTANCE) {
            return -1;
        }
        if (StringVector.isNA(selectedName)) {
            return -1;
        }
        int partialMatch = -1;
        for (int i = 0; i != names2.length(); ++i) {
            String name = names2.getElementAsString(i);
            if (StringVector.isNA(name)) continue;
            if (name.equals(selectedName)) {
                return i;
            }
            if (exact || !name.startsWith(selectedName)) continue;
            partialMatch = partialMatch == -1 ? i : -2;
        }
        if (partialMatch >= 0) {
            return partialMatch;
        }
        return -1;
    }

    @Override
    public ListVector replaceSingleListElement(ListVector source, SEXP replacement) {
        boolean deleting;
        String selectedName = this.computeUniqueSelectedName();
        int selectedIndex = source.indexOfName(selectedName);
        boolean matched = selectedIndex != -1;
        boolean bl = deleting = replacement == Null.INSTANCE;
        if (deleting && !matched) {
            return source;
        }
        ListVector.NamedBuilder result = source.newCopyNamedBuilder();
        boolean deformed = false;
        if (deleting) {
            result.remove(selectedIndex);
            deformed = true;
        } else if (matched) {
            result.set(selectedIndex, replacement);
        } else {
            result.add(selectedName, replacement);
            deformed = true;
        }
        if (deformed) {
            result.removeAttribute(Symbols.DIM);
            result.removeAttribute(Symbols.DIMNAMES);
        }
        return result.build();
    }

    @Override
    public SEXP replaceSinglePairListElement(PairList.Node source, SEXP replacement) {
        String selectedName = this.computeUniqueSelectedName();
        boolean found = false;
        PairList.Builder newList = source instanceof FunctionCall ? new FunctionCall.Builder() : new PairList.Builder();
        for (PairList.Node node : source.nodes()) {
            if (!found && node.hasTag() && node.getTag().getPrintName().equals(selectedName)) {
                if (replacement != Null.INSTANCE) {
                    newList.add(node.getTag(), replacement);
                }
                found = true;
                continue;
            }
            newList.add(node.getRawTag(), node.getValue());
        }
        if (!found && replacement != Null.INSTANCE) {
            newList.add(selectedName, replacement);
        }
        return newList.build();
    }

    @Override
    public Vector replaceSingleElement(Context context, AtomicVector source, Vector replacements) {
        if (replacements.length() != 1) {
            throw new EvalException("number of items to replace is not a multiple of replacement length", new Object[0]);
        }
        String selectedName = this.computeUniqueSelectedName();
        int selectedIndex = source.getIndexByName(selectedName);
        boolean matched = selectedIndex != -1;
        Vector.Builder result = source.newCopyBuilder(replacements.getVectorType());
        NamesBuilder resultNames = NamesBuilder.clonedFrom(source);
        boolean deformed = false;
        if (matched) {
            result.setFrom(selectedIndex, replacements, 0);
        } else {
            result.addFrom(replacements, 0);
            resultNames.add(selectedName);
            deformed = true;
        }
        if (deformed) {
            result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
            result.removeAttribute(Symbols.DIM);
            result.removeAttribute(Symbols.DIMNAMES);
        }
        return result.build();
    }

    private String computeUniqueSelectedName() {
        SubsetAssertions.checkUnitLength(this.selectedNames);
        return this.selectedNames.getElementAsString(0);
    }
}

